/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaFileStat;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.util.Platform;

public class JavaPOSIX
implements POSIX {
    POSIXHandler handler;
    JavaLibCHelper helper;

    public JavaPOSIX(POSIXHandler handler) {
        this.handler = handler;
        this.helper = new JavaLibCHelper(handler);
    }

    public FileStat allocateStat() {
        return new JavaFileStat(this, this.handler);
    }

    public int chmod(String filename, int mode) {
        return this.helper.chmod(filename, mode);
    }

    public int chown(String filename, int user, int group) {
        return this.helper.chown(filename, user, group);
    }

    public FileStat fstat(FileDescriptor descriptor) {
        this.handler.unimplementedError("fstat unimplemented");
        return null;
    }

    public int getegid() {
        return GIDHolder.GID;
    }

    public int geteuid() {
        return UIDHolder.UID;
    }

    public int getgid() {
        return GIDHolder.GID;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int getpgid() {
        return this.unimplementedInt("getpgid");
    }

    public int getpgrp() {
        return this.unimplementedInt("getpgrp");
    }

    public int getpid() {
        return this.helper.getpid();
    }

    public int getppid() {
        return this.unimplementedInt("getppid");
    }

    public Passwd getpwent() {
        return this.helper.getpwent();
    }

    public Passwd getpwuid(int which) {
        this.handler.unimplementedError("getpwuid unimplemented");
        return null;
    }

    public Group getgrgid(int which) {
        this.handler.unimplementedError("getgrgid unimplemented");
        return null;
    }

    public Passwd getpwnam(String which) {
        this.handler.unimplementedError("getpwnam unimplemented");
        return null;
    }

    public Group getgrnam(String which) {
        this.handler.unimplementedError("getgrnam unimplemented");
        return null;
    }

    public Group getgrent() {
        this.handler.unimplementedError("getgrent unimplemented");
        return null;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public int setgrent() {
        return this.unimplementedInt("setgrent");
    }

    public int endgrent() {
        return this.unimplementedInt("endgrent");
    }

    public int getuid() {
        return UIDHolder.UID;
    }

    public int fork() {
        return -1;
    }

    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }

    public int kill(int pid, int signal) {
        return this.unimplementedInt("kill");
    }

    public int lchmod(String filename, int mode) {
        return this.unimplementedInt("lchmod");
    }

    public int lchown(String filename, int user, int group) {
        return this.unimplementedInt("lchown");
    }

    public int link(String oldpath, String newpath) {
        return this.helper.link(oldpath, newpath);
    }

    public FileStat lstat(String path) {
        FileStat stat = this.allocateStat();
        if (this.helper.lstat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int mkdir(String path, int mode) {
        return this.helper.mkdir(path, mode);
    }

    public String readlink(String path) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(256);
        int result = this.helper.readlink(path, buffer, buffer.capacity());
        if (result == -1) {
            return null;
        }
        buffer.position(0);
        buffer.limit(result);
        return Charset.forName("ASCII").decode(buffer).toString();
    }

    public FileStat stat(String path) {
        FileStat stat = this.allocateStat();
        if (this.helper.stat(path, stat) < 0) {
            this.handler.error(POSIX.ERRORS.ENOENT, path);
        }
        return stat;
    }

    public int symlink(String oldpath, String newpath) {
        return this.helper.symlink(oldpath, newpath);
    }

    public int setegid(int egid) {
        return this.unimplementedInt("setegid");
    }

    public int seteuid(int euid) {
        return this.unimplementedInt("seteuid");
    }

    public int setgid(int gid) {
        return this.unimplementedInt("setgid");
    }

    public int getpgid(int pid) {
        return this.unimplementedInt("getpgid");
    }

    public int setpgid(int pid, int pgid) {
        return this.unimplementedInt("setpgid");
    }

    public int setpgrp(int pid, int pgrp) {
        return this.unimplementedInt("setpgrp");
    }

    public int setsid() {
        return this.unimplementedInt("setsid");
    }

    public int setuid(int uid) {
        return this.unimplementedInt("setuid");
    }

    public int umask(int mask) {
        return 0;
    }

    public int utimes(String path, long[] atimeval, long[] mtimeval) {
        long mtimeMillis;
        if (mtimeval != null) {
            assert (mtimeval.length == 2);
            mtimeMillis = mtimeval[0] * 1000L + mtimeval[1] / 1000L;
        } else {
            mtimeMillis = System.currentTimeMillis();
        }
        new File(path).setLastModified(mtimeMillis);
        return 0;
    }

    public int wait(int[] status) {
        return this.unimplementedInt("wait");
    }

    public int waitpid(int pid, int[] status, int flags) {
        return this.unimplementedInt("waitpid");
    }

    public int getpriority(int which, int who) {
        return this.unimplementedInt("getpriority");
    }

    public int setpriority(int which, int who, int prio) {
        return this.unimplementedInt("setpriority");
    }

    private int unimplementedInt(String message) {
        this.handler.unimplementedError(message);
        return -1;
    }

    private static final class IDHelper {
        private static final String ID_CMD = Platform.IS_SOLARIS ? "/usr/xpg4/bin/id" : "/usr/bin/id";
        private static final int NOBODY = Platform.IS_WINDOWS ? 0 : Short.MAX_VALUE;

        private IDHelper() {
        }

        public static int getID(String option) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{ID_CMD, option});
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                return Integer.parseInt(r.readLine());
            }
            catch (IOException ex) {
                return NOBODY;
            }
            catch (NumberFormatException ex) {
                return NOBODY;
            }
        }
    }

    private static final class GIDHolder {
        public static final int GID = IDHelper.getID("-g");

        private GIDHolder() {
        }
    }

    private static final class UIDHolder {
        public static final int UID = IDHelper.getID("-u");

        private UIDHolder() {
        }
    }
}

