package aQute.bnd.url;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.jar.*;
import java.util.regex.*;

import aQute.lib.osgi.*;

public class BndConnection extends URLConnection {
	final static String	REPOSITORIES_KEY		= "biz.aQute.bnd.maven.repositories";
	final static String	DEFAULT_REPOSITORIES	= "http://repo.mergere.com/maven2/, http://download.java.net/maven/2/,http://repo1.maven.org/maven2/";
	final static String	GROUP_ID				= "(.+?)";
	final static String	ARTIFACT_ID				= "(\\.(\\w+))";
	final static String	VERSION					= "(([0-9]+(\\.[0-9]+)*)(.*))";

	BndConnection(URL url) {
		super(url);
	}

	Pattern	FILE_NAME	= Pattern.compile("(.*/)*(.+?)(-(.+))?");

	public InputStream getInputStream() throws IOException {
		Properties properties = new Properties();
		String path = getURL().getPath();
		String query = getURL().getQuery();
		InputStream target = null;
		try {
			URL url = new URL(path);
			String file = getURL().getFile();
			if (file.endsWith(".jar"))
				file = file.substring(0, file.length() - 4);
			target = url.openStream();
			Matcher m = FILE_NAME.matcher(file);
			if (m.matches()) {
				properties.put(Analyzer.BUNDLE_SYMBOLICNAME, m.group(2));
				String version = m.group(4);
				if (version != null) {
					properties.put(Analyzer.BUNDLE_VERSION, version);
				}
			}
		} catch (MalformedURLException e) {
			String parts[] = parseMaven(path);
			target = openMaven(parts[0], parts[1], parts[2]);
			properties.put(Analyzer.BUNDLE_SYMBOLICNAME, parts[0] + "."
					+ parts[1]);
			if (parts[2] != null)
				properties.put(Analyzer.BUNDLE_VERSION, parts[2]);
		}

		final Jar jar = new Jar("dot", target);
		Manifest manifest = jar.getManifest();

		// Verify it is not a bundle
		if (manifest == null
				|| (manifest.getMainAttributes().getValue(
						Analyzer.EXPORT_PACKAGE) == null && manifest
						.getMainAttributes().getValue(Analyzer.IMPORT_PACKAGE) == null)) {

			properties.put("Bnd-URL", getURL().toExternalForm());

			if (query != null && query.length() > 0) {
				Pattern q = Pattern
						.compile("(\\w+)\\s*=\\s([-!\"'()*+,.0-9A-Z_a-z%]+)");
				String split[] = query.split("\\s*&\\s*");
				for (int i = 0; i < split.length; i++) {
					String expr = split[i];
					Matcher z = q.matcher(expr);
					if (z.matches()) {
						String value = URLDecoder.decode(z.group(2), "UTF-8");
						properties.put(z.group(1), value);
					}
				}
			}

			Analyzer analyzer = new Analyzer();
			analyzer.setJar(jar);
			analyzer.setProperties(properties);

			if (analyzer.getProperty(Analyzer.IMPORT_PACKAGE) == null)
				analyzer.setProperty(Analyzer.IMPORT_PACKAGE,
						"*;resolution:=optional");

			if (analyzer.getProperty(Analyzer.EXPORT_PACKAGE) == null) {
				String export = analyzer.calculateExportsFromContents(jar);
				analyzer.setProperty(Analyzer.EXPORT_PACKAGE, export);
			}

			if (analyzer.getProperty(Analyzer.BUNDLE_SYMBOLICNAME) == null) {
				analyzer.setProperty(Analyzer.BUNDLE_SYMBOLICNAME, "U"
						+ System.currentTimeMillis());
			}

			analyzer.mergeManifest(manifest);
			analyzer.calcManifest();
		}
		final PipedInputStream pin = new PipedInputStream();
		final PipedOutputStream pout = new PipedOutputStream(pin);
		Thread t = new Thread() {
			public void run() {
				try {
					jar.write(pout);
				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					try {
						jar.close();
						pout.close();
					} catch (IOException e) {
						// Ignore
					}
				}
			}
		};
		t.start();
		return pin;
	}

	final static Pattern	maven	= Pattern.compile(GROUP_ID + ARTIFACT_ID
											+ "(-" + VERSION + ")?");

	private String[] parseMaven(String path) throws FileNotFoundException {
		Matcher m = maven.matcher(path);
		if (!m.matches())
			throw new FileNotFoundException(
					"Invalid format for <groupid>.<artifactid>-<version>: "
							+ path);

		String[] parts = new String[3];
		parts[0] = m.group(1);
		parts[1] = m.group(3);
		parts[2] = m.group(6);
		return parts;
	}

	private InputStream openMaven(String groupId, String artifactId,
			String version) throws FileNotFoundException {
		String repos = System.getProperty(REPOSITORIES_KEY);
		if (repos == null)
			repos = DEFAULT_REPOSITORIES;

		String split[] = repos.split("\\s*,\\s*");
		for (int i = 0; i < split.length; i++) {
			try {
				URL url = new URL(split[i]);
				String tpath = groupId.replace('.', '/') + "/" + artifactId
						+ "/" + version + "/" + artifactId + "-" + version
						+ ".jar";
				URL target = new URL(url, tpath);
				return target.openStream();
			} catch (Exception e) {
				// Ignore
			}
		}
		throw new FileNotFoundException("Could not find " + groupId + "."
				+ artifactId + "-" + " in " + repos);
	}

	public OutputStream getOutputStream() throws IOException {
		return null;
	}

	public void connect() throws IOException {
		// TODO Auto-generated method stub

	}

}
