/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit;

import java.util.ArrayList;
import net.sourceforge.jwebunit.HttpUnitDialog;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class TextAndElementWalker {
    private StringBuffer currentText = new StringBuffer();
    private ArrayList texts = new ArrayList();
    private ArrayList nodes = new ArrayList();
    private String[] tags;

    public TextAndElementWalker(Element root, String[] tags) {
        this.tags = tags;
        this.walk(root);
    }

    private void walk(Node node) {
        if (node instanceof CharacterData) {
            this.currentText.append(((CharacterData)node).getData());
        } else if (node instanceof Element) {
            String tag = node.getNodeName();
            if (this.matches(tag)) {
                this.rememberElement((Element)node);
            } else {
                NodeList children = node.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    this.walk(children.item(i));
                }
            }
        }
    }

    private boolean matches(String tag) {
        for (int i = 0; i < this.tags.length; ++i) {
            if (!tag.equalsIgnoreCase(this.tags[i])) continue;
            return true;
        }
        return false;
    }

    private void rememberElement(Element node) {
        this.texts.add(this.currentText.toString());
        this.nodes.add(node);
        this.currentText = new StringBuffer();
    }

    public Element getElementAfterText(String label) {
        int index = this.indexOfElementAfterText(label);
        return index == -1 ? null : (Element)this.nodes.get(index);
    }

    private int indexOfElementAfterText(String label) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (((String)this.texts.get(i)).indexOf(label) == -1) continue;
            return i;
        }
        return -1;
    }

    public Element getElementWithTextAfterText(String linkText, String labelText) {
        int index = this.indexOfElementAfterText(labelText);
        if (index != -1) {
            for (int i = index; i < this.nodes.size(); ++i) {
                Element node = (Element)this.nodes.get(i);
                if (!HttpUnitDialog.nodeContainsText(node, linkText)) continue;
                return node;
            }
        }
        return null;
    }
}

