/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DOMMessageFormatter {
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    public static final String DOM_DOMAIN = "http://www.w3.org/dom/DOMTR";
    public static final String SERIALIZER_DOMAIN = "http://apache.org/xml/serializer";

    public static String formatMessage(String string, String string2, Object[] objectArray) throws MissingResourceException {
        String string3;
        ResourceBundle resourceBundle = null;
        if (string.equals(DOM_DOMAIN)) {
            resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.DOMMessages");
        } else if (string.equals(SERIALIZER_DOMAIN)) {
            resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLSerializerMessages");
        } else if (string.equals(XML_DOMAIN)) {
            resourceBundle = ResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLMessages");
        } else {
            throw new MissingResourceException("Unknown domain" + string, null, string2);
        }
        try {
            string3 = string2 + ": " + resourceBundle.getString(string2);
            if (objectArray != null) {
                try {
                    string3 = MessageFormat.format(string3, objectArray);
                }
                catch (Exception exception) {
                    string3 = resourceBundle.getString("FormatFailed");
                    string3 = string3 + " " + resourceBundle.getString(string2);
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            String string4 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(string2, string4, string2);
        }
        if (string3 == null) {
            string3 = string2;
            if (objectArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer(string3);
                stringBuffer.append('?');
                int n = 0;
                while (n < objectArray.length) {
                    if (n > 0) {
                        stringBuffer.append('&');
                    }
                    stringBuffer.append(String.valueOf(objectArray[n]));
                    ++n;
                }
            }
        }
        return string3;
    }
}

