/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.wikiwizard.CommentTag;
import org.wikiwizard.HeaderDescriptor;
import org.wikiwizard.InsertAction;
import org.wikiwizard.RETokenizer;
import org.wikiwizard.RemoveAction;
import org.wikiwizard.TagColor;
import org.wikiwizard.Token;
import org.wikiwizard.WikiTag;
import org.wikiwizard.WikiTagManager;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.WikiWizardTextPane;

public class EditorDocument
extends DefaultStyledDocument
implements DocumentListener {
    private final String trimRegex = "(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*";
    private SimpleAttributeSet normalCourier;
    public AttributeSet normal;
    private WikiWizardApplet wiki;
    public int caret = -1;
    private String regExTerm;
    private RETokenizer tokenizer;
    public static final int ONE_LINE = 0;
    public static final int CURRENT_VIEW = 1;
    public static final int TILL_END = 2;
    public static final int COMPLETE_DOCUMENT = 3;
    private int tableSearcher;
    public boolean stopNextHighlights = false;
    private JTextPane text;
    public ArrayList tagsCollection;
    private boolean completeDocumentNecessary;
    private Token token;
    private Vector header;
    public boolean stopNext = false;
    public boolean stopAll = false;
    public ArrayList highlighters;
    public boolean first = false;
    private int hstart;
    private int hend;
    public boolean stopUndo = false;
    private WikiTag item;
    public EditorDocument own;
    public WikiTagManager manager;
    private int lastLength;
    private boolean highlightingon = true;
    private int lastCommentBoxTag = -1;
    private ArrayList commentBoxList = new ArrayList();
    public boolean tempStopUndo = false;

    public EditorDocument(JTextPane text, WikiWizardApplet w) {
        this.text = text;
        this.wiki = w;
        this.own = this;
        this.normal = text.getCharacterAttributes();
        this.normalCourier = new SimpleAttributeSet(text.getCharacterAttributes());
        StyleConstants.setFontFamily(this.normalCourier, "Courier");
        StyleConstants.setFontSize(this.normalCourier, 12);
        StyleConstants.setItalic(this.normalCourier, false);
        StyleConstants.setBold(this.normalCourier, false);
        StyleConstants.setForeground(this.normalCourier, new TagColor(0, 0, 0, -1, false, false));
        this.manager = new WikiTagManager(this.wiki.tabsize);
        this.header = new Vector();
        this.highlighters = new ArrayList();
        this.tagsCollection = this.manager.allTags;
        this.loadTags();
        this.addDocumentListener(this);
        this.configureRegEx();
    }

    public void changedUpdate(DocumentEvent arg0) {
    }

    public void removeUpdate(DocumentEvent arg0) {
        if (!this.stopAll && !this.stopNext) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorDocument.this.highlightSyntax(0);
                }
            });
        }
        this.stopNext = false;
    }

    public void insertUpdate(DocumentEvent arg0) {
        if (!this.stopAll && !this.stopNext) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorDocument.this.highlightSyntax(0);
                }
            });
        }
        this.stopNext = false;
    }

    public void loadTags() {
        try {
            InputStream input;
            try {
                String base = this.wiki.getDocumentBase().toString();
                base = base.substring(0, base.lastIndexOf("/", base.length())) + "/";
                URL url = new URL(new URL(base), "applets/WiWi-INF/highlighting-jspwiki.xml");
                URLConnection connect = url.openConnection();
                input = connect.getInputStream();
            }
            catch (Exception e) {
                input = WikiWizardApplet.class.getResourceAsStream("/org/wikiwizard/resources/highlighting.xml");
            }
            InputStreamReader reader = new InputStreamReader(input, "UTF-8");
            BufferedReader buffer = new BufferedReader(reader);
            String line = "";
            String add = "";
            boolean first = true;
            while ((add = buffer.readLine()) != null) {
                if (first) {
                    first = false;
                }
                line = line + add + "\n";
            }
            this.manager.loadFile(line);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertString(int offset, String text, AttributeSet style) throws BadLocationException {
        for (int i = 0; i < this.manager.samePairTags.size(); ++i) {
            this.item = (WikiTag)this.manager.samePairTags.get(i);
            if (!text.equals(this.item.startTag.substring(0, 1))) continue;
            this.completeDocumentNecessary = true;
        }
        Element el = this.getCharacterElement(offset);
        if (StyleConstants.getForeground(el.getAttributes()) instanceof TagColor) {
            TagColor tagColor = (TagColor)StyleConstants.getForeground(el.getAttributes());
            if (tagColor.number > -1) {
                WikiTag tag = (WikiTag)this.tagsCollection.get(tagColor.number - 1);
                Element elbefore = null;
                if (offset - 1 > 0) {
                    elbefore = this.getCharacterElement(offset - 1);
                }
                if (style == null || !StyleConstants.getFontFamily(style).equals(StyleConstants.getFontFamily(this.normal))) {
                    style = el.getAttributes();
                    this.stopNext = true;
                }
                if (tag.headerTag != 0) {
                    this.stopNext = false;
                } else if (tagColor.startTag && offset + tag.startTagLength <= this.getLength() && this.getText(offset, tag.startTagLength).equals(tag.startTag)) {
                    style = this.normal;
                    this.stopNext = true;
                } else if (tagColor.endTag && offset + tag.endTagLength <= this.getLength() && this.getText(offset, tag.endTagLength).equals(tag.endTag)) {
                    style = tag.textAttributes;
                    this.stopNext = true;
                }
                if (elbefore != null && StyleConstants.getForeground(elbefore.getAttributes()) instanceof TagColor) {
                    tagColor = (TagColor)StyleConstants.getForeground(elbefore.getAttributes());
                    if (tagColor.startTag) {
                        tag = (WikiTag)this.tagsCollection.get(tagColor.number - 1);
                        if (tag.headerTag != 0 && text.equals("!")) {
                            this.stopNext = false;
                        }
                    }
                }
            }
        }
        super.insertString(offset, text, style);
        if (!(this.stopUndo || this.first || this.tempStopUndo)) {
            System.out.println("undo");
            this.wiki.undomanager.addEdit(new InsertAction(this.text, this, offset, text, style));
        }
        this.stopUndo = false;
        this.first = false;
    }

    public void remove(int offset, int length) throws BadLocationException {
        TagColor tagColor;
        boolean full = false;
        String text = this.own.getText(offset, length);
        if (length > 0) {
            for (int i = 0; i < this.manager.samePairTags.size(); ++i) {
                this.item = (WikiTag)this.manager.samePairTags.get(i);
                if (text.indexOf(this.item.startTag.substring(0, 1)) <= -1) continue;
                this.completeDocumentNecessary = true;
            }
        }
        if (length > 1 && text.indexOf("!") > -1) {
            this.stopNext = true;
            full = true;
        }
        Element el = this.getCharacterElement(offset);
        Element elafter = this.getCharacterElement(offset + length);
        if (StyleConstants.getForeground(elafter.getAttributes()) instanceof TagColor) {
            tagColor = (TagColor)StyleConstants.getForeground(elafter.getAttributes());
            if (tagColor.startTag) {
                this.stopNext = true;
            }
        }
        if (StyleConstants.getForeground(el.getAttributes()) instanceof TagColor) {
            tagColor = (TagColor)StyleConstants.getForeground(el.getAttributes());
            if (tagColor.number > -1) {
                WikiTag tag = (WikiTag)this.tagsCollection.get(tagColor.number - 1);
                if (!tagColor.startTag && !tagColor.endTag && tagColor.number > -1) {
                    this.stopNext = true;
                }
                if (tagColor.startTag && offset + tag.startTagLength <= this.getLength() && this.getText(offset, tag.startTagLength).equals(tag.startTag)) {
                    this.stopNext = true;
                }
            }
        }
        super.remove(offset, length);
        if (full) {
            this.highlightSyntax(3);
        }
        if (!this.stopUndo) {
            this.wiki.undomanager.addEdit(new RemoveAction(this.text, this, offset, length, text));
        }
        this.stopUndo = false;
    }

    public void setHighlighting(boolean on) {
        this.highlightingon = on;
    }

    public int checkRemovingStart(int hstart) {
        Element element;
        int pos = hstart;
        if (hstart - 1 > 0 && StyleConstants.getForeground((element = this.getCharacterElement(hstart - 1)).getAttributes()) instanceof TagColor) {
            TagColor tagColor = (TagColor)StyleConstants.getForeground(element.getAttributes());
            try {
                String startTag = ((WikiTag)this.manager.allTags.get((int)(tagColor.number - 1))).startTag;
                pos = this.getText(0, this.getLength()).lastIndexOf(startTag, hstart - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (pos == -1) {
            pos = hstart;
        }
        return pos;
    }

    public int checkRemovingEnd(int hstart, int hend) {
        Element element;
        int pos = hstart + hend;
        if (pos + 1 < this.getLength() && StyleConstants.getForeground((element = this.getCharacterElement(pos)).getAttributes()) instanceof TagColor) {
            TagColor tagColor = (TagColor)StyleConstants.getForeground(element.getAttributes());
            try {
                WikiTag theTag = (WikiTag)this.manager.allTags.get(tagColor.number - 1);
                pos = this.getText(0, this.getLength()).indexOf(theTag.endTag, pos);
                pos += theTag.endTagLength;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pos;
    }

    public boolean isFontGroup(int position, String startTag, String endTag) {
        ArrayList allTags = this.manager.allTags;
        WikiTag theTag = null;
        for (int i = 0; i < allTags.size(); ++i) {
            WikiTag tag = (WikiTag)allTags.get(i);
            if (!tag.startTag.equals(startTag) || !tag.endTag.equals(endTag)) continue;
            theTag = tag;
        }
        Element el = this.getCharacterElement(position);
        if (StyleConstants.getForeground(el.getAttributes()) instanceof TagColor) {
            TagColor tagColor = (TagColor)StyleConstants.getForeground(el.getAttributes());
            if (theTag != null && tagColor.number == theTag.tagNr) {
                return true;
            }
        }
        return false;
    }

    public boolean isFontGroup(int position, int tagNr) {
        Element element = this.getCharacterElement(position);
        AttributeSet attributes = element.getAttributes();
        if (StyleConstants.getForeground(attributes) instanceof TagColor) {
            TagColor theColor = (TagColor)StyleConstants.getForeground(attributes);
            if (theColor.number == tagNr) {
                return true;
            }
        } else if (tagNr == -1) {
            return true;
        }
        return false;
    }

    public int isFontGroup(int position) {
        Element element = this.getCharacterElement(position);
        AttributeSet attributes = element.getAttributes();
        if (StyleConstants.getForeground(attributes) instanceof TagColor) {
            TagColor theColor = (TagColor)StyleConstants.getForeground(attributes);
            return theColor.number;
        }
        return -1;
    }

    public boolean getAttribute(int position, SimpleAttributeSet s) {
        Element element = this.getCharacterElement(position);
        AttributeSet attributes = element.getAttributes();
        Enumeration<?> enumeration = attributes.getAttributeNames();
        return StyleConstants.getForeground(attributes) == StyleConstants.getForeground(s);
    }

    public boolean getAttributeFontFamily(int position, String family) {
        Element element = this.getCharacterElement(position);
        AttributeSet attributes = element.getAttributes();
        return StyleConstants.getFontFamily(attributes).equals("Courier");
    }

    public void addToTree(int headerPosView, Token token, int hstart, int end, Vector header, int headerGroup) throws BadLocationException {
        int plus = headerGroup;
        int textStart = plus + hstart + token.getPos();
        String tokenText = this.getText(textStart, end - textStart);
        if (headerPosView > -1) {
            header.add(headerPosView, new HeaderDescriptor(tokenText, hstart + token.getPos(), headerGroup));
        } else {
            header.add(new HeaderDescriptor(tokenText, hstart + token.getPos(), headerGroup));
        }
    }

    public int markTable2(String i, int position) {
        int pos = 0;
        try {
            pos = this.getText(0, this.getLength()).indexOf("\n", position);
            if (pos > -1) {
                return pos;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return this.getLength();
    }

    public int markTable(String text, int position) {
        if (position == 0 && text.length() > 0) {
            position = 1;
        }
        boolean changed = true;
        int startPosition = 0;
        int endPosition = 0;
        String tex = text;
        boolean first = true;
        boolean inlist = false;
        boolean multistart = false;
        boolean multi = false;
        changed = true;
        for (int i = 0; i < position; ++i) {
            if (i + 3 < tex.length() && tex.substring(i, i + 3).equals("{{{")) {
                multi = true;
            }
            if (i + 3 < tex.length() && tex.substring(i, i + 3).equals("}}}")) {
                multi = false;
            }
            if (multi || !tex.substring(i, i + 1).equals("\n") && i != 0) continue;
            if (i == 0 && tex.substring(0, 1).equals("|")) {
                inlist = true;
                startPosition = 0;
                continue;
            }
            if (i + 2 <= tex.length() && tex.substring(i + 1, i + 2).equals("|")) {
                if (!inlist) {
                    startPosition = i + 1;
                }
                inlist = true;
                continue;
            }
            inlist = false;
            startPosition = 0;
        }
        changed = true;
        boolean next = false;
        first = true;
        multi = false;
        int i = position;
        while (changed) {
            if (i + 3 < tex.length() && tex.substring(i, i + 3).equals("{{{")) {
                multi = true;
            }
            if (i + 3 < tex.length() && tex.substring(i, i + 3).equals("}}}")) {
                multi = false;
            }
            if (!multi && (i + 1 < tex.length() && tex.substring(i, i + 1).equals("\n") || i == tex.length())) {
                if (first && inlist) {
                    endPosition = i;
                }
                if (next) {
                    next = false;
                    endPosition = i;
                }
                if (i + 2 < tex.length() && tex.substring(i + 1, i + 2).equals("|")) {
                    next = true;
                } else {
                    changed = false;
                }
                first = false;
            }
            if (i == tex.length()) {
                changed = false;
            }
            ++i;
        }
        if (endPosition > 0 && tex.substring(endPosition - 1, endPosition).equals("\n")) {
            --endPosition;
        }
        if (inlist) {
            return endPosition;
        }
        return 0;
    }

    public int checkEndPos(Token token, int hstart) throws BadLocationException {
        int end = 0;
        int pos = 0;
        pos = this.getText(0, this.getLength()).indexOf("\n", token.getPos() + hstart + 1);
        end = pos > -1 ? pos : this.getLength();
        return end;
    }

    public void clearDocument() {
        ((WikiWizardTextPane)this.text).refreshBlocks();
        this.setCharacterAttributes(0, this.getLength(), this.normalCourier, true);
        this.text.setCharacterAttributes(this.normalCourier, true);
    }

    public int walkBack(String tag, String tag2, int position) {
        int pos = 0;
        int pos1 = 0;
        int result = position;
        try {
            pos = this.getText(0, this.getLength()).lastIndexOf(tag2, position);
            while (pos1 > -1 && position > -1) {
                pos1 = this.getText(0, this.getLength()).lastIndexOf(tag, position);
                if (pos1 > -1 && pos <= pos1) {
                    result = pos1;
                }
                position = pos1 - 1;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return result;
    }

    public HighlightViewMoveWrapper checkCurrentView(String texts, int hstart, int hend, boolean tillEnd) {
        try {
            WikiTag item;
            int i;
            int pos = 0;
            int hstartadd = 0;
            int hendadd = 0;
            hstartadd = Math.abs(hstart - this.checkRemovingStart(hstart));
            hendadd = Math.abs(this.checkRemovingEnd(hstart, hend) - (hstart + hend));
            ArrayList differentPairs = this.manager.differentPair;
            ArrayList samePairs = this.manager.samePairTags;
            for (i = 0; i < samePairs.size(); ++i) {
                item = (WikiTag)samePairs.get(i);
                if (texts.indexOf(item.startTag) <= -1 || hstart < item.startTagLength || (pos = this.getText(0, this.getLength()).lastIndexOf(item.startTag, hstart)) <= -1 || this.isFontGroup(hstart + texts.indexOf(item.startTag), item.tagNr) || !this.isFontGroup(pos, -1) || Math.abs(hstart - pos) <= hstartadd) continue;
                hstartadd = Math.abs(hstart - pos);
            }
            for (i = 0; i < differentPairs.size(); ++i) {
                item = (WikiTag)differentPairs.get(i);
                if (texts.indexOf(item.endTag) > -1 && (pos = this.getText(0, this.getLength()).lastIndexOf(item.startTag, hstart)) > -1 && (texts.indexOf(item.startTag) < 0 || texts.indexOf(item.startTag) > texts.indexOf(item.endTag)) && this.getText(0, this.getLength()).lastIndexOf(item.endTag, hstart) < pos && this.isFontGroup(pos, -1) && Math.abs(hstart - (pos = this.walkBack(item.startTag, item.endTag, pos))) > hstartadd) {
                    hstartadd = Math.abs(hstart - pos);
                }
                if (tillEnd || texts.lastIndexOf(item.startTag, hend) <= -1 || texts.lastIndexOf(item.endTag, hend) >= 0 && texts.lastIndexOf(item.endTag, hend) >= texts.indexOf(item.startTag, hend) || (pos = this.getText(0, this.getLength()).indexOf(item.endTag, hend + hstart)) <= -1 || pos >= this.getText(0, this.getLength()).indexOf(item.startTag, hend + hstart) || Math.abs(pos + item.endTagLength - (hend + hstart)) <= hendadd) continue;
                hendadd = Math.abs(pos + item.endTagLength - (hend + hstart));
            }
            hend += hstartadd;
            return new HighlightViewMoveWrapper(hstart -= hstartadd, hend += hendadd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HighlightViewMoveWrapper(hstart, hend);
        }
    }

    public int removePartOfHeaders(int hstart, int hend) {
        int first = -1;
        Vector<HeaderDescriptor> copy = new Vector<HeaderDescriptor>();
        int difference = this.getLength() - this.lastLength;
        int before = 0;
        for (int i = 0; i < this.header.size(); ++i) {
            HeaderDescriptor item = (HeaderDescriptor)this.header.get(i);
            int pos = item.getPosition();
            if (pos > this.caret) {
                pos += difference;
            }
            if (pos >= hstart && pos <= hend + hstart) {
                if (first < 0) {
                    first = i;
                }
            } else {
                item.position = pos;
                copy.add(item);
            }
            if (first < 0 && before < this.caret && this.caret < pos) {
                first = i;
            }
            before = pos;
        }
        this.header = copy;
        return first;
    }

    public void removePartOfHighlighters(int hstart, int hend) {
        ArrayList<HighlighterData> copy = new ArrayList<HighlighterData>();
        int difference = this.getLength() - this.lastLength;
        for (int i = 0; i < this.highlighters.size(); ++i) {
            HighlighterData item = (HighlighterData)this.highlighters.get(i);
            int pos = item.row;
            int pos1 = item.row1;
            if (pos >= this.caret) {
                pos += difference;
                pos1 += difference;
            }
            if (pos >= hstart && pos <= hend + hstart || item.col.equals(new Color(255, 255, 204))) continue;
            item.row = pos;
            item.row1 = pos1;
            copy.add(item);
        }
        this.highlighters = copy;
    }

    public void configureRegEx() {
        this.regExTerm = this.manager.createCompleteRegExTerm();
        this.tokenizer = new RETokenizer(this.regExTerm, this.tagsCollection.size());
    }

    public void highlightSyntax(int mode) {
        boolean currentView = false;
        boolean tillEnd = false;
        boolean completeDocument = false;
        switch (mode) {
            case 3: {
                completeDocument = true;
            }
            case 2: {
                tillEnd = true;
            }
            case 1: {
                currentView = true;
            }
        }
        if (this.highlightingon) {
            if (this.caret == -1) {
                this.caret = this.text.getCaretPosition();
            }
            int selectionStart = 0;
            int selectionEnd = 0;
            selectionStart = this.text.getSelectionStart();
            selectionEnd = this.text.getSelectionEnd();
            this.text.setSelectionEnd(this.text.getSelectionStart());
            this.text.setCaretPosition(0);
            if (completeDocument) {
                this.completeDocumentNecessary = false;
            } else if (currentView) {
                if (this.completeDocumentNecessary) {
                    this.completeDocumentNecessary = false;
                } else {
                    tillEnd = false;
                }
            }
            try {
                this.wiki.stopCaretListener = true;
                if (this.wiki.highlightingModus) {
                    this.hstart = 0;
                    this.hend = this.getLength();
                    if (currentView && !completeDocument && this.getLength() > 0) {
                        Point view = this.wiki.textScroll.getViewport().getViewPosition();
                        JViewport currentScreen = this.wiki.textScroll.getViewport();
                        this.hstart = this.text.viewToModel(view);
                        this.hend = this.text.viewToModel(new Point(view.x + currentScreen.getWidth(), view.y + currentScreen.getHeight()));
                        this.hend -= this.hstart;
                    } else if (!currentView) {
                        String tx = this.getText(0, this.getLength());
                        this.hstart = tx.lastIndexOf("\n", this.caret - 1);
                        if (this.hstart < 0) {
                            this.hstart = 0;
                        }
                        this.hend = tx.indexOf("\n", this.hstart + 1) - this.hstart;
                        if (this.hend < 0) {
                            this.hend = this.getLength() - this.hstart;
                        }
                    }
                    this.tableSearcher = 0;
                    String texts = this.getText(this.hstart, this.hend);
                    boolean avoid = false;
                    if (currentView && !completeDocument && this.getLength() > 0) {
                        HighlightViewMoveWrapper wrapper = this.checkCurrentView(texts, this.hstart, this.hend, tillEnd);
                        this.hstart = wrapper.hstart;
                        this.hend = wrapper.hend;
                    }
                    if (tillEnd) {
                        this.hend = this.getLength() - this.hstart;
                    }
                    this.setCharacterAttributes(this.hstart, this.hend, this.normal, true);
                    texts = this.getText(this.hstart, this.hend);
                    this.tokenizer.createTokenizer(texts);
                    int headerPosView = -1;
                    int difference = this.getLength() - this.lastLength;
                    if (currentView && !completeDocument) {
                        ((WikiWizardTextPane)this.text).refreshBlocks();
                        headerPosView = this.removePartOfHeaders(this.hstart, this.hend);
                        this.removePartOfHighlighters(this.hstart, this.hend);
                        this.lastLength = this.getLength();
                    }
                    if (currentView && completeDocument) {
                        ((WikiWizardTextPane)this.text).refreshBlocks();
                        this.highlighters = new ArrayList();
                        this.header = new Vector();
                        this.lastLength = this.getLength();
                    }
                    long time = System.currentTimeMillis();
                    Vector hits = new Vector();
                    this.lastCommentBoxTag = -1;
                    int i = 0;
                    while (i < this.commentBoxList.size() && currentView) {
                        CommentTag cTag = (CommentTag)this.commentBoxList.get(i);
                        int pos = cTag.pos;
                        if (pos >= this.caret) {
                            pos += difference;
                        }
                        if (pos >= this.hstart && pos <= this.hend + this.hstart) {
                            this.commentBoxList.remove(i);
                            continue;
                        }
                        cTag.pos = pos;
                        ++i;
                    }
                    while (!avoid && (this.token = this.tokenizer.nextToken()) != null) {
                        WikiTag theTag = (WikiTag)this.tagsCollection.get(this.token.getGroup() - 1);
                        if (currentView && this.token.getText().equals("%%")) {
                            int i2;
                            for (i2 = 0; i2 < this.commentBoxList.size() && ((CommentTag)this.commentBoxList.get((int)i2)).pos < this.token.getPos() + this.hstart; ++i2) {
                            }
                            boolean isStartTag = false;
                            if (texts.length() - 2 > this.token.getPos() && ("" + texts.charAt(this.token.getPos() + 2)).matches("(\u00e4|\u00f6|\u00fc|\u00df|[a-z]|[A-Z]|[0-9]|_|-|\\.)*")) {
                                isStartTag = true;
                            }
                            this.commentBoxList.add(i2, new CommentTag(isStartTag, this.token.getPos() + this.hstart));
                        }
                        if (theTag.tagGroup == 1) {
                            int pos;
                            int tokenlength = this.token.getText().length();
                            this.setCharacterAttributes(this.token.getPos() + this.hstart, theTag.startTagLength, theTag.startTagAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + tokenlength - theTag.endTagLength, theTag.endTagLength, theTag.endTagAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + theTag.startTagLength, tokenlength - (theTag.startTagLength + theTag.endTagLength), theTag.textAttributes, false);
                            if (theTag.separator.equals("") || (pos = this.token.getText().indexOf(theTag.separator)) <= -1) continue;
                            this.setCharacterAttributes(this.token.getPos() + pos + this.hstart, theTag.separator.length(), theTag.separatorAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + theTag.startTagLength, pos - theTag.startTagLength, theTag.separateTextAttributes, false);
                            continue;
                        }
                        if (theTag.tagGroup == 2) {
                            int next = this.own.getText(0, this.own.getLength()).indexOf(" ", this.token.getPos() + this.hstart);
                            int next2 = this.own.getText(0, this.own.getLength()).indexOf("\n", this.token.getPos() + this.hstart);
                            if (next2 < next && next > -1 && next2 > -1 || next == -1 && next2 > -1) {
                                next = next2;
                            }
                            if (next < 0 || this.own.getText(0, this.own.getLength()).indexOf(theTag.endTag, this.token.getPos() + this.hstart) < next) {
                                next = this.token.getPos() + this.hstart + this.token.getText().length();
                            }
                            this.setCharacterAttributes(this.token.getPos() + this.hstart, next - (this.token.getPos() + this.hstart), theTag.startLineAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart, theTag.startTagLength, theTag.startTagAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + this.token.getText().length() - theTag.endTagLength, theTag.endTagLength, theTag.endTagAttributes, false);
                            this.setCharacterAttributes(next, this.token.getPos() + this.hstart + this.token.getText().length() - (next + 2), theTag.textAttributes, false);
                            if (!currentView) continue;
                            WikiWizardTextPane pane = (WikiWizardTextPane)this.text;
                            this.highlighters.add(new HighlighterData(this.token.getPos() + this.hstart, this.token.getPos() + this.hstart + this.token.getText().length(), theTag.backgroundColor));
                            continue;
                        }
                        if (theTag.tagGroup == 3) {
                            this.setCharacterAttributes(this.token.getPos() + this.hstart, theTag.startTagLength, theTag.startTagAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + this.token.getText().length() - theTag.endTagLength, theTag.endTagLength, theTag.endTagAttributes, false);
                            if (currentView) {
                                WikiWizardTextPane pane = (WikiWizardTextPane)this.text;
                                this.highlighters.add(new HighlighterData(this.token.getPos() + this.hstart, this.token.getPos() + this.hstart + this.token.getText().length(), theTag.backgroundColor));
                            }
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + theTag.startTagLength, this.token.getText().length() - (theTag.startTagLength + theTag.endTagLength), theTag.textAttributes, false);
                            continue;
                        }
                        if (theTag.tagGroup == 4) {
                            if (this.token.getText().substring(0, 1).equals("\n")) {
                                this.token.setText(this.token.getText().substring(1, this.token.getText().length() - 1));
                                this.token.setPos(this.token.getPos() + 1);
                            }
                            this.setCharacterAttributes(this.hstart + this.token.getPos(), theTag.startTagLength, theTag.startTagAttributes, true);
                            continue;
                        }
                        if (theTag.tagGroup == 5) {
                            if (this.token.getText().substring(0, 1).equals("\n")) {
                                this.token.setText(this.token.getText().substring(1, this.token.getText().length() - 1));
                                this.token.setPos(this.token.getPos() + 1);
                            }
                            int end = this.checkEndPos(this.token, this.hstart);
                            if (currentView) {
                                this.addToTree(headerPosView, this.token, this.hstart, end, this.header, theTag.headerTag);
                                if (!completeDocument) {
                                    ++headerPosView;
                                }
                            }
                            this.setCharacterAttributes(this.token.getPos() + this.hstart, theTag.startTagLength, theTag.startTagAttributes, false);
                            this.setCharacterAttributes(this.token.getPos() + this.hstart + theTag.startTagLength, end - (this.token.getPos() + this.hstart + theTag.startTagLength), theTag.textAttributes, false);
                            continue;
                        }
                        if (theTag.tagGroup != 6) continue;
                        if (this.token.getPos() >= this.tableSearcher) {
                            int end = this.markTable(this.own.getText(0, this.own.getLength()), this.token.getPos() + this.hstart);
                            if (currentView) {
                                WikiWizardTextPane pane = (WikiWizardTextPane)this.text;
                                this.highlighters.add(new HighlighterData(this.token.getPos() + this.hstart, end, new Color(225, 225, 255)));
                                this.tableSearcher = end - this.hstart;
                            }
                        }
                        this.setCharacterAttributes(this.token.getPos() + this.hstart, 1, theTag.startTagAttributes, false);
                    }
                    for (i = 0; i < this.commentBoxList.size() - 1 && currentView; ++i) {
                        CommentTag cTag0 = (CommentTag)this.commentBoxList.get(i);
                        int pos = cTag0.pos;
                        int pos2 = -1;
                        CommentTag cTag1 = (CommentTag)this.commentBoxList.get(++i);
                        int startTagsCount = 1;
                        while (cTag1 != null && cTag0.start && cTag1.start) {
                            ++startTagsCount;
                            if (this.commentBoxList.size() > ++i) {
                                cTag1 = (CommentTag)this.commentBoxList.get(i);
                                if (cTag1 == null) continue;
                                pos2 = cTag1.pos;
                                continue;
                            }
                            cTag1 = null;
                        }
                        while (cTag1 != null && startTagsCount > 0) {
                            --startTagsCount;
                            pos2 = cTag1.pos;
                            if (this.commentBoxList.size() > ++i) {
                                cTag1 = (CommentTag)this.commentBoxList.get(i);
                                continue;
                            }
                            cTag1 = null;
                        }
                        if (cTag1 != null) {
                            --i;
                        }
                        if (pos2 == -1) continue;
                        this.highlighters.add(new HighlighterData(pos, pos2 + 2, new Color(255, 255, 204, 100)));
                    }
                    if (!completeDocument && currentView) {
                        ArrayList samePairsTags = this.manager.samePairTags;
                        for (int i3 = 0; i3 < samePairsTags.size(); ++i3) {
                            int pos2;
                            WikiTag item = (WikiTag)samePairsTags.get(i3);
                            int pos = texts.lastIndexOf(item.endTag, texts.length());
                            if (pos <= -1 || !this.isFontGroup(pos + this.hstart, -1) || (pos2 = this.getText(0, this.getLength()).indexOf(item.endTag, this.hstart + texts.length())) <= -1) continue;
                            this.setCharacterAttributes(this.hstart + pos, pos2 - (this.hstart + pos), item.textAttributes, false);
                            this.setCharacterAttributes(this.hstart + pos, item.startTagLength, item.startTagAttributes, false);
                            this.setCharacterAttributes(pos2 - item.endTagLength, item.endTagLength, item.endTagAttributes, false);
                        }
                    }
                    if (currentView) {
                        this.wiki.setHeaderVector(this.header);
                    }
                    this.text.revalidate();
                    this.text.setCharacterAttributes(this.normal, true);
                    this.setCharacterAttributes(this.own.getLength(), this.getLength(), this.normal, true);
                    if (currentView && !this.stopNextHighlights) {
                        this.createHighlights();
                        this.wiki.m_penMouseListener.searchKeywords(this.hstart, this.hend, difference);
                    }
                    this.stopNextHighlights = false;
                    this.text.repaint();
                }
                this.wiki.stopCaretListener = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.caret == selectionStart) {
                this.text.setCaretPosition(selectionEnd);
                this.text.moveCaretPosition(selectionStart);
            } else {
                this.text.setCaretPosition(this.caret);
                this.text.select(selectionStart, selectionEnd);
            }
        }
        this.caret = -1;
    }

    public String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void createHighlights() {
        for (int i = 0; i < this.highlighters.size(); ++i) {
            HighlighterData item = (HighlighterData)this.highlighters.get(i);
            if (item.row >= 0 && item.row1 <= this.getLength()) {
                ((WikiWizardTextPane)this.text).createRect(item.row, item.row1, item.col);
                continue;
            }
            this.highlighters.remove(item);
        }
    }

    public String removeFromString(int start, int length, String txt) {
        txt = txt.substring(0, start) + txt.substring(start + length, txt.length());
        return txt;
    }

    class HighlightViewMoveWrapper {
        public int hstart;
        public int hend;

        public HighlightViewMoveWrapper(int hstart, int hend) {
            this.hstart = hstart;
            this.hend = hend;
        }
    }

    class HighlighterData {
        public int row1;
        public int row;
        public Color col;

        public HighlighterData(int row, int row1, Color col) {
            this.row = row;
            this.row1 = row1;
            this.col = col;
        }
    }
}

