/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import org.wikiwizard.EditorDocument;

public class InsertAction
extends AbstractUndoableEdit {
    protected int offset;
    protected String text;
    protected EditorDocument doc;
    protected AttributeSet style;
    protected JTextPane textPane;

    public InsertAction(JTextPane textPane, EditorDocument doc, int offset, String text, AttributeSet style) {
        this.offset = offset;
        this.text = text;
        this.textPane = textPane;
        this.doc = doc;
        this.style = style;
    }

    public String getPresentationName() {
        return "TextChange";
    }

    public void undo() {
        super.undo();
        try {
            this.doc.stopUndo = true;
            if (this.text.length() > 1) {
                this.doc.stopNext = true;
                this.doc.remove(this.offset, this.text.length());
                this.doc.highlightSyntax(3);
            } else {
                this.doc.remove(this.offset, this.text.length());
            }
            this.textPane.setCaretPosition(this.offset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void redo() {
        super.redo();
        try {
            this.doc.stopUndo = true;
            if (this.text.length() > 1) {
                this.doc.stopNext = true;
                this.doc.insertString(this.offset, this.text, this.style);
                this.doc.highlightSyntax(3);
            } else {
                this.doc.insertString(this.offset, this.text, this.style);
            }
            this.textPane.setCaretPosition(this.offset + this.text.length());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

