/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.wikiwizard.TableEditor;
import org.wikiwizard.WikiWizardApplet;
import org.wikiwizard.observeModul;

public class OurTableCellEditor
extends DefaultCellEditor
implements MouseListener,
KeyListener,
TableCellEditor,
UndoableEditListener {
    protected JTextArea myEditingComponent;
    public static JTextArea currentCellEditor;
    private int editingRow;
    private int editingColumn;
    private int iCursorPos;
    final UndoManager undomanager = new UndoManager();
    private observeModul obsable;
    private TableEditor table;
    private TableEditor dialog;

    public OurTableCellEditor(Object obs, WikiWizardApplet frame, TableEditor dialog) {
        super(new JTextField());
        this.dialog = dialog;
        this.table = (TableEditor)obs;
        this.myEditingComponent = new JTextArea();
        this.myEditingComponent.addMouseListener(this);
        this.myEditingComponent.setLineWrap(false);
        this.myEditingComponent.setWrapStyleWord(true);
        this.myEditingComponent.setOpaque(true);
        this.myEditingComponent.addKeyListener(this);
        this.obsable = new observeModul();
        this.obsable.addObserver((Observer)obs);
        this.myEditingComponent.getDocument().addUndoableEditListener(this);
        this.myEditingComponent.addMouseListener(this);
        this.myEditingComponent.getInputMap().put(KeyStroke.getKeyStroke("TAB"), "TAB");
        this.myEditingComponent.getActionMap().put("TAB", new Action_tab());
        this.myEditingComponent.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "ENTER");
        this.myEditingComponent.getActionMap().put("ENTER", new Action_return());
        this.myEditingComponent.getInputMap().put(KeyStroke.getKeyStroke(73, 2), "ROW");
        this.myEditingComponent.getActionMap().put("ROW", new TableEditor.Action_insertRowAfter(this.table));
        this.myEditingComponent.getInputMap().put(KeyStroke.getKeyStroke(73, 3), "COLUMN");
        this.myEditingComponent.getActionMap().put("COLUMN", new TableEditor.Action_insertColumnAfter(this.table));
        this.myEditingComponent.getInputMap().put(KeyStroke.getKeyStroke(90, 2), "UNDO");
        this.myEditingComponent.getActionMap().put("UNDO", new Action_undo());
    }

    public void setCaretToStart() {
        this.myEditingComponent.setCaretPosition(0);
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
        int count = this.myEditingComponent.getDocument().getDefaultRootElement().getElementCount();
        StringTokenizer elements = new StringTokenizer(this.myEditingComponent.getText(), "\n");
        Properties cellHeight = new Properties();
        cellHeight.put("EditingRow", new Integer(this.editingRow));
        cellHeight.put("EditingColumn", new Integer(this.editingColumn));
        cellHeight.put("Height", new Integer(18 * (count - 1 + 1)));
        this.obsable.input(cellHeight);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit ue = e.getEdit();
        this.undomanager.addEdit(ue);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 86 && ke.isControlDown()) {
            this.stopCellEditing();
            new TableEditor.Action_paste(this.table).actionPerformed(null);
        }
        if (ke.getKeyCode() == 83 && ke.isControlDown()) {
            this.stopCellEditing();
            new TableEditor.Action_accept(this.table).actionPerformed(null);
        } else if (ke.getKeyCode() == 114) {
            new TableEditor.Action_PictureDialog(this.table).actionPerformed(null);
        } else if (ke.getKeyCode() == 115) {
            new TableEditor.Action_mailToDialog(this.table).actionPerformed(null);
        } else if (ke.getKeyCode() == 116) {
            new TableEditor.Action_Link(this.table).actionPerformed(null);
        } else if (ke.getKeyCode() == 40) {
            this.stopCellEditing();
            this.table.setSelection(0, 1);
        } else if (ke.getKeyCode() == 38) {
            this.stopCellEditing();
            this.table.setSelection(0, -1);
        }
        if (ke.getKeyCode() == 10) {
            if (ke.getModifiers() == 8) {
                this.myEditingComponent.insert("\n", this.myEditingComponent.getCaretPosition());
                return;
            }
        }
        if (ke.getKeyCode() != 10) return;
        this.stopCellEditing();
    }

    public Object getCellEditorValue() {
        return this.myEditingComponent.getText();
    }

    public JTextArea getEditingComp() {
        return this.myEditingComponent;
    }

    public void undo() {
        if (this.undomanager.canUndo()) {
            this.undomanager.undo();
        }
    }

    public void redo() {
        if (this.undomanager.canRedo()) {
            this.undomanager.redo();
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingRow = row;
        this.editingColumn = column;
        this.myEditingComponent.setFont(table.getFont());
        String text = (String)value;
        int count = 0;
        boolean[] header = this.table.getHeader();
        if (header[row]) {
            this.myEditingComponent.setBackground(new Color(199, 199, 226));
        } else {
            this.myEditingComponent.setBackground(Color.white);
        }
        if (value != null) {
            for (int i = 0; i < text.length(); ++i) {
                if (!text.substring(i, i + 1).equals("\n")) continue;
                ++count;
            }
        }
        if (value != null) {
            this.myEditingComponent.setText("" + value);
        }
        if (value == null) {
            this.myEditingComponent.setText("");
        }
        if (value != null && count == text.length()) {
            this.myEditingComponent.setCaretPosition(0);
        }
        currentCellEditor = this.myEditingComponent;
        return this.myEditingComponent;
    }

    public void mouseClicked(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
        if (arg0.getButton() == 3) {
            this.stopCellEditing();
            this.table.mousePressed(arg0);
            this.table.mouseReleased(arg0);
        }
        if (arg0.getClickCount() == 2 && !this.dialog.mailAction() && !this.dialog.pictureAction()) {
            this.dialog.linkAction();
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    class Action_tab
    extends AbstractAction {
        Action_tab() {
        }

        public void actionPerformed(ActionEvent evt) {
            OurTableCellEditor.this.stopCellEditing();
            OurTableCellEditor.this.table.setSelection(1, 0);
        }
    }

    class Action_redo
    extends AbstractAction {
        Action_redo() {
        }

        public void actionPerformed(ActionEvent evt) {
            OurTableCellEditor.this.redo();
        }
    }

    class Action_undo
    extends AbstractAction {
        Action_undo() {
        }

        public void actionPerformed(ActionEvent evt) {
            OurTableCellEditor.this.undo();
        }
    }

    class Action_return
    extends AbstractAction {
        Action_return() {
        }

        public void actionPerformed(ActionEvent evt) {
            OurTableCellEditor.this.stopCellEditing();
            OurTableCellEditor.this.table.setSelection(0, 1);
        }
    }
}

