/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import org.wikiwizard.EditorDocument;
import org.wikiwizard.LinkDialog;
import org.wikiwizard.MailToDialog;
import org.wikiwizard.ModelChangeDialog;
import org.wikiwizard.OurTableCellEditor;
import org.wikiwizard.OurTableCellRenderer;
import org.wikiwizard.OurTableModel;
import org.wikiwizard.PictureDialog;
import org.wikiwizard.RowHeaderListModel;
import org.wikiwizard.RowHeaderRenderer;
import org.wikiwizard.Table;
import org.wikiwizard.WikiWizardApplet;

public class TableEditor
extends JDialog
implements ActionListener,
Observer,
WindowListener,
MouseListener,
KeyListener {
    public JTable table;
    private String rowstring;
    private String value;
    private Clipboard system;
    private int[] columnmax = new int[1000];
    private ResourceBundle bundle = null;
    static String resource_lang = "org.wikiwizard.resources";
    static Locale locale = Locale.US;
    private int[][] cellHeights;
    private static String resource_ico = "/org/wikiwizard/resources";
    private StringSelection stsel;
    private ModelChangeDialog propertiesDialog;
    private WikiWizardApplet theWikiWizardApplert;
    final UndoManager undomanager = new UndoManager();
    private JEditorPane textPane;
    private int rows;
    private int columns;
    private boolean[] header;
    private boolean first;
    private int[] maxrow;
    private boolean pressed;
    private boolean strip;
    private int[] add = new int[1000];
    public int intCaretPos = 0;
    private JList rowHeader;
    private AbstractListModel theRowHeaderListModel;
    private OurTableModel model;
    Font menuFontSize = new Font("Dialog", 0, 12);
    private CompoundEdit compoundEdit;
    private TableCellEditor editor;
    private JScrollPane scroller;
    public boolean[][] sourceCode;
    private boolean bPressedTimes = false;
    private int mrow;
    private int mcol;
    private int iCursorPos;
    private JDialog own;
    public PictureDialog pictureD;
    public MailToDialog mailToDialog;
    public LinkDialog linkDialog;
    private JTableHeader columnHeader;
    private JTextArea myEditingComponent;
    private int selStart = -1;
    private int selEnd = -1;
    boolean compoundEditaction = false;

    public TableEditor(WikiWizardApplet theWikiWizardApplet, JTextPane textPane, boolean insert, boolean strip) {
        super(JOptionPane.getFrameForComponent(theWikiWizardApplet), true);
        locale = WikiWizardApplet.locale;
        this.bundle = ResourceBundle.getBundle(resource_lang + ".ProgramStrings", locale);
        this.getContentPane().setLayout(new BorderLayout());
        this.theWikiWizardApplert = theWikiWizardApplet;
        this.textPane = textPane;
        this.own = this;
        this.strip = strip;
        this.setModal(true);
        this.setTitle(this.bundle.getString("tableTitle"));
        this.setLocationRelativeTo(this.theWikiWizardApplert);
        this.rows = 30;
        this.columns = 10;
        this.cellHeights = new int[this.rows][this.columns];
        this.model = new OurTableModel(this.rows, this.columns, this);
        this.header = new boolean[this.rows];
        this.sourceCode = new boolean[this.rows][this.columns];
        this.table = new Table(this.model);
        this.scroller = new JScrollPane(this.table);
        this.setTableHeaders();
        this.table.setDefaultRenderer(Object.class, new OurTableCellRenderer(this, this.theWikiWizardApplert));
        this.table.setDefaultEditor(Object.class, new OurTableCellEditor(this, this.theWikiWizardApplert, this));
        this.table.addMouseListener(this);
        this.table.addKeyListener(this);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        JToolBar tools = this.createToolBar();
        this.getContentPane().add((Component)tools, "North");
        this.getContentPane().add(this.scroller);
        this.table.requestFocus();
        this.table.editCellAt(0, 0);
        this.configureTableKeyMap();
        this.addWindowListener(this);
        if (insert) {
            this.importTable();
        }
    }

    public void configureTableKeyMap() {
        this.table.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "PASTE");
        this.table.getActionMap().put("PASTE", new Action_paste());
        this.table.getInputMap().put(KeyStroke.getKeyStroke(73, 2), "ROW");
        this.table.getActionMap().put("ROW", new Action_insertRowAfter());
        this.table.getInputMap().put(KeyStroke.getKeyStroke(73, 3), "COLUMN");
        this.table.getActionMap().put("COLUMN", new Action_insertColumnAfter());
    }

    public JToolBar createToolBar() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        JToolBar tableToolBar = new JToolBar();
        JButton accept = new JButton(new ImageIcon(WikiWizardApplet.class.getResource(resource_ico + "/stock_save.png")));
        accept.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(accept);
        accept.addActionListener(new Action_accept());
        accept.setToolTipText(this.bundle.getString("acceptTooltip"));
        JButton cancel = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_calc-cancel.png"))));
        cancel.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(cancel);
        cancel.addActionListener(new Action_cancel());
        cancel.setToolTipText(this.bundle.getString("cancelTooltip"));
        tableToolBar.add(Box.createHorizontalStrut(15));
        JButton image = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_insert_image.png"))));
        image.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(image);
        image.addActionListener(new Action_PictureDialog());
        image.setToolTipText(this.bundle.getString("imageTooltip"));
        JButton mail = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_insert_url.png"))));
        mail.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(mail);
        mail.addActionListener(new Action_Link());
        mail.setToolTipText(this.bundle.getString("externalLinkTooltip"));
        JButton link = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_mail.png"))));
        link.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(link);
        link.addActionListener(new Action_mailToDialog());
        link.setToolTipText(this.bundle.getString("mailTooltip"));
        ActionListener sortupAL = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (TableEditor.this.table.getSelectedColumn() != -1) {
                    TableEditor.this.model.sortByColumn(TableEditor.this.table.getSelectedColumn(), true);
                    TableEditor.this.table.repaint();
                    TableEditor.this.table.getTableHeader().repaint();
                } else {
                    JOptionPane.showMessageDialog(null, "You did not select a column to sort.");
                }
            }
        };
        tableToolBar.add(Box.createHorizontalStrut(15));
        JButton sortUp = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_sort-ascending.png"))));
        sortUp.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(sortUp);
        sortUp.addActionListener(sortupAL);
        sortUp.setToolTipText(this.bundle.getString("sortAscendingToolTip"));
        ActionListener sortdownAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TableEditor.this.table.getSelectedColumn() != -1) {
                    TableEditor.this.model.sortByColumn(TableEditor.this.table.getSelectedColumn(), false);
                    TableEditor.this.table.repaint();
                    TableEditor.this.table.getTableHeader().repaint();
                } else {
                    JOptionPane.showMessageDialog(null, "You did not select a column to sort.");
                }
            }
        };
        JButton sortDown = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_sort-descending.png"))));
        sortDown.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(sortDown);
        sortDown.addActionListener(sortdownAL);
        sortDown.setToolTipText(this.bundle.getString("sortDescendingToolTip"));
        tableToolBar.add(Box.createHorizontalStrut(15));
        JButton insertRowAfter = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_insert-rows.png"))));
        insertRowAfter.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(insertRowAfter);
        insertRowAfter.addActionListener(new Action_insertRowAfter());
        insertRowAfter.setToolTipText(this.bundle.getString("insertRowAfterTooltip"));
        JButton insertColumnAfter = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_insert-columns.png"))));
        insertColumnAfter.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(insertColumnAfter);
        insertColumnAfter.addActionListener(new Action_insertColumnAfter());
        insertColumnAfter.setToolTipText(this.bundle.getString("insertColumnAfterTooltip"));
        JButton split = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/spliting.gif"))));
        split.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(split);
        split.addActionListener(new Action_splitTable());
        split.setToolTipText(this.bundle.getString("splitTooltip"));
        tableToolBar.add(Box.createHorizontalStrut(10));
        JButton properties = new JButton(new ImageIcon(tk.getImage(WikiWizardApplet.class.getResource(resource_ico + "/stock_file-properties.png"))));
        properties.setMargin(new Insets(1, 1, 1, 1));
        tableToolBar.add(properties);
        properties.addActionListener(new Action_setModel());
        properties.setToolTipText(this.bundle.getString("propertyTooltip"));
        return tableToolBar;
    }

    public JTable getTable() {
        return this.table;
    }

    public void importTable() {
        this.removeSelection();
        this.deleteAllCellContent();
        if (this.strip) {
            this.splitTable();
            this.pasteExport(this.theWikiWizardApplert.shortTextField().substring(this.textPane.getSelectionStart(), this.textPane.getSelectionEnd()));
        }
        this.maxRow();
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            this.dispose();
            this.theWikiWizardApplert.removeTable = true;
            this.theWikiWizardApplert.getTextWindow().requestFocus();
        }
        if (evt.getKeyCode() == 83 && evt.isControlDown()) {
            new Action_accept().actionPerformed(null);
        }
        if (evt.getKeyCode() == 127) {
            this.remove();
            this.table.repaint();
        } else if (evt.getKeyCode() == 88 && evt.isControlDown()) {
            this.cut();
        } else if (evt.getKeyCode() == 67 && evt.isControlDown()) {
            this.copy();
        } else if (evt.getKeyCode() == 86 && evt.isControlDown()) {
            this.paste();
        } else if (evt.getKeyCode() == 114) {
            new Action_PictureDialog().actionPerformed(null);
        } else if (evt.getKeyCode() == 115) {
            new Action_mailToDialog().actionPerformed(null);
        } else if (evt.getKeyCode() == 116) {
            new Action_Link().actionPerformed(null);
        }
    }

    public void setTableHeaders() {
        if (this.columnHeader == null) {
            this.columnHeader = new JTableHeader(this.table.getColumnModel());
            this.table.setTableHeader(this.columnHeader);
            this.columnHeader = this.table.getTableHeader();
            this.columnHeader.addMouseListener(this);
        } else {
            this.columnHeader.setColumnModel(this.table.getColumnModel());
        }
        this.theRowHeaderListModel = new RowHeaderListModel(this.table);
        this.rowHeader = new JList(this.theRowHeaderListModel);
        this.rowHeader.setFixedCellWidth(25);
        this.rowHeader.setBackground(new Color(2, 2, 2, 0));
        this.rowHeader.setCellRenderer(new RowHeaderRenderer(this.table, this));
        this.rowHeader.addMouseListener(this);
        JViewport viewport = new JViewport();
        viewport.setView(this.rowHeader);
        this.scroller.setRowHeader(viewport);
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void setHeader(boolean[] header) {
        this.header = header;
    }

    public void cut() {
        this.copy();
        this.remove();
    }

    public void actionPerformed(ActionEvent e) {
        this.validate();
    }

    public void keyReleased(KeyEvent evt) {
    }

    public boolean[] getHeader() {
        return this.header;
    }

    public void maxRow() {
        this.columns = this.table.getRowCount();
        this.rows = this.table.getColumnCount();
        this.maxrow = new int[this.cellHeights.length];
        for (int i = 0; i < this.columns; ++i) {
            int maximal = 0;
            for (int f = 0; f < this.rows; ++f) {
                int item = this.cellHeights[i][f];
                if (item <= maximal) continue;
                maximal = item;
            }
            if (maximal != 0) {
                this.table.setRowHeight(i, maximal);
                this.maxrow[i] = maximal;
                this.setTableHeaders();
            }
            if (maximal != 0) continue;
            this.table.setRowHeight(i, 18);
            this.maxrow[i] = 18;
            this.setTableHeaders();
        }
    }

    public void update(Observable arg0, Object arg1) {
        if (arg1 instanceof Properties) {
            Properties property = (Properties)arg1;
            int height = (Integer)property.get("Height");
            int row = (Integer)property.get("EditingRow");
            int column = (Integer)property.get("EditingColumn");
            this.cellHeights[row][column] = height;
            this.maxRow();
        } else if ((String)arg1 == "Table Modell setzen") {
            this.setTableModel();
        }
    }

    private JMenuBar createMenu() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(this.createMenu_Edit());
        return mbar;
    }

    private JMenu createMenu_Edit() {
        JMenu workMenu = new JMenu(this.bundle.getString("editMenu"));
        workMenu.setFont(this.menuFontSize);
        workMenu.setMnemonic(this.bundle.getString("editMnemonic").charAt(0));
        JMenuItem undo = new JMenuItem(this.bundle.getString("undoMenu"));
        undo.setFont(this.menuFontSize);
        undo.addActionListener(new Action_Undo());
        undo.setMnemonic(this.bundle.getString("undoMnemonic").charAt(0));
        undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        workMenu.add(undo);
        JMenuItem reundo = new JMenuItem(this.bundle.getString("redoMenu"));
        reundo.setMnemonic(this.bundle.getString("redoMnemonic").charAt(0));
        reundo.setFont(this.menuFontSize);
        reundo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        reundo.addActionListener(new Action_ReUndo());
        workMenu.add(reundo);
        workMenu.addSeparator();
        JMenuItem cut = new JMenuItem(this.bundle.getString("cutMenu"));
        cut.setMnemonic(this.bundle.getString("cutMnemonic").charAt(0));
        cut.setFont(this.menuFontSize);
        cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        cut.addActionListener(new Action_cut());
        workMenu.add(cut);
        JMenuItem copy = new JMenuItem(this.bundle.getString("copyMenu"));
        copy.setMnemonic(this.bundle.getString("copyMnemonic").charAt(0));
        copy.setFont(this.menuFontSize);
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        copy.addActionListener(new Action_copy());
        workMenu.add(copy);
        JMenuItem paste = new JMenuItem(this.bundle.getString("pasteMenu"));
        paste.setMnemonic(this.bundle.getString("pasteMnemonic").charAt(0));
        paste.setFont(this.menuFontSize);
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        paste.addActionListener(new Action_paste());
        workMenu.add(paste);
        return workMenu;
    }

    private JPopupMenu createPopup(boolean addColumn, int cindex, boolean addRow, int rindex, boolean header, boolean cheader, int row, int col) {
        JMenuItem scM;
        JMenuItem headerM;
        ActionListener listener = this.table.getActionForKeyStroke(KeyStroke.getKeyStroke("control C"));
        AbstractAction action = (AbstractAction)listener;
        ActionEvent e = new ActionEvent(this, 1001, "Copy");
        JPopupMenu popupMenu = new JPopupMenu();
        this.mrow = row;
        this.mcol = col;
        if (!header) {
            headerM = new JMenuItem(this.bundle.getString("setHeaderPU"));
            headerM.setFont(this.menuFontSize);
            popupMenu.add(headerM);
            headerM.addActionListener(new Action_setHeaderAt(rindex));
        }
        if (header) {
            headerM = new JMenuItem(this.bundle.getString("removeHeaderPU"));
            headerM.setFont(this.menuFontSize);
            popupMenu.add(headerM);
            headerM.addActionListener(new Action_removeHeaderAt(rindex));
        }
        popupMenu.addSeparator();
        JMenuItem copy = new JMenuItem(this.bundle.getString("copyPopup"));
        copy.setFont(this.menuFontSize);
        popupMenu.add(copy);
        copy.addActionListener(new Action_copy());
        JMenuItem cut = new JMenuItem(this.bundle.getString("cutPopup"));
        cut.setFont(this.menuFontSize);
        popupMenu.add(cut);
        cut.addActionListener(new Action_cut());
        JMenuItem paste = new JMenuItem(this.bundle.getString("pastePopup"));
        paste.setFont(this.menuFontSize);
        popupMenu.add(paste);
        paste.addActionListener(new Action_paste());
        if (addColumn) {
            popupMenu.addSeparator();
            JMenuItem addCol = new JMenuItem(this.bundle.getString("addColumnPU"));
            addCol.setFont(this.menuFontSize);
            popupMenu.add(addCol);
            addCol.addActionListener(new Action_addColumnAt(cindex));
            JMenuItem addColafter = new JMenuItem(this.bundle.getString("addColumnPUafter"));
            addColafter.setFont(this.menuFontSize);
            popupMenu.add(addColafter);
            addColafter.addActionListener(new Action_addColumnAt(cindex + 1));
            JMenuItem removeCol = new JMenuItem(this.bundle.getString("deleteColumnPU"));
            removeCol.setFont(this.menuFontSize);
            popupMenu.add(removeCol);
            removeCol.addActionListener(new Action_removeColumnAt(cindex));
        }
        if (addRow) {
            popupMenu.addSeparator();
            JMenuItem addR = new JMenuItem(this.bundle.getString("addRowPU"));
            addR.setFont(this.menuFontSize);
            popupMenu.add(addR);
            addR.addActionListener(new Action_addRowAt(rindex));
            JMenuItem addRafter = new JMenuItem(this.bundle.getString("addRowPUafter"));
            addRafter.setFont(this.menuFontSize);
            popupMenu.add(addRafter);
            addRafter.addActionListener(new Action_addRowAt(rindex + 1));
            JMenuItem removeR = new JMenuItem(this.bundle.getString("deleteRowPU"));
            removeR.setFont(this.menuFontSize);
            popupMenu.add(removeR);
            removeR.addActionListener(new Action_removeRowAt(rindex));
        }
        JMenuItem copyEMail = new JMenuItem(this.bundle.getString("copyMailingList"));
        copyEMail.setFont(this.menuFontSize);
        copyEMail.addActionListener(new Action_createMailingList());
        JMenu copyAs = new JMenu(this.bundle.getString("copyAsPopup"));
        copyAs.setFont(this.menuFontSize);
        copyAs.add(copyEMail);
        popupMenu.add(copyAs);
        copyAs.addActionListener(new Action_paste());
        popupMenu.addSeparator();
        if (this.sourceCode[row][col]) {
            scM = new JMenuItem(this.bundle.getString("sourceCodeOFF"));
            scM.setFont(this.menuFontSize);
            scM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TableEditor.this.sourceCode[((TableEditor)TableEditor.this).mrow][((TableEditor)TableEditor.this).mcol] = false;
                    TableEditor.this.table.repaint();
                }
            });
            popupMenu.add(scM);
        } else {
            scM = new JMenuItem(this.bundle.getString("sourceCodeON"));
            scM.setFont(this.menuFontSize);
            scM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    TableEditor.this.sourceCode[((TableEditor)TableEditor.this).mrow][((TableEditor)TableEditor.this).mcol] = true;
                    TableEditor.this.table.repaint();
                }
            });
            popupMenu.add(scM);
        }
        return popupMenu;
    }

    public void deleteAllCellContent() {
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            for (int c = 0; c < this.table.getColumnCount(); ++c) {
                this.table.setValueAt("", r, c);
            }
        }
        this.select(0, 0);
        this.table.repaint();
    }

    public void remove() {
        int[] rows = this.table.getSelectedRows();
        int[] columns = this.table.getSelectedColumns();
        for (int r = 0; r < rows.length; ++r) {
            for (int c = 0; c < columns.length; ++c) {
                this.table.setValueAt("", rows[r], columns[c]);
            }
        }
    }

    public void setTableModel() {
        int height = 1;
        this.rows = this.table.getRowCount();
        this.columns = this.table.getColumnCount();
        try {
            this.rows = Integer.valueOf(this.propertiesDialog.getRows());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.columns = Integer.valueOf(this.propertiesDialog.getColumns());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            height = Integer.valueOf(this.propertiesDialog.getColumnHeight());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cellHeights = new int[this.rows][this.columns];
        this.sourceCode = new boolean[this.rows][this.columns];
        this.header = new boolean[this.rows];
        this.model = new OurTableModel(this.rows, this.columns, this);
        this.table.setModel(this.model);
        for (int r = 0; r < this.table.getRowCount(); ++r) {
            for (int c = 0; c < this.table.getColumnCount(); ++c) {
                String in = "";
                this.cellHeights[r][c] = height * 18;
                for (int i = 0; i < height - 1; ++i) {
                    in = in + "\n";
                }
                this.table.setValueAt(new String(in), r, c);
                TableCellEditor f = this.table.getCellEditor(c, r);
                OurTableCellEditor f2 = (OurTableCellEditor)f;
                f2.setCaretToStart();
            }
        }
        this.maxRow();
    }

    public void setSelection(int plusr, int plusc) {
        try {
            this.table.setRowSelectionInterval(this.table.getSelectedRow() + plusc, this.table.getSelectedRow() + plusc);
            this.table.setColumnSelectionInterval(this.table.getSelectedColumn() + plusr, this.table.getSelectedColumn() + plusr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void splitTable() {
        int i;
        if (this.table.getCellEditor() != null) {
            this.table.getCellEditor().stopCellEditing();
        }
        boolean empty = false;
        int height = 0;
        int width = 0;
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            for (int column = 0; column < this.table.getColumnCount(); ++column) {
                if (this.table.getValueAt(row, column) == null || this.table.getValueAt(row, column).equals("") || this.table.getValueAt(row, column) == null) continue;
                if (row > height) {
                    height = row;
                }
                if (column <= width) continue;
                width = column;
            }
        }
        int count = this.table.getRowCount() - 1;
        for (i = height; i < count; ++i) {
            try {
                this.model.removeRow();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        count = this.table.getColumnCount() - 1;
        for (i = width; i < count; ++i) {
            try {
                this.model.removeColumn();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.table.repaint();
        this.table.validate();
    }

    public void select(int r, int c) {
        this.table.setRowSelectionInterval(r, r);
        this.table.setColumnSelectionInterval(c, c);
    }

    public void setModel() {
        this.theWikiWizardApplert.setJMenuBar(this.createMenu());
        this.table.requestFocus();
    }

    public void copy() {
        StringBuffer sbf = new StringBuffer();
        int numcols = this.table.getSelectedColumnCount();
        int numrows = this.table.getSelectedRowCount();
        int[] rowsselected = this.table.getSelectedRows();
        int[] colsselected = this.table.getSelectedColumns();
        if (rowsselected.length > 0) {
            if (numrows - 1 != rowsselected[rowsselected.length - 1] - rowsselected[0] || numrows != rowsselected.length || numcols - 1 != colsselected[colsselected.length - 1] - colsselected[0] || numcols != colsselected.length) {
                JOptionPane.showMessageDialog(null, "Invalid Copy Selection", "Invalid Copy Selection", 0);
                return;
            }
            for (int i = 0; i < numrows; ++i) {
                for (int j = 0; j < numcols; ++j) {
                    String tex = (String)this.table.getValueAt(rowsselected[i], colsselected[j]);
                    if (tex != null && tex.indexOf("\n") > -1) {
                        tex = "{{{" + tex + "}}}";
                    }
                    sbf.append(tex);
                    if (j >= numcols - 1) continue;
                    sbf.append("\t");
                }
                if (i == numrows - 1) continue;
                sbf.append("\n");
            }
            this.stsel = new StringSelection(sbf.toString());
            this.system = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.system.setContents(this.stsel, this.stsel);
            this.repaint();
        }
    }

    public boolean pictureAction() {
        String stf = "";
        boolean changed = true;
        boolean in = false;
        int end = 0;
        int start = 0;
        JTextArea text = null;
        if (this.table.isEditing()) {
            OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)this.table.getCellEditor();
            text = OurTableCellEditor.currentCellEditor;
            stf = text.getText();
            if (stf == null) {
                stf = "";
            }
            int i = text.getCaretPosition();
            while (changed) {
                if (i == stf.length() || i + 2 <= stf.length() && stf.substring(i, i + 2).equals("[{")) {
                    changed = false;
                    in = false;
                } else if (stf.substring(i, i + 1).equals("]")) {
                    in = true;
                    changed = false;
                    end = i;
                }
                ++i;
            }
            changed = true;
            i = text.getCaretPosition();
            while (changed) {
                if (i + 2 <= stf.length() && stf.substring(i, i + 2).equals("[{")) {
                    if (in) {
                        in = true;
                    }
                    changed = false;
                    start = i;
                } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                    changed = false;
                    in = false;
                }
                --i;
            }
        } else if (stf.indexOf("[{") > -1 && stf.indexOf("}]") > -1 && stf.indexOf("[{") < stf.indexOf("}]")) {
            in = true;
        }
        String image = "";
        String caption = "";
        String width = "";
        if (in) {
            String part = stf;
            if (part.indexOf("width") > -1) {
                width = part.substring(part.indexOf("'", part.indexOf("width")) + 1, part.indexOf("'", part.indexOf("'", part.indexOf("width")) + 1));
                width = width.trim();
            }
            if (part.indexOf("Image src") > -1) {
                int point2;
                int point;
                if (part.indexOf("caption") > -1) {
                    image = part.substring(part.indexOf("Image src"), part.indexOf("caption"));
                    caption = part.substring(part.indexOf("caption"), part.length());
                    if (caption.substring(7, caption.length()).indexOf("=") > -1 && (caption = caption.substring(caption.substring(7, caption.length()).indexOf("=") + 1 + 7, caption.length())).indexOf("'") > -1 && caption.indexOf("'", (point = caption.indexOf("'")) + 1) > -1) {
                        point2 = caption.indexOf("'", point + 1);
                        caption = caption.substring(point + 1, point2);
                    }
                } else {
                    image = part.substring(part.indexOf("Image src"), part.length());
                }
                if (image.substring(9, image.length()).indexOf("=") > -1 && (image = image.substring(image.substring(9, image.length()).indexOf("=") + 1 + 9, image.length())).indexOf("'") > -1 && image.indexOf("'", (point = image.indexOf("'")) + 1) > -1) {
                    point2 = image.indexOf("'", point + 1);
                    image = image.substring(point + 1, point2);
                }
            }
        }
        String appendix = "";
        try {
            if (this.theWikiWizardApplert.getParameter("page") != null) {
                appendix = this.theWikiWizardApplert.getParameter("page");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (image.indexOf("/") > -1) {
            appendix = image.substring(0, image.indexOf("/"));
            image = image.substring(image.indexOf("/") + 1, image.length());
        }
        if (!image.equals("")) {
            this.theWikiWizardApplert.loadAttachments();
            if (in) {
                text.select(start, end + 1);
            }
            this.pictureD = new PictureDialog(this.own, true, (Object)this.theWikiWizardApplert, caption, image, appendix, width, "");
            this.pictureD.setModal(true);
            this.pictureD.pack();
            this.pictureD.addKeyListener(this.theWikiWizardApplert);
            this.pictureD.setLocationRelativeTo(this.own);
            this.pictureD.setResizable(false);
            this.pictureD.show();
            return true;
        }
        return false;
    }

    public void removeSelection() {
        if (this.table.getSelectedColumns().length == 0 && this.table.getSelectedRows().length == 0) {
            this.table.setRowSelectionInterval(0, 0);
            this.table.setColumnSelectionInterval(0, 0);
        }
    }

    public void paste() {
        String export = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents(clipboard);
        try {
            export = (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (export.indexOf("\t") < 0) {
            StringBuffer contentBuffer;
            String sContent;
            if (!this.bPressedTimes) {
                this.table.setValueAt(export, this.table.getSelectedRow(), this.table.getSelectedColumn());
                if (this.selStart != -1 && this.selEnd != -1) {
                    sContent = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()).toString();
                    contentBuffer = new StringBuffer(sContent);
                    this.table.setValueAt(contentBuffer.replace(this.selStart, this.selEnd, export).toString(), this.table.getSelectedRow(), this.table.getSelectedColumn());
                }
            }
            if (this.bPressedTimes) {
                if (this.selStart == -1 || this.selEnd == -1) {
                    sContent = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()).toString();
                    if (sContent != null) {
                        if (this.iCursorPos <= sContent.length()) {
                            contentBuffer = new StringBuffer(sContent);
                            contentBuffer.insert(this.iCursorPos, export);
                            this.table.setValueAt(contentBuffer.toString(), this.table.getSelectedRow(), this.table.getSelectedColumn());
                        } else {
                            this.table.setValueAt(sContent + export, this.table.getSelectedRow(), this.table.getSelectedColumn());
                        }
                    } else {
                        this.table.setValueAt(export, this.table.getSelectedRow(), this.table.getSelectedColumn());
                    }
                } else {
                    sContent = this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()).toString();
                    contentBuffer = new StringBuffer(sContent);
                    this.table.setValueAt(contentBuffer.replace(this.selStart, this.selEnd, export).toString(), this.table.getSelectedRow(), this.table.getSelectedColumn());
                }
                this.bPressedTimes = false;
            }
        } else {
            export = " " + export.substring(0, export.length());
            int start = 0;
            int row = 0;
            int col = 0;
            boolean http = false;
            for (int z = 0; z < export.length(); ++z) {
                if (z + 2 < export.length() && export.substring(z, z + 3).equals("{{{")) {
                    http = true;
                }
                if (z + 2 < export.length() && export.substring(z, z + 3).equals("}}}")) {
                    http = false;
                }
                if (http || !export.substring(z, z + 1).equals("\n") && z != export.length() - 1) continue;
                String token = export.substring(start + 1, z);
                if (z == export.length() - 1) {
                    token = export.substring(start + 1, z + 1);
                }
                if (token.length() > 2 && token.substring(0, 2).equals("||")) {
                    token = token.substring(2, token.length());
                }
                if (token.length() > 1 && token.substring(0, 1).equals("\t")) {
                    token = token.substring(1, token.length());
                }
                int cstart = 0;
                boolean headerset = false;
                boolean multiline = false;
                boolean multi = false;
                boolean link = false;
                int lines = 0;
                for (int c = 0; c <= token.length(); ++c) {
                    if (c + 3 <= token.length() && token.substring(c, c + 3).equals("{{{")) {
                        multiline = true;
                        multi = true;
                    } else if (c + 3 <= token.length() && token.substring(c, c + 3).equals("}}}")) {
                        multiline = false;
                    } else if (multiline && token.substring(c, c + 1).equals("\n")) {
                        ++lines;
                    } else if (c + 1 <= token.length() && token.substring(c, c + 1).equals("[")) {
                        link = true;
                    } else if (c + 1 <= token.length() && token.substring(c, c + 1).equals("]")) {
                        link = false;
                    }
                    if (link || (c + 1 > token.length() || !token.substring(c, c + 1).equals("\t")) && c != token.length()) continue;
                    if (c + 2 <= token.length() && token.substring(c, c + 2).equals("||")) {
                        headerset = true;
                        token = token.substring(0, c + 1) + token.substring(c + 2, token.length());
                    }
                    String ctoken = token.substring(cstart, c);
                    if (this.table.getRowCount() - 1 < row) {
                        this.model.addRowAt(this.table.getRowCount());
                    }
                    if (this.table.getColumnCount() - 1 < col) {
                        this.model.addColumnAt(this.table.getColumnCount());
                    }
                    if (multi) {
                        ctoken = ctoken.substring(3, ctoken.length() - 3);
                        this.cellHeights[row][col] = (lines + 1) * 18;
                        lines = 0;
                        multi = false;
                    }
                    if (ctoken.equals("null")) {
                        ctoken = "";
                    }
                    this.table.setValueAt(ctoken, row, col);
                    JTextArea r = new JTextArea(ctoken);
                    if (this.add[col] < r.getPreferredSize().width + 5) {
                        this.add[col] = r.getPreferredSize().width + 5;
                    }
                    cstart = c + 1;
                    ++col;
                }
                if (headerset) {
                    this.header[row] = true;
                }
                col = 0;
                ++row;
                start = z;
            }
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                if (this.add[i] <= 0) continue;
                this.table.getColumnModel().getColumn(i).setPreferredWidth(this.add[i]);
            }
            this.maxRow();
        }
    }

    public boolean linkAction() {
        String stf = "";
        boolean changed = true;
        boolean in = false;
        int end = 0;
        int start = 0;
        JTextArea text = null;
        if (this.table.isEditing()) {
            OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)this.table.getCellEditor(this.table.getSelectedRow(), this.table.getSelectedColumn());
            text = OurTableCellEditor.currentCellEditor;
            stf = text.getText();
            if (stf == null) {
                stf = "";
            }
            int i = text.getCaretPosition();
            while (changed) {
                if (i == stf.length() || stf.substring(i, i + 1).equals("[")) {
                    changed = false;
                    in = false;
                } else if (stf.substring(i, i + 1).equals("]")) {
                    in = true;
                    changed = false;
                    end = i;
                }
                ++i;
            }
            changed = true;
            i = text.getCaretPosition();
            while (changed) {
                if (i + 1 < stf.length() && stf.substring(i, i + 1).equals("[")) {
                    if (in) {
                        in = true;
                    }
                    changed = false;
                    start = i;
                } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                    changed = false;
                    in = false;
                }
                --i;
            }
        } else if (stf.indexOf("[") > -1 && stf.indexOf("]") > -1 && stf.indexOf("[") < stf.indexOf("]")) {
            in = true;
            start = 0;
            end = stf.length() - 1;
        }
        String url = "";
        String Label = "";
        if (in) {
            String tex = stf.substring(start + 1, end);
            StringTokenizer str = new StringTokenizer(tex, "|");
            try {
                Label = str.nextToken();
                url = str.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (url == "" && Label != "") {
            url = Label;
            Label = "";
        }
        boolean http = true;
        if (url.indexOf("http://") < 0 && in) {
            http = false;
        }
        if (!url.equals("")) {
            if (url.length() > 2 && url.substring(0, 1).equals("{") && url.substring(url.length() - 1, url.length()).equals("}")) {
                return false;
            }
            text.select(start, end + 1);
            this.linkDialog = new LinkDialog(this.own, true, false, this.theWikiWizardApplert, Label, url, http);
            this.linkDialog.pack();
            this.linkDialog.addKeyListener(this.theWikiWizardApplert);
            this.linkDialog.setLocationRelativeTo(this.theWikiWizardApplert);
            this.linkDialog.setResizable(false);
            this.linkDialog.show();
            return true;
        }
        return false;
    }

    public boolean mailAction() {
        String stf = "";
        boolean changed = true;
        boolean in = false;
        int end = 0;
        int start = 0;
        JTextArea text = null;
        if (this.table.isEditing()) {
            OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)this.table.getCellEditor();
            text = OurTableCellEditor.currentCellEditor;
            stf = text.getText();
            if (stf == null) {
                stf = "";
            }
            int i = text.getCaretPosition();
            while (changed) {
                if (i == stf.length() || stf.substring(i, i + 1).equals("[")) {
                    changed = false;
                    in = false;
                } else if (stf.substring(i, i + 1).equals("]")) {
                    in = true;
                    changed = false;
                    end = i;
                }
                ++i;
            }
            changed = true;
            i = text.getCaretPosition();
            while (changed) {
                if (i + 1 < stf.length() && stf.substring(i, i + 1).equals("[")) {
                    if (in) {
                        in = true;
                    }
                    changed = false;
                    start = i;
                } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                    changed = false;
                    in = false;
                }
                --i;
            }
        } else if (stf.indexOf("[") > -1 && stf.indexOf("]") > -1 && stf.indexOf("[") < stf.indexOf("]")) {
            in = true;
            start = 0;
            end = stf.length() - 1;
        }
        String mail = "";
        String Label = "";
        if (in) {
            String tex = stf.substring(start + 1, end);
            StringTokenizer str = new StringTokenizer(tex, "|");
            try {
                Label = str.nextToken();
                mail = str.nextToken();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mail == "" && Label != "") {
            mail = Label;
            Label = "";
        }
        if (mail.indexOf("mailto:", 0) < 0) {
            mail = "";
            Label = "";
        } else {
            mail = mail.substring(7, mail.length());
        }
        if (mail.indexOf("@") < 0) {
            mail = "";
            Label = "";
        }
        if (!mail.equals("")) {
            if (in) {
                text.select(start, end + 1);
            }
            this.mailToDialog = new MailToDialog(this.own, true, this.theWikiWizardApplert, Label, mail, in);
            this.mailToDialog.pack();
            this.mailToDialog.addKeyListener(this.theWikiWizardApplert);
            this.mailToDialog.setLocationRelativeTo(this.theWikiWizardApplert);
            this.mailToDialog.setResizable(false);
            this.mailToDialog.show();
            return true;
        }
        return false;
    }

    public void pasteExport(String export) {
        int start = 0;
        int row = 0;
        int col = 0;
        boolean sourceCodeIdentified = false;
        int first = 0;
        for (int z = 0; z < export.length(); ++z) {
            if (z + 2 < export.length() && export.substring(z, z + 3).equals("{{{")) {
                sourceCodeIdentified = true;
            }
            if (z + 2 < export.length() && export.substring(z, z + 3).equals("}}}")) {
                sourceCodeIdentified = false;
            }
            if (sourceCodeIdentified || !export.substring(z, z + 1).equals("\n") && z != export.length() - 1) continue;
            String token = export.substring(start + first, z);
            if (z == export.length() - 1) {
                token = export.substring(start + first, z + 1);
            }
            first = 1;
            int cstart = 0;
            boolean headerset = false;
            boolean multiline = false;
            boolean multi = false;
            boolean link = false;
            int lines = 0;
            boolean sc = false;
            if (token.length() > 2 && token.substring(0, 2).equals("||")) {
                token = token.substring(2, token.length());
                headerset = true;
            }
            if (token.length() > 1 && token.substring(0, 1).equals("|")) {
                token = token.substring(1, token.length());
            }
            for (int c = 0; c <= token.length(); ++c) {
                if (c + 3 <= token.length() && token.substring(c, c + 3).equals("{{{") && c == 0) {
                    multiline = true;
                } else if (c + 4 <= token.length() && token.substring(c, c + 4).equals("}}}|") || c + 3 <= token.length() && token.substring(c, c + 3).equals("}}}") && c == token.length() - 3) {
                    sc = true;
                    multi = true;
                    multiline = false;
                } else if (c + 2 <= token.length() && token.substring(c, c + 2).equals("\\\\")) {
                    token = token.substring(0, c) + "\n" + token.substring(c + 2, token.length());
                    ++lines;
                } else if (multiline && c + 1 <= token.length() && token.substring(c, c + 1).equals("\n")) {
                    ++lines;
                } else if (c + 1 <= token.length() && token.substring(c, c + 1).equals("[")) {
                    link = true;
                } else if (c + 1 <= token.length() && token.substring(c, c + 1).equals("]")) {
                    link = false;
                }
                if (link || (c + 1 > token.length() || !token.substring(c, c + 1).equals("|")) && c != token.length()) continue;
                if (c + 2 <= token.length() && token.substring(c, c + 2).equals("||")) {
                    headerset = true;
                    token = token.substring(0, c + 1) + token.substring(c + 2, token.length());
                }
                String ctoken = token.substring(cstart, c);
                if (this.table.getRowCount() - 1 < row) {
                    this.model.addRowAt(this.table.getRowCount());
                }
                if (this.table.getColumnCount() - 1 < col) {
                    this.model.addColumnAt(this.table.getColumnCount());
                }
                if (lines > 0) {
                    this.cellHeights[row][col] = (lines + 1) * 18;
                }
                if (multi) {
                    ctoken = ctoken.substring(3, ctoken.length() - 3);
                    lines = 0;
                    multi = false;
                }
                if (sc && !multi) {
                    sc = false;
                    this.sourceCode[row][col] = true;
                }
                this.table.setValueAt(ctoken, row, col);
                JTextArea r = new JTextArea(ctoken);
                if (this.add[col] < r.getPreferredSize().width + 5) {
                    this.add[col] = r.getPreferredSize().width + 5;
                }
                cstart = c + 1;
                ++col;
            }
            if (headerset) {
                this.header[row] = true;
            }
            col = 0;
            ++row;
            start = z;
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.add[i] <= 0) continue;
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.add[i]);
        }
        this.maxRow();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void show() {
        super.show();
        this.table.requestFocus();
        this.table.editCellAt(0, 0);
    }

    public void loadWidth() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.add.length <= i) continue;
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.add[i]);
        }
    }

    public int[][] getMax() {
        return this.cellHeights;
    }

    public int[] getMaxRow() {
        return this.maxrow;
    }

    public void setMax(int[][] max) {
        this.cellHeights = max;
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        boolean addColumn = false;
        boolean addRow = false;
        boolean header = false;
        boolean cheader = false;
        int cindex = 0;
        int rindex = 0;
        if (evt.getComponent() == this.columnHeader) {
            addColumn = true;
            cindex = this.columnHeader.columnAtPoint(evt.getPoint());
            cheader = true;
        }
        if (evt.getComponent() == this.rowHeader) {
            addRow = true;
            rindex = this.rowHeader.locationToIndex(evt.getPoint());
            if (this.header[rindex]) {
                header = true;
            }
        }
        int column = this.table.columnAtPoint(evt.getPoint());
        int row = this.table.rowAtPoint(evt.getPoint());
        if (evt.isPopupTrigger()) {
            JPopupMenu popup = this.createPopup(addColumn, cindex, addRow, rindex, header, cheader, row, column);
            popup.show(this.table, evt.getX(), evt.getY());
        }
        if (evt.getComponent() == this.rowHeader) {
            int index;
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            if ((index = this.rowHeader.locationToIndex(evt.getPoint())) > -1) {
                this.table.setRowSelectionInterval(index, index);
            }
            this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
            this.table.requestFocus();
            this.table.repaint();
        }
        if (evt.getComponent() == this.columnHeader) {
            int index;
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            if ((index = this.columnHeader.columnAtPoint(evt.getPoint())) > -1) {
                this.table.setColumnSelectionInterval(index, index);
            }
            this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
            this.table.requestFocus();
            this.table.repaint();
        }
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
        boolean addColumn = false;
        boolean addRow = false;
        boolean header = false;
        boolean cheader = false;
        int cindex = 0;
        int rindex = 0;
        if (evt.getClickCount() == 1) {
            this.bPressedTimes = false;
        }
        if (evt.getClickCount() == 2) {
            this.bPressedTimes = true;
            if (this.table.isEditing() && this.table.isEditing()) {
                this.getCursorPosInCell();
            }
        }
        if (evt.getComponent() == this.columnHeader) {
            addColumn = true;
            cindex = this.columnHeader.columnAtPoint(evt.getPoint());
            cheader = true;
        }
        if (evt.getComponent() == this.rowHeader) {
            addRow = true;
            rindex = this.rowHeader.locationToIndex(evt.getPoint());
            if (this.header[rindex]) {
                header = true;
            }
        }
        int column = this.table.columnAtPoint(evt.getPoint());
        int row = this.table.rowAtPoint(evt.getPoint());
        if (evt.isPopupTrigger()) {
            JPopupMenu popup = this.createPopup(addColumn, cindex, addRow, rindex, header, cheader, row, column);
            popup.show(this.table, evt.getX(), evt.getY());
        }
        if (evt.getComponent() == this.rowHeader) {
            int index;
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            if ((index = this.rowHeader.locationToIndex(evt.getPoint())) > -1) {
                this.table.setRowSelectionInterval(index, index);
            }
            this.table.setColumnSelectionInterval(0, this.table.getColumnCount() - 1);
            this.table.requestFocus();
            this.table.repaint();
        }
        if (evt.getComponent() == this.columnHeader) {
            int index;
            if (this.table.getCellEditor() != null) {
                this.table.getCellEditor().stopCellEditing();
            }
            if ((index = this.columnHeader.columnAtPoint(evt.getPoint())) > -1) {
                this.table.setColumnSelectionInterval(index, index);
            }
            this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
            this.table.requestFocus();
            this.table.repaint();
        }
    }

    public void getCursorPosInCell() {
        OurTableCellEditor f = (OurTableCellEditor)this.table.getCellEditor();
        this.myEditingComponent = f.getEditingComp();
        this.myEditingComponent.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent arg0) {
                TableEditor.this.iCursorPos = TableEditor.this.myEditingComponent.getCaretPosition();
                if (TableEditor.this.myEditingComponent.getSelectedText() == null) {
                    TableEditor.this.selStart = -1;
                    TableEditor.this.selEnd = -1;
                } else {
                    TableEditor.this.selStart = TableEditor.this.myEditingComponent.getSelectionStart();
                    TableEditor.this.selEnd = TableEditor.this.myEditingComponent.getSelectionEnd();
                }
            }
        });
    }

    public void setSC(boolean[][] sourceCode) {
        this.sourceCode = sourceCode;
    }

    public boolean[][] getSourceCode() {
        return this.sourceCode;
    }

    public void windowOpened(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.theWikiWizardApplert.removeTable = true;
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    class Action_Undo
    extends AbstractAction {
        Action_Undo() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.table.getCellEditor() != null) {
                OurTableCellEditor f = (OurTableCellEditor)TableEditor.this.table.getCellEditor();
                f.undo();
            }
        }
    }

    class Action_ReUndo
    extends AbstractAction {
        Action_ReUndo() {
        }

        public void actionPerformed(ActionEvent evt) {
        }
    }

    class Action_mailToDialog
    extends AbstractAction {
        Action_mailToDialog() {
        }

        public void actionPerformed(ActionEvent evt) {
            String stf = "";
            boolean changed = true;
            boolean in = false;
            int end = 0;
            int start = 0;
            if (TableEditor.this.table.isEditing()) {
                OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)TableEditor.this.table.getCellEditor();
                JTextArea text = OurTableCellEditor.currentCellEditor;
                stf = text.getText();
                if (stf == null) {
                    stf = "";
                }
                int i = text.getCaretPosition();
                while (changed) {
                    if (i == stf.length() || stf.substring(i, i + 1).equals("[")) {
                        changed = false;
                        in = false;
                    } else if (stf.substring(i, i + 1).equals("]")) {
                        in = true;
                        changed = false;
                        end = i;
                    }
                    ++i;
                }
                changed = true;
                i = text.getCaretPosition();
                while (changed) {
                    if (i + 1 < stf.length() && stf.substring(i, i + 1).equals("[")) {
                        if (in) {
                            in = true;
                        }
                        changed = false;
                        start = i;
                    } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                        changed = false;
                        in = false;
                    }
                    --i;
                }
                if (in) {
                    text.select(start, end + 1);
                }
            } else if (stf.indexOf("[") > -1 && stf.indexOf("]") > -1 && stf.indexOf("[") < stf.indexOf("]")) {
                in = true;
                start = 0;
                end = stf.length() - 1;
            }
            String mail = "";
            String Label = "";
            if (in) {
                String tex = stf.substring(start + 1, end);
                StringTokenizer str = new StringTokenizer(tex, "|");
                try {
                    Label = str.nextToken();
                    mail = str.nextToken();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (mail == "" && Label != "") {
                mail = Label;
                Label = "";
            }
            if (mail.indexOf("mailto:", 0) < 0) {
                mail = "";
                Label = "";
            } else {
                mail = mail.substring(7, mail.length());
            }
            if (mail.indexOf("@") < 0) {
                mail = "";
                Label = "";
            }
            TableEditor.this.mailToDialog = new MailToDialog(TableEditor.this.own, true, TableEditor.this.theWikiWizardApplert, Label, mail, in);
            TableEditor.this.mailToDialog.pack();
            TableEditor.this.mailToDialog.addKeyListener(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.mailToDialog.setLocationRelativeTo(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.mailToDialog.setResizable(false);
            TableEditor.this.mailToDialog.show();
        }
    }

    class Action_Link
    extends AbstractAction {
        Action_Link() {
        }

        public void actionPerformed(ActionEvent evt) {
            String stf = "";
            boolean changed = true;
            boolean in = false;
            int end = 0;
            int start = 0;
            if (TableEditor.this.table.isEditing()) {
                OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)TableEditor.this.table.getCellEditor();
                JTextArea text = OurTableCellEditor.currentCellEditor;
                stf = text.getText();
                if (stf == null) {
                    stf = "";
                }
                int i = text.getCaretPosition();
                while (changed) {
                    if (i == stf.length() || stf.substring(i, i + 1).equals("[")) {
                        changed = false;
                        in = false;
                    } else if (stf.substring(i, i + 1).equals("]")) {
                        in = true;
                        changed = false;
                        end = i;
                    }
                    ++i;
                }
                changed = true;
                i = text.getCaretPosition();
                while (changed) {
                    if (i + 1 < stf.length() && stf.substring(i, i + 1).equals("[")) {
                        if (in) {
                            in = true;
                        }
                        changed = false;
                        start = i;
                    } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                        changed = false;
                        in = false;
                    }
                    --i;
                }
                if (in) {
                    text.select(start, end + 1);
                }
            } else if (stf.indexOf("[") > -1 && stf.indexOf("]") > -1 && stf.indexOf("[") < stf.indexOf("]")) {
                in = true;
                start = 0;
                end = stf.length() - 1;
            }
            String url = "";
            String Label = "";
            if (in) {
                String tex = stf.substring(start + 1, end);
                StringTokenizer str = new StringTokenizer(tex, "|");
                try {
                    Label = str.nextToken();
                    url = str.nextToken();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (url == "" && Label != "") {
                url = Label;
                Label = "";
            }
            boolean http = true;
            if (url.indexOf("http://") < 0 && in) {
                http = false;
            }
            if (url.length() > 2 && url.substring(0, 1).equals("{") && url.substring(url.length() - 1, url.length()).equals("}")) {
                url = "";
            }
            TableEditor.this.linkDialog = new LinkDialog(TableEditor.this.own, true, false, TableEditor.this.theWikiWizardApplert, Label, url, http);
            TableEditor.this.linkDialog.pack();
            TableEditor.this.linkDialog.addKeyListener(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.linkDialog.setLocationRelativeTo(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.linkDialog.setResizable(false);
            TableEditor.this.linkDialog.show();
        }
    }

    class Action_PictureDialog
    extends AbstractAction {
        Action_PictureDialog() {
        }

        public void actionPerformed(ActionEvent evt) {
            String stf = "";
            boolean changed = true;
            boolean in = false;
            if (TableEditor.this.table.isEditing()) {
                OurTableCellEditor cfr_ignored_0 = (OurTableCellEditor)TableEditor.this.table.getCellEditor();
                JTextArea text = OurTableCellEditor.currentCellEditor;
                stf = text.getText();
                if (stf == null) {
                    stf = "";
                }
                int end = 0;
                int start = 0;
                int i = text.getCaretPosition();
                while (changed) {
                    if (i == stf.length() || i + 2 <= stf.length() && stf.substring(i, i + 2).equals("[{")) {
                        changed = false;
                        in = false;
                    } else if (stf.substring(i, i + 1).equals("]")) {
                        in = true;
                        changed = false;
                        end = i;
                    }
                    ++i;
                }
                changed = true;
                i = text.getCaretPosition();
                while (changed) {
                    if (i + 2 <= stf.length() && stf.substring(i, i + 2).equals("[{")) {
                        if (in) {
                            in = true;
                        }
                        changed = false;
                        start = i;
                    } else if (i == 0 || i + 1 < stf.length() && stf.substring(i, i + 1).equals("]")) {
                        changed = false;
                        in = false;
                    }
                    --i;
                }
                if (in) {
                    text.select(start, end + 1);
                }
            } else if (stf.indexOf("[{") > -1 && stf.indexOf("}]") > -1 && stf.indexOf("[{") < stf.indexOf("}]")) {
                in = true;
            }
            String image = "";
            String caption = "";
            String width = "";
            if (in) {
                String part = stf;
                if (part.indexOf("width") > -1) {
                    width = part.substring(part.indexOf("'", part.indexOf("width")) + 1, part.indexOf("'", part.indexOf("'", part.indexOf("width")) + 1));
                    width = width.trim();
                }
                if (part.indexOf("Image src") > -1) {
                    int point2;
                    int point;
                    if (part.indexOf("caption") > -1) {
                        image = part.substring(part.indexOf("Image src"), part.indexOf("caption"));
                        caption = part.substring(part.indexOf("caption"), part.length());
                        if (caption.substring(7, caption.length()).indexOf("=") > -1 && (caption = caption.substring(caption.substring(7, caption.length()).indexOf("=") + 1 + 7, caption.length())).indexOf("'") > -1 && caption.indexOf("'", (point = caption.indexOf("'")) + 1) > -1) {
                            point2 = caption.indexOf("'", point + 1);
                            caption = caption.substring(point + 1, point2);
                        }
                    } else {
                        image = part.substring(part.indexOf("Image src"), part.length());
                    }
                    if (image.substring(9, image.length()).indexOf("=") > -1 && (image = image.substring(image.substring(9, image.length()).indexOf("=") + 1 + 9, image.length())).indexOf("'") > -1 && image.indexOf("'", (point = image.indexOf("'")) + 1) > -1) {
                        point2 = image.indexOf("'", point + 1);
                        image = image.substring(point + 1, point2);
                    }
                }
            }
            String appendix = "";
            try {
                if (TableEditor.this.theWikiWizardApplert.getParameter("page") != null) {
                    appendix = TableEditor.this.theWikiWizardApplert.getParameter("page");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (image.indexOf("/") > -1) {
                appendix = image.substring(0, image.indexOf("/"));
                image = image.substring(image.indexOf("/") + 1, image.length());
            }
            TableEditor.this.theWikiWizardApplert.loadAttachments();
            TableEditor.this.pictureD = new PictureDialog(TableEditor.this.own, true, (Object)TableEditor.this.theWikiWizardApplert, caption, image, appendix, width, "");
            TableEditor.this.pictureD.setModal(true);
            TableEditor.this.pictureD.pack();
            TableEditor.this.pictureD.addKeyListener(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.pictureD.setLocationRelativeTo(TableEditor.this.own);
            TableEditor.this.pictureD.setResizable(false);
            TableEditor.this.pictureD.show();
        }
    }

    class Action_deleteAll
    extends AbstractAction {
        Action_deleteAll() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.deleteAllCellContent();
        }
    }

    class Action_paste
    extends AbstractAction {
        Action_paste() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.paste();
            TableEditor.this.table.repaint();
        }
    }

    class Action_setModel
    extends AbstractAction {
        Action_setModel() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.propertiesDialog == null) {
                TableEditor.this.propertiesDialog = new ModelChangeDialog(TableEditor.this.theWikiWizardApplert, TableEditor.this);
            }
            TableEditor.this.propertiesDialog.setLocationRelativeTo(TableEditor.this.theWikiWizardApplert);
            TableEditor.this.propertiesDialog.pack();
            TableEditor.this.propertiesDialog.show();
        }
    }

    class Action_copyTableToEditor
    extends AbstractAction {
        Action_copyTableToEditor() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                TableEditor.this.theWikiWizardApplert.compound(true);
                SimpleAttributeSet normal = new SimpleAttributeSet();
                String copyText = "";
                if (TableEditor.this.table.getCellEditor() != null) {
                    TableEditor.this.table.getCellEditor().stopCellEditing();
                }
                int[] col = TableEditor.this.table.getSelectedColumns();
                int[] row = TableEditor.this.table.getSelectedRows();
                int start = TableEditor.this.textPane.getCaretPosition();
                int rowStart = 0;
                int rowLength = TableEditor.this.table.getRowCount();
                int colStart = 0;
                int colLength = TableEditor.this.table.getColumnCount();
                WikiWizardApplet f2 = TableEditor.this.theWikiWizardApplert;
                try {
                    if (!f2.shortTextField().substring(TableEditor.this.textPane.getCaretPosition() - 1, TableEditor.this.textPane.getCaretPosition()).equals("\n") && TableEditor.this.textPane.getSelectionStart() == TableEditor.this.textPane.getSelectionEnd()) {
                        copyText = copyText + "\n";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                for (int r = rowStart; r < rowLength; ++r) {
                    if (r != rowStart) {
                        copyText = copyText + "\n";
                    }
                    for (int c = colStart; c < colLength; ++c) {
                        if (TableEditor.this.header[r]) {
                            if (copyText.length() > 0 && copyText.substring(copyText.length() - 1, copyText.length()).equals("|")) {
                                copyText = copyText + " ";
                            }
                            copyText = copyText + "||";
                        } else {
                            if (copyText.length() > 0 && copyText.substring(copyText.length() - 1, copyText.length()).equals("|")) {
                                copyText = copyText + " ";
                            }
                            copyText = copyText + "|";
                        }
                        String value = " ";
                        boolean count = false;
                        boolean multilined = false;
                        boolean filled = false;
                        if ((String)TableEditor.this.table.getValueAt(r, c) != null && (String)TableEditor.this.table.getValueAt(r, c) != "") {
                            value = (String)TableEditor.this.table.getValueAt(r, c);
                            int pos = 0;
                            while (value.indexOf("\n", pos) > 0) {
                                int pos2 = value.indexOf("\n", pos);
                                value = value.substring(0, value.indexOf("\n", pos)) + "\\\\" + value.substring(value.indexOf("\n") + 1, value.length());
                                pos = pos2 + 1;
                            }
                        }
                        if (TableEditor.this.sourceCode[r][c]) {
                            value = "{{{" + value + "}}}";
                        }
                        copyText = copyText + value;
                    }
                }
                if (TableEditor.this.textPane.getSelectionStart() != TableEditor.this.textPane.getSelectionEnd()) {
                    TableEditor.this.textPane.replaceSelection(copyText);
                } else {
                    try {
                        StyledDocument s = (StyledDocument)TableEditor.this.textPane.getDocument();
                        s.insertString(TableEditor.this.textPane.getCaretPosition(), copyText, normal);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                TableEditor.this.theWikiWizardApplert.compound(false);
                ((EditorDocument)((TableEditor)TableEditor.this).theWikiWizardApplert.text.getDocument()).highlightSyntax(3);
                WikiWizardApplet f = TableEditor.this.theWikiWizardApplert;
                f.changeState();
                TableEditor.this.textPane.requestFocus();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class Action_createMailingList
    extends AbstractAction {
        Action_createMailingList() {
        }

        public void actionPerformed(ActionEvent evt) {
            String sMailingList = "";
            int[] aSelCols = TableEditor.this.table.getSelectedColumns();
            int[] aSelRows = TableEditor.this.table.getSelectedRows();
            sMailingList = TableEditor.this.model.getCell();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sMailingList), null);
        }
    }

    class Action_insertColumnAfter
    extends AbstractAction {
        Action_insertColumnAfter() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.table.isEditing()) {
                TableEditor.this.table.getCellEditor().stopCellEditing();
            }
            TableEditor.this.model.addColumnAt(TableEditor.this.table.getColumnCount());
        }
    }

    class Action_insertRowAfter
    extends AbstractAction {
        Action_insertRowAfter() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.table.isEditing()) {
                TableEditor.this.table.getCellEditor().stopCellEditing();
            }
            TableEditor.this.model.addRowAt(TableEditor.this.table.getRowCount());
        }
    }

    class Action_splitTable
    extends AbstractAction {
        Action_splitTable() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.splitTable();
            TableEditor.this.maxRow();
        }
    }

    class Action_cut
    extends AbstractAction {
        Action_cut() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.copy();
            TableEditor.this.remove();
        }
    }

    class Action_copy
    extends AbstractAction {
        Action_copy() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.copy();
        }
    }

    class Action_addRowAt
    extends AbstractAction {
        private int rindex;

        public Action_addRowAt(int rindex) {
            this.rindex = rindex;
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.table.isEditing()) {
                TableEditor.this.table.getCellEditor().stopCellEditing();
            }
            TableEditor.this.model.addRowAt(this.rindex);
        }
    }

    class Action_addColumnAt
    extends AbstractAction {
        private int cindex;

        public Action_addColumnAt(int cindex) {
            this.cindex = cindex;
        }

        public void actionPerformed(ActionEvent evt) {
            if (TableEditor.this.table.isEditing()) {
                TableEditor.this.table.getCellEditor().stopCellEditing();
            }
            TableEditor.this.model.addColumnAt(this.cindex);
        }
    }

    class Action_removeRowAt
    extends AbstractAction {
        private int rindex;

        public Action_removeRowAt(int rindex) {
            this.rindex = rindex;
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.model.removeRowAt(this.rindex);
        }
    }

    class Action_removeColumnAt
    extends AbstractAction {
        private int cindex;

        public Action_removeColumnAt(int cindex) {
            this.cindex = cindex;
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.model.removeColumnAt(this.cindex);
        }
    }

    class Action_removeHeaderAt
    extends AbstractAction {
        private int rindex;

        public Action_removeHeaderAt(int rindex) {
            this.rindex = rindex;
        }

        public void actionPerformed(ActionEvent evt) {
            ((TableEditor)TableEditor.this).header[this.rindex] = false;
            TableEditor.this.table.repaint();
        }
    }

    class Action_setHeaderAt
    extends AbstractAction {
        private int rindex;

        public Action_setHeaderAt(int rindex) {
            this.rindex = rindex;
        }

        public void actionPerformed(ActionEvent evt) {
            ((TableEditor)TableEditor.this).header[this.rindex] = true;
            TableEditor.this.table.repaint();
        }
    }

    class Action_cancel
    extends AbstractAction {
        Action_cancel() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.own.dispose();
            ((TableEditor)TableEditor.this).theWikiWizardApplert.removeTable = true;
            TableEditor.this.textPane.setSelectionStart(TableEditor.this.textPane.getSelectionEnd());
            ((EditorDocument)TableEditor.this.textPane.getDocument()).highlightSyntax(3);
        }
    }

    class Action_accept
    extends AbstractAction {
        Action_accept() {
        }

        public void actionPerformed(ActionEvent evt) {
            TableEditor.this.splitTable();
            new Action_copyTableToEditor().actionPerformed(null);
            TableEditor.this.own.dispose();
            ((TableEditor)TableEditor.this).theWikiWizardApplert.removeTable = true;
            ((EditorDocument)TableEditor.this.textPane.getDocument()).highlightSyntax(3);
        }
    }
}

