/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard;

import java.awt.Component;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.wikiwizard.ClientHttpRequest;
import org.wikiwizard.FlashSplash;
import org.wikiwizard.WikiWizardApplet;

public class UploadFileThread
extends Thread {
    String m_uploadURL;
    String m_page;
    File[] m_uploadFiles;
    JPanel m_imagesPanel;
    String m_resource_ico;
    WikiWizardApplet m_own;
    int m_attMaxSize;

    public UploadFileThread(WikiWizardApplet own, String uploadURL, String page, File[] uploadFiles, JPanel imagesPanel, String resource_ico, int attMaxSize) {
        this.m_own = own;
        this.m_uploadURL = uploadURL;
        this.m_page = page;
        this.m_attMaxSize = attMaxSize;
        int numFiles = uploadFiles.length;
        this.m_uploadFiles = new File[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            this.m_uploadFiles[i] = uploadFiles[i];
        }
        this.m_imagesPanel = imagesPanel;
        this.m_resource_ico = resource_ico;
        this.start();
    }

    public void run() {
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            int numFailures = 0;
            String failedFile = "";
            boolean outOfMemoryNow = false;
            String outOfMemoryFiles = "";
            String filesOverMaxSize = "";
            JLabel uploadProgress = new JLabel(this.m_own.bundle.getString("uploading"), new ImageIcon(tk.getImage(FlashSplash.class.getResource(this.m_resource_ico + "/wait30trans.gif"))), 2);
            this.m_imagesPanel.add((Component)uploadProgress, "South");
            for (int i = 0; i < this.m_uploadFiles.length; ++i) {
                String filename = this.m_uploadFiles[i].getName();
                if (this.m_uploadFiles[i].length() > (long)this.m_attMaxSize) {
                    ++numFailures;
                    filesOverMaxSize = filesOverMaxSize + filename + "<br>";
                    failedFile = filename;
                    continue;
                }
                boolean tryagain = true;
                int retries = 3;
                int oneMore = i + 1;
                long lastModified = -1L;
                try {
                    URL oldURL = this.makeURL(this.m_uploadURL + "/" + filename);
                    URLConnection urlConn = oldURL.openConnection();
                    lastModified = urlConn.getLastModified();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                while (tryagain && retries > 0) {
                    tryagain = false;
                    --retries;
                    uploadProgress.setText("<html><body>" + this.m_own.bundle.getString("uploading") + " " + oneMore + "/" + this.m_uploadFiles.length + "<br>" + filename + "</body></html>");
                    ClientHttpRequest http = new ClientHttpRequest(this.m_uploadURL);
                    http.setParameter("page", this.m_page);
                    try {
                        http.setParameter("content", this.m_uploadFiles[i]);
                        http.setParameter("upload", "Upload");
                        http.setParameter("action", "upload");
                        http.setParameter("nextpage", "Upload.jsp?page=" + this.m_page);
                        http.post();
                    }
                    catch (IOException ioex) {
                        ioex.printStackTrace();
                        tryagain = true;
                        uploadProgress.setText("<html><body>" + this.m_own.bundle.getString("uploadBusy") + "<br>" + this.m_own.bundle.getString("uploadRetry") + "</body></html>");
                        Thread.sleep(2000L);
                    }
                    catch (OutOfMemoryError oome) {
                        outOfMemoryNow = true;
                        outOfMemoryFiles = outOfMemoryFiles + filename + "<br>";
                    }
                }
                if (outOfMemoryNow) {
                    outOfMemoryNow = false;
                    continue;
                }
                if (this.uploadedFileSucceeded(filename, lastModified)) {
                    this.m_own.uploadedFile(this.m_uploadFiles[i]);
                    continue;
                }
                ++numFailures;
                failedFile = filename;
            }
            if (numFailures > 0 || outOfMemoryFiles.length() > 0) {
                uploadProgress.setText(null);
                this.m_imagesPanel.repaint();
                this.m_imagesPanel.remove(uploadProgress);
                this.m_imagesPanel.revalidate();
                String overMaxSizeMsg = "";
                String outOfMemoryMsg = "";
                String failureMsg = "";
                if (filesOverMaxSize.length() > 0) {
                    overMaxSizeMsg = this.m_own.bundle.getString("filesOverMaxSize1") + "<br>";
                    overMaxSizeMsg = overMaxSizeMsg + this.m_own.bundle.getString("filesOverMaxSize2") + " ";
                    overMaxSizeMsg = overMaxSizeMsg + this.m_attMaxSize + " " + this.m_own.bundle.getString("filesKb") + "<br>";
                    overMaxSizeMsg = overMaxSizeMsg + filesOverMaxSize;
                }
                if (outOfMemoryFiles.length() > 0) {
                    outOfMemoryMsg = this.m_own.bundle.getString("filesTooLarge") + "<br>";
                    outOfMemoryMsg = outOfMemoryMsg + outOfMemoryFiles;
                    outOfMemoryMsg = outOfMemoryMsg + "<br>";
                    outOfMemoryMsg = outOfMemoryMsg + this.m_own.bundle.getString("useAttachLink");
                }
                if (numFailures == 1) {
                    failureMsg = this.m_own.bundle.getString("uploadFileError") + "<br>" + failedFile;
                } else if (numFailures > 1) {
                    failureMsg = this.m_own.bundle.getString("uploadFilesError");
                }
                String lineBetweenMaxMemMsgs = "";
                String lineBetweenMemFailMsgs = "";
                if (overMaxSizeMsg.length() > 0 && outOfMemoryMsg.length() > 0) {
                    lineBetweenMaxMemMsgs = "<br><br><br>";
                }
                if (outOfMemoryMsg.length() > 0 && failureMsg.length() > 0 || lineBetweenMaxMemMsgs.length() == 0 && overMaxSizeMsg.length() > 0 && failureMsg.length() > 0) {
                    lineBetweenMemFailMsgs = "<br><br><br>";
                }
                String errorMsg = "<html><body>" + overMaxSizeMsg + lineBetweenMaxMemMsgs + outOfMemoryMsg + lineBetweenMemFailMsgs + failureMsg + "</body></html>";
                JOptionPane.showMessageDialog(this.m_own, errorMsg, this.m_own.bundle.getString("uploadErrTitle"), 0);
            } else {
                uploadProgress.setText(this.m_own.bundle.getString("uploadComplete"));
                uploadProgress.setIcon(null);
                Thread.sleep(3000L);
                this.m_imagesPanel.remove(uploadProgress);
                this.m_imagesPanel.revalidate();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean uploadedFileSucceeded(String filename, long oldModifiedTime) {
        URL server = this.makeURL(filename);
        try {
            HttpURLConnection u = (HttpURLConnection)server.openConnection();
            u.connect();
            try {
                int i = u.getResponseCode();
                if (i == 200) {
                    long newModifiedTime = u.getLastModified();
                    return newModifiedTime != oldModifiedTime;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    public URL makeURL(String filename) {
        try {
            String param = URLEncoder.encode(this.m_page + "/" + filename, "UTF-8");
            param = param.replace("+", "%20");
            try {
                return new URL(this.m_uploadURL + "/" + param);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        catch (UnsupportedEncodingException enc) {
            enc.printStackTrace();
        }
        return null;
    }
}

