/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.outlookClasses;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.wikiwizard.outlookClasses.ComponentAddon;
import org.wikiwizard.outlookClasses.MetalLookAndFeelAddons;
import org.wikiwizard.outlookClasses.OS;
import org.wikiwizard.outlookClasses.WindowsClassicLookAndFeelAddons;
import org.wikiwizard.outlookClasses.WindowsLookAndFeelAddons;

public class LookAndFeelAddons {
    private static List contributedComponents = new ArrayList();
    private static LookAndFeelAddons currentAddon;

    public void initialize() {
        Iterator iter = contributedComponents.iterator();
        while (iter.hasNext()) {
            ComponentAddon addon = (ComponentAddon)iter.next();
            addon.initialize(this);
        }
    }

    public void uninitialize() {
        Iterator iter = contributedComponents.iterator();
        while (iter.hasNext()) {
            ComponentAddon addon = (ComponentAddon)iter.next();
            addon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] keysAndValues) {
        int c = keysAndValues.length;
        for (int i = 0; i < c; i += 2) {
            UIManager.put(keysAndValues[i], keysAndValues[i + 1]);
        }
    }

    public void unloadDefaults(Object[] keysAndValues) {
        int c = keysAndValues.length;
        for (int i = 0; i < c; i += 2) {
            UIManager.put(keysAndValues[i], null);
        }
    }

    public static void setAddon(String addonClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(addonClassName));
    }

    public static void setAddon(Class addonClass) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons addon = (LookAndFeelAddons)addonClass.newInstance();
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        addon.initialize();
        currentAddon = addon;
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    public static String getBestMatchAddonClassName() {
        String lnf = UIManager.getLookAndFeel().getClass().getName();
        String addon = UIManager.getCrossPlatformLookAndFeelClassName().equals(lnf) ? MetalLookAndFeelAddons.class.getName() : (UIManager.getSystemLookAndFeelClassName().equals(lnf) ? LookAndFeelAddons.getSystemAddonClassName() : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lnf) ? (OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName()) : ("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(lnf) ? WindowsClassicLookAndFeelAddons.class.getName() : LookAndFeelAddons.getSystemAddonClassName())));
        return addon;
    }

    public static String getSystemAddonClassName() {
        String addon = WindowsClassicLookAndFeelAddons.class.getName();
        if (OS.isMacOSX()) {
            addon = WindowsClassicLookAndFeelAddons.class.getName();
        } else if (OS.isWindows()) {
            addon = OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName();
        }
        return addon;
    }

    public static void contribute(ComponentAddon component) {
        contributedComponents.add(component);
        if (currentAddon != null) {
            component.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon component) {
        contributedComponents.remove(component);
        if (currentAddon != null) {
            component.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent p_Component, Class p_ExpectedUIClass, ComponentUI p_CandidateUI) {
        Class<?> realUIClass;
        if (p_ExpectedUIClass.isInstance(p_CandidateUI)) {
            return p_CandidateUI;
        }
        String realUI = p_CandidateUI.getClass().getName();
        try {
            realUIClass = p_ExpectedUIClass.getClassLoader().loadClass(realUI);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + realUI, e);
        }
        Method createUIMethod = null;
        try {
            createUIMethod = realUIClass.getMethod("createUI", JComponent.class);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException("Class " + realUI + " has no method createUI(JComponent)");
        }
        try {
            return (ComponentUI)createUIMethod.invoke(null, p_Component);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to invoke " + realUI + "#createUI(JComponent)");
        }
    }

    static {
        String addonClassname = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            addonClassname = System.getProperty("swing.addon", addonClassname);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        try {
            LookAndFeelAddons.setAddon(addonClassname);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

