/*
 * Decompiled with CFR 0.152.
 */
package org.wikiwizard.outlookClasses;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.wikiwizard.outlookClasses.BasicOutlookBarUI;
import org.wikiwizard.outlookClasses.ButtonBorder;
import org.wikiwizard.outlookClasses.FourLineBorder;

public class WindowsOutlookBarUI
extends BasicOutlookBarUI {
    private Border tabButtonBorder;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsOutlookBarUI();
    }

    public JScrollPane makeScrollPane(Component component) {
        JScrollPane scroll = super.makeScrollPane(component);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.getVerticalScrollBar().setUI(new ThinScrollBarUI());
        return scroll;
    }

    protected void installDefaults() {
        super.installDefaults();
        this.tabButtonBorder = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
    }

    protected BasicOutlookBarUI.TabButton createTabButton() {
        BasicOutlookBarUI.TabButton button = new BasicOutlookBarUI.TabButton();
        button.setUI(new BasicButtonUI());
        button.setBorder(this.tabButtonBorder);
        return button;
    }

    public static class ThinScrollBarUI
    extends BasicScrollBarUI {
        public Dimension getPreferredSize(JComponent c) {
            return this.scrollbar.getOrientation() == 1 ? new Dimension(8, 48) : new Dimension(48, 8);
        }
    }

    public static class WindowsTabButtonBorder
    extends ButtonBorder {
        FourLineBorder normalBorder;
        FourLineBorder pressedBorder;

        public WindowsTabButtonBorder(Color color1, Color color2) {
            this.normalBorder = new FourLineBorder(color1, color1, color2, color2);
            this.pressedBorder = new FourLineBorder(color2, color2, color1, color1);
        }

        protected void paintNormal(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.normalBorder.paintBorder(b, g, x, y, width, height);
        }

        protected void paintDisabled(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.normalBorder.paintBorder(b, g, x, y, width, height);
        }

        protected void paintRollover(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.normalBorder.paintBorder(b, g, x, y, width, height);
        }

        protected void paintPressed(AbstractButton b, Graphics g, int x, int y, int width, int height) {
            this.pressedBorder.paintBorder(b, g, x, y, width, height);
        }

        public Insets getBorderInsets(Component c) {
            return this.normalBorder.getBorderInsets(c);
        }
    }
}

