/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.integration.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.integration.spring.SpringBean;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.core.NestedRuntimeException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringHelper {
    private static final Log log = Log.getInstance(SpringHelper.class);
    private static Map<Class<?>, Collection<Method>> methodMap = new ConcurrentHashMap();
    private static Map<Class<?>, Collection<Field>> fieldMap = new ConcurrentHashMap();

    public static void injectBeans(Object bean, ActionBeanContext context) {
        SpringHelper.injectBeans(bean, StripesFilter.getConfiguration().getServletContext());
    }

    public static void injectBeans(Object bean, ServletContext ctx) {
        WebApplicationContext ac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)ctx);
        SpringHelper.injectBeans(bean, (ApplicationContext)ac);
    }

    public static void injectBeans(Object bean, ApplicationContext ctx) {
        String name;
        boolean nameSupplied;
        SpringBean springBean;
        for (Method m : SpringHelper.getMethods(bean.getClass())) {
            try {
                springBean = m.getAnnotation(SpringBean.class);
                nameSupplied = !"".equals(springBean.value());
                name = nameSupplied ? springBean.value() : SpringHelper.methodToPropertyName(m);
                Class<?> beanType = m.getParameterTypes()[0];
                Object managedBean = SpringHelper.findSpringBean(ctx, name, beanType, !nameSupplied);
                m.invoke(bean, managedBean);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Exception while trying to lookup and inject a Spring bean into a bean of type " + bean.getClass().getSimpleName() + " using method " + m.toString(), e);
            }
        }
        for (Field f : SpringHelper.getFields(bean.getClass())) {
            try {
                springBean = f.getAnnotation(SpringBean.class);
                nameSupplied = !"".equals(springBean.value());
                name = nameSupplied ? springBean.value() : f.getName();
                Object managedBean = SpringHelper.findSpringBean(ctx, name, f.getType(), !nameSupplied);
                f.set(bean, managedBean);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Exception while trying to lookup and inject a Spring bean into a bean of type " + bean.getClass().getSimpleName() + " using field access on field " + f.toString(), e);
            }
        }
    }

    protected static Collection<Method> getMethods(Class<?> clazz) {
        Collection<Method> methods = methodMap.get(clazz);
        if (methods == null) {
            methods = ReflectUtil.getMethods(clazz);
            Iterator<Method> iterator = methods.iterator();
            while (iterator.hasNext()) {
                Method method = iterator.next();
                if (!method.isAnnotationPresent(SpringBean.class)) {
                    iterator.remove();
                    continue;
                }
                if (!method.isAccessible()) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        throw new StripesRuntimeException("Method " + clazz.getName() + "." + method.getName() + "is marked " + "with @SpringBean and is not public. An attempt to call " + "setAccessible(true) resulted in a SecurityException. Please " + "either make the method public or modify your JVM security " + "policy to allow Stripes to setAccessible(true).", se);
                    }
                }
                if (method.getParameterTypes().length == 1) continue;
                throw new StripesRuntimeException("A method marked with @SpringBean must have exactly one parameter: the bean to be injected. Method [" + method.toGenericString() + "] has " + method.getParameterTypes().length + " parameters.");
            }
            methodMap.put(clazz, methods);
        }
        return methods;
    }

    protected static Collection<Field> getFields(Class<?> clazz) {
        Collection<Field> fields = fieldMap.get(clazz);
        if (fields == null) {
            fields = ReflectUtil.getFields(clazz);
            Iterator<Field> iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field field = iterator.next();
                if (!field.isAnnotationPresent(SpringBean.class)) {
                    iterator.remove();
                    continue;
                }
                if (field.isAccessible()) continue;
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException se) {
                    throw new StripesRuntimeException("Field " + clazz.getName() + "." + field.getName() + "is marked " + "with @SpringBean and is not public. An attempt to call " + "setAccessible(true) resulted in a SecurityException. Please " + "either make the field public, annotate a public setter instead " + "or modify your JVM security policy to allow Stripes to " + "setAccessible(true).", se);
                }
            }
            fieldMap.put(clazz, fields);
        }
        return fields;
    }

    protected static Object findSpringBean(ApplicationContext ctx, String name, Class<?> type, boolean allowFindByType) {
        try {
            Object bean = ctx.getBean(name, type);
            log.debug("Found spring bean with name [", name, "] and type [", bean.getClass().getName(), "]");
            return bean;
        }
        catch (NestedRuntimeException nre) {
            if (!allowFindByType) {
                throw nre;
            }
            String[] beanNames = ctx.getBeanNamesForType(type);
            if (beanNames.length == 0) {
                throw new StripesRuntimeException("Unable to find SpringBean with name [" + name + "] or type [" + type.getName() + "] in the Spring application context.");
            }
            if (beanNames.length > 1) {
                throw new StripesRuntimeException("Unable to find SpringBean with name [" + name + "] or unique bean with type [" + type.getName() + "] in the Spring application context. Found " + beanNames.length + "beans of matching type.");
            }
            log.warn("Found unique SpringBean with type [" + type.getName() + "]. Matching on ", "type is a little risky so watch out!");
            return ctx.getBean(beanNames[0], type);
        }
    }

    protected static String methodToPropertyName(Method m) {
        String name = m.getName();
        if (name.startsWith("set") && name.length() > 3) {
            String ret = name.substring(3, 4).toLowerCase();
            if (name.length() > 4) {
                ret = ret + name.substring(4);
            }
            return ret;
        }
        return name;
    }
}

