/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.expression;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HNumber;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.lib.SessionData;
import java.util.Vector;

public class HComplex
implements HObject,
HNumber {
    final HFraction real;
    final HFraction imag;
    Vector geonextElements = new Vector();

    public HComplex(HFraction hFraction, HFraction hFraction2) {
        this.real = hFraction;
        this.imag = hFraction2;
    }

    public HComplex(HFraction hFraction, HInteger hInteger) {
        this.real = hFraction;
        this.imag = new HFraction(hInteger.bigIntegerValue(), HInteger.B1);
    }

    public HComplex(HInteger hInteger, HFraction hFraction) {
        this.real = new HFraction(hInteger.bigIntegerValue(), HInteger.B1);
        this.imag = hFraction;
    }

    public HComplex(HInteger hInteger, HInteger hInteger2) {
        this.real = new HFraction(hInteger.bigIntegerValue(), HInteger.B1);
        this.imag = new HFraction(hInteger2.bigIntegerValue(), HInteger.B1);
    }

    HComplex(String string, int n, String string2, int n2, String string3, int n3, String string4, int n4) {
        this.real = new HFraction(string, n, string2, n2);
        this.imag = new HFraction(string3, n3, string4, n4);
    }

    HComplex(String string, String string2, String string3, String string4) {
        this.real = new HFraction(string, string2);
        this.imag = new HFraction(string3, string4);
    }

    public HObject abs() {
        if (this.imag.equals(C.C0)) {
            return this.real.abs();
        }
        if (this.real.equals(C.C0)) {
            return this.imag.abs();
        }
        HFraction hFraction = (HFraction)this.real.abs();
        HFraction hFraction2 = (HFraction)this.imag.abs();
        if (hFraction2.less(hFraction)) {
            HFraction hFraction3 = this.imag.divide(this.real);
            hFraction3 = hFraction3.multiply(hFraction3).add(HFraction.F1);
            return C.EV(C.Multiply.f(hFraction, C.Pow.f(hFraction3, C.C1D2)));
        }
        HFraction hFraction4 = this.real.divide(this.imag);
        hFraction4 = hFraction4.multiply(hFraction4).add(HFraction.F1);
        return C.EV(C.Multiply.f(hFraction2, C.Pow.f(hFraction4, C.C1D2)));
    }

    public HComplex add(HComplex hComplex) throws ArithmeticException {
        return new HComplex(this.real.add(hComplex.real), this.imag.add(hComplex.imag));
    }

    public HObject apply(HObject hObject) {
        if (hObject instanceof HSymbol) {
            return C.EV(new HFunction((HSymbol)hObject, this));
        }
        if (hObject instanceof HFunction && ((HFunction)hObject).isPureFunction()) {
            HFunction hFunction = (HFunction)((HFunction)hObject).clone();
            hFunction.add(this);
            return C.EV(hFunction);
        }
        throw new HThrowException(C.HeadFormatError, C.Lambda, hObject);
    }

    public int compSignum() {
        int n = this.real.signum();
        if (n == 0) {
            return this.imag.signum();
        }
        return n;
    }

    public HObject conjugate() {
        return new HComplex(this.real, this.imag.negate());
    }

    public HComplex divide(HComplex hComplex) throws ArithmeticException {
        HFraction hFraction = hComplex.real.multiply(hComplex.real).add(hComplex.imag.multiply(hComplex.imag));
        return new HComplex(this.real.multiply(hComplex.real).add(this.imag.multiply(hComplex.imag)).divide(hFraction), this.imag.multiply(hComplex.real).subtract(this.real.multiply(hComplex.imag)).divide(hFraction));
    }

    public boolean equals(Object object) {
        if (object instanceof HComplex) {
            return this.real.equals(((HComplex)object).real) && this.imag.equals(((HComplex)object).imag);
        }
        return false;
    }

    public HObject evaluate() {
        if (SessionData.getCurrentNumericFlag()) {
            return new HDoubleComplex(this.real.doubleValue(), this.imag.doubleValue());
        }
        if (this.imag.isEqual(HFraction.F0)) {
            if (this.real.denom().isEqual(C.C1)) {
                return this.real.numer();
            }
            return this.real;
        }
        return null;
    }

    public boolean greater(Object object) {
        if (object instanceof HObject) {
            return ((HObject)object).less(this);
        }
        return false;
    }

    public int hashCode() {
        return this.real.hashCode() + this.imag.hashCode();
    }

    public HSymbol head() {
        return C.Complex;
    }

    public final int hierarchy() {
        return 16;
    }

    public HObject im() {
        return this.imag;
    }

    public boolean isEqual(HComplex hComplex) {
        return this.real.equals(hComplex.real) && this.imag.equals(hComplex.imag);
    }

    public boolean isHeadMember(HSymbol hSymbol) {
        return C.Complex.equals(hSymbol);
    }

    public boolean isList() {
        return false;
    }

    public boolean isMember(HObject hObject) {
        return this.equals(hObject);
    }

    public boolean isNonZero() {
        return !this.isZero();
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isRational() {
        return false;
    }

    public boolean isUnequal(HComplex hComplex) {
        return !this.isEqual(hComplex);
    }

    public boolean isZero() {
        return this.real.equals(C.C0) && this.imag.equals(C.C0);
    }

    public boolean less(Object object) {
        if (object instanceof HComplex) {
            if (this.real.equals(((HComplex)object).real)) {
                return this.imag.less(((HComplex)object).imag);
            }
            return this.real.less(((HComplex)object).real) && this.imag.less(((HComplex)object).imag);
        }
        if (object instanceof HObject) {
            return this.hierarchy() < ((HObject)object).hierarchy();
        }
        return false;
    }

    public boolean matches(HObject hObject) {
        return this.equals(hObject);
    }

    public HComplex multiply(HComplex hComplex) {
        return new HComplex(this.real.multiply(hComplex.real).subtract(this.imag.multiply(hComplex.imag)), this.real.multiply(hComplex.imag).add(hComplex.real.multiply(this.imag)));
    }

    public HComplex negate() {
        return new HComplex(this.real.negate(), this.imag.negate());
    }

    public HComplex pow(int n) throws ArithmeticException {
        int n2 = n;
        if (n == 0 && this.real.isEqual(HFraction.F0) && this.imag.isEqual(HFraction.F0)) {
            throw new ArithmeticException();
        }
        HComplex hComplex = new HComplex(HFraction.F1, HFraction.F0);
        if (n < 0) {
            n2 *= -1;
        }
        for (int i = 0; i < n2; ++i) {
            hComplex = hComplex.multiply(this);
        }
        if (n < 0) {
            HFraction hFraction = hComplex.real.multiply(hComplex.real).add(hComplex.imag.multiply(hComplex.imag));
            return new HComplex(hComplex.real.divide(hFraction), hComplex.imag.negate().divide(hFraction));
        }
        return hComplex;
    }

    public int precedence() {
        if (this.real.equals(C.C0)) {
            if (this.imag.equals(C.C1)) {
                return 999999;
            }
            return 200;
        }
        if (this.real.less(C.C0)) {
            return 99;
        }
        return 100;
    }

    public HObject re() {
        return this.real;
    }

    public HObject substitute(HObject hObject, HObject hObject2) {
        if (this.equals(hObject)) {
            return hObject2;
        }
        return this;
    }

    public HObject substitutePattern() {
        return this;
    }

    public HComplex subtract(HComplex hComplex) {
        return new HComplex(this.real.subtract(hComplex.real), this.imag.subtract(hComplex.imag));
    }

    public String toString() {
        if (this.real.equals(C.C0)) {
            if (this.imag.equals(C.C1)) {
                return "I";
            }
            if (this.imag.equals(C.CN1)) {
                return "-I";
            }
            return this.imag.toString() + "*I";
        }
        if (this.imag.equals(C.C1)) {
            return this.real.toString() + "+I";
        }
        if (this.imag.equals(C.CN1)) {
            return this.real.toString() + "-I";
        }
        if (this.imag.isNegative()) {
            return this.real.toString() + this.imag.toString() + "*I";
        }
        return this.real.toString() + "+" + this.imag.toString() + "*I";
    }

    public void toStringBuffer(StringBuffer stringBuffer) {
        stringBuffer.append(this.toString());
    }

    public boolean unequals(Object object) {
        return !this.equals(object);
    }
}

