/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HComplex;
import com.hartmath.expression.HDouble;
import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HPattern;
import com.hartmath.expression.HString;
import com.hartmath.expression.HSymbol;
import com.hartmath.lib.C;
import com.hartmath.loadable.MMLOperator;
import com.hartmath.mapping.E1Arg;
import java.util.Hashtable;

public class EMML
extends E1Arg {
    public static Hashtable greekSym = new Hashtable(199);
    public static Hashtable operTab = new Hashtable(199);

    public static void convert(StringBuffer stringBuffer, HObject hObject) {
        int n = hObject.hierarchy();
        switch (n) {
            case 1: {
                EMML.convertDouble(stringBuffer, (HDouble)hObject);
                break;
            }
            case 2: {
                EMML.convertDoubleComplex(stringBuffer, (HDoubleComplex)hObject);
                break;
            }
            case 4: {
                EMML.convertInteger(stringBuffer, (HInteger)hObject);
                break;
            }
            case 8: {
                EMML.convertFraction(stringBuffer, (HFraction)hObject);
                break;
            }
            case 16: {
                EMML.convertComplex(stringBuffer, (HComplex)hObject);
                break;
            }
            case 32: {
                EMML.convertString(stringBuffer, (HString)hObject);
                break;
            }
            case 64: {
                EMML.convertSymbol(stringBuffer, (HSymbol)hObject);
                break;
            }
            case 256: {
                EMML.convertPattern(stringBuffer, (HPattern)hObject);
                break;
            }
            case 128: {
                HFunction hFunction = (HFunction)hObject;
                MMLOperator mMLOperator = (MMLOperator)operTab.get(hFunction.head());
                if (mMLOperator != null) {
                    mMLOperator.convert(stringBuffer, hFunction);
                    break;
                }
                stringBuffer.append(" <mrow>");
                EMML.convertHead(stringBuffer, hFunction.head());
                stringBuffer.append("   <mrow>");
                stringBuffer.append("     <mo> ( </mo>\n");
                for (int i = 0; i < hFunction.size(); ++i) {
                    EMML.convert(stringBuffer, hFunction.get(i));
                    if (i >= hFunction.size() - 1) continue;
                    stringBuffer.append("     <mo> , </mo>\n");
                }
                stringBuffer.append("     <mo> ) </mo>\n");
                stringBuffer.append("   </mrow>\n");
                stringBuffer.append(" </mrow>\n");
                break;
            }
            default: {
                stringBuffer.append(hObject.toString());
            }
        }
    }

    public static void convertComplex(StringBuffer stringBuffer, HComplex hComplex) {
        stringBuffer.append("  <mrow>");
        stringBuffer.append(hComplex.re().toString());
        stringBuffer.append("     <mo> + </mo>\n");
        stringBuffer.append("     <mrow>\n");
        stringBuffer.append(hComplex.im().toString());
        stringBuffer.append("     <mo> &InvisibleTimes; </mo>\n");
        stringBuffer.append("     <mi> &ImaginrayI; </mi>\n");
        stringBuffer.append("     </mrow>\n");
        stringBuffer.append("  </mrow>\n");
    }

    public static void convertDouble(StringBuffer stringBuffer, HDouble hDouble) {
        stringBuffer.append("  <mn>");
        stringBuffer.append(hDouble.toString());
        stringBuffer.append("</mn>\n");
    }

    public static void convertDoubleComplex(StringBuffer stringBuffer, HDoubleComplex hDoubleComplex) {
        stringBuffer.append("  <mrow>");
        stringBuffer.append(String.valueOf(hDoubleComplex.real()));
        stringBuffer.append("     <mo> + </mo>\n");
        stringBuffer.append("     <mrow>\n");
        stringBuffer.append(String.valueOf(hDoubleComplex.imag()));
        stringBuffer.append("     <mo> &InvisibleTimes; </mo>\n");
        stringBuffer.append("     <mi> &ImaginrayI; </mi>\n");
        stringBuffer.append("     </mrow>\n");
        stringBuffer.append("  </mrow>\n");
    }

    public static void convertFraction(StringBuffer stringBuffer, HFraction hFraction) {
        stringBuffer.append("  <mfrac> <mn>");
        stringBuffer.append(hFraction.numer().toString());
        stringBuffer.append("<mn/> <mn>");
        stringBuffer.append(hFraction.denom().toString());
        stringBuffer.append("</mn> <mfrac>\n");
    }

    public static void convertHead(StringBuffer stringBuffer, HSymbol hSymbol) {
        HObject hObject = (HObject)greekSym.get(hSymbol.toString());
        stringBuffer.append("  <mi>");
        if (hObject == C.True) {
            stringBuffer.append("&");
        }
        stringBuffer.append(hSymbol.toString());
        stringBuffer.append("</mi>\n");
        stringBuffer.append("  <mo> &ApplyFunction; </mo>\n");
    }

    public static void convertInteger(StringBuffer stringBuffer, HInteger hInteger) {
        stringBuffer.append("  <mn>");
        stringBuffer.append(hInteger.toString());
        stringBuffer.append("</mn>\n");
    }

    public static void convertPattern(StringBuffer stringBuffer, HPattern hPattern) {
        stringBuffer.append("  <mi>");
        stringBuffer.append(hPattern.toString());
        stringBuffer.append("</mi>\n");
    }

    public static void convertString(StringBuffer stringBuffer, HString hString) {
        stringBuffer.append("  <mtext>");
        stringBuffer.append(hString.toString());
        stringBuffer.append("</mtext>\n");
    }

    public static void convertSymbol(StringBuffer stringBuffer, HSymbol hSymbol) {
        HObject hObject = (HObject)greekSym.get(hSymbol.toString());
        stringBuffer.append("  <mi>");
        if (hObject == C.True) {
            stringBuffer.append("&");
        }
        stringBuffer.append(hSymbol.toString());
        stringBuffer.append("</mi>\n");
    }

    public HObject e1ObjArg(HObject hObject) {
        StringBuffer stringBuffer = new StringBuffer("<math>\n");
        EMML.convert(stringBuffer, hObject);
        stringBuffer.append("</math>\n");
        return new HString(stringBuffer);
    }

    static {
        operTab.put(C.Add, new MMLOperator("   <mrow>\n", "+", "   </mrow>\n"));
        operTab.put(C.Multiply, new MMLOperator("   <mrow>\n", "&InvisibleTimes;", "   </mrow>\n"));
        operTab.put(C.Pow, new MMLOperator("   <msup>\n", "", "   </msup>\n"));
        greekSym.put("Alpha", C.True);
        greekSym.put("Beta", C.True);
        greekSym.put("Chi", C.True);
        greekSym.put("Delta", C.True);
        greekSym.put("Epsilon", C.True);
        greekSym.put("Phi", C.True);
        greekSym.put("Gamma", C.True);
        greekSym.put("Eta", C.True);
        greekSym.put("Iota", C.True);
        greekSym.put("varTheta", C.True);
        greekSym.put("Kappa", C.True);
        greekSym.put("Lambda", C.True);
        greekSym.put("Mu", C.True);
        greekSym.put("Nu", C.True);
        greekSym.put("Omicron", C.True);
        greekSym.put("Pi", C.True);
        greekSym.put("Theta", C.True);
        greekSym.put("Rho", C.True);
        greekSym.put("Sigma", C.True);
        greekSym.put("Tau", C.True);
        greekSym.put("Upsilon", C.True);
        greekSym.put("Omega", C.True);
        greekSym.put("Xi", C.True);
        greekSym.put("Psi", C.True);
        greekSym.put("Zeta", C.True);
        greekSym.put("alpha", C.True);
        greekSym.put("beta", C.True);
        greekSym.put("chi", C.True);
        greekSym.put("selta", C.True);
        greekSym.put("epsilon", C.True);
        greekSym.put("phi", C.True);
        greekSym.put("gamma", C.True);
        greekSym.put("eta", C.True);
        greekSym.put("iota", C.True);
        greekSym.put("varphi", C.True);
        greekSym.put("kappa", C.True);
        greekSym.put("lambda", C.True);
        greekSym.put("mu", C.True);
        greekSym.put("nu", C.True);
        greekSym.put("omicron", C.True);
        greekSym.put("pi", C.True);
        greekSym.put("theta", C.True);
        greekSym.put("rho", C.True);
        greekSym.put("sigma", C.True);
        greekSym.put("tau", C.True);
        greekSym.put("upsilon", C.True);
        greekSym.put("varomega", C.True);
        greekSym.put("omega", C.True);
        greekSym.put("xi", C.True);
        greekSym.put("psi", C.True);
        greekSym.put("zeta", C.True);
    }
}

