/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.loadable;

import com.hartmath.expression.HFraction;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HInteger;
import com.hartmath.expression.HObject;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.FunctionEvaluator;
import java.math.BigInteger;

public class EToBase
implements FunctionEvaluator {
    private static final char[] charMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static String convert(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = bigInteger2.intValue();
        boolean bl = false;
        if (n < 2 || n > charMap.length) {
            throw new HThrowException(C.ToBase, C.Error, new HString("invalid base: " + bigInteger2 + ", must be between 2 and " + (charMap.length + 1)));
        }
        try {
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer(64);
            if (bigInteger.compareTo(HInteger.B0) == -1) {
                bigInteger = bigInteger.multiply(HInteger.BN1);
                bl = true;
            }
            while (bigInteger.compareTo(HInteger.B0) == 1) {
                BigInteger bigInteger3 = bigInteger.mod(bigInteger2);
                n2 = bigInteger3.intValue();
                bigInteger = bigInteger.subtract(bigInteger3).divide(bigInteger2);
                stringBuffer.append(charMap[n2]);
            }
            if (bl) {
                return "-" + stringBuffer.reverse().toString() + "^^" + bigInteger2.toString();
            }
            return stringBuffer.reverse().toString() + "^^" + bigInteger2.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public HObject evaluate(HFunction hFunction) {
        if (hFunction.size() == 2 && hFunction.get(1) instanceof HInteger) {
            if (hFunction.get(0) instanceof HInteger) {
                return new HString(EToBase.convert(((HInteger)hFunction.get(0)).bigIntegerValue(), ((HInteger)hFunction.get(1)).bigIntegerValue()));
            }
            if (hFunction.get(0) instanceof HFraction) {
                String string = EToBase.convert(((HFraction)hFunction.get(0)).numer().bigIntegerValue(), ((HInteger)hFunction.get(1)).bigIntegerValue());
                String string2 = EToBase.convert(((HFraction)hFunction.get(0)).denom().bigIntegerValue(), ((HInteger)hFunction.get(1)).bigIntegerValue());
                return new HString(string + "/" + string2);
            }
        }
        return null;
    }
}

