/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.expression.HDoubleComplex;
import com.hartmath.expression.HFunction;
import com.hartmath.expression.HString;
import com.hartmath.lib.C;
import com.hartmath.lib.HThrowException;
import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.ComplexVector;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.Matrix;

public class ComplexMatrix
extends Matrix {
    protected HDoubleComplex[][] matrix;

    protected ComplexMatrix() {
    }

    public ComplexMatrix(HDoubleComplex[][] hDoubleComplexArray) {
        this.matrix = hDoubleComplexArray;
    }

    public ComplexMatrix(ComplexVector[] complexVectorArray) {
        this(complexVectorArray.length, complexVectorArray[0].dimension());
        for (int i = 0; i < this.matrix[0].length; ++i) {
            for (int j = 0; j < this.matrix.length; ++j) {
                this.matrix[i][j] = complexVectorArray[j].getComponent(i);
            }
        }
    }

    public ComplexMatrix(int n, int n2) {
        this.matrix = new HDoubleComplex[n][n2];
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].add(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].add(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("Matrices have different sizes."));
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public ComplexMatrix conjugate() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = this.matrix[i][0].conj();
            for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                hDoubleComplexArray[i][j] = this.matrix[i][j].conj();
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexMatrix && this.matrix.length == ((ComplexMatrix)object).rows() && this.matrix[0].length == ((ComplexMatrix)object).columns()) {
            ComplexMatrix complexMatrix = (ComplexMatrix)object;
            for (int i = 0; i < this.matrix.length; ++i) {
                for (int j = 0; j < this.matrix[0].length; ++j) {
                    if (this.matrix[i][j].equals(complexMatrix.getElement(i, j))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected void finalize() throws Throwable {
        this.matrix = null;
        super.finalize();
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                d += this.matrix[i][j].mod() * this.matrix[i][j].mod();
            }
        }
        return Math.sqrt(d);
    }

    public HDoubleComplex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            return this.matrix[n][n2];
        }
        throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid element."));
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public ComplexMatrix hermitianAdjoint() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[0][i] = this.matrix[i][0].conj();
            for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                hDoubleComplexArray[j][i] = this.matrix[i][j].conj();
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public DoubleMatrix imag() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                dArray[i][j] = this.matrix[i][j].imag();
            }
        }
        return new DoubleMatrix(dArray);
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.length; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.matrix[0].length; ++j) {
                d2 += this.matrix[i][j].mod();
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public ComplexMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = hUnaryNumerical.map(this.matrix[i][0]);
            for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                hDoubleComplexArray[i][j] = hUnaryNumerical.map(this.matrix[i][j]);
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][complexMatrix.columns()];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                for (int j = 0; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][0].multiply(complexMatrix.getElement(0, j));
                    for (int k = 1; k < this.matrix[0].length; ++k) {
                        hDoubleComplexArray[i][j] = hDoubleComplexArray[i][j].add(this.matrix[i][k].multiply(complexMatrix.getElement(k, j)));
                    }
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Multiply, new HString("Incompatible matrices."));
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix[0].length == complexVector.dimension()) {
            HDoubleComplex[] hDoubleComplexArray = new HDoubleComplex[this.matrix.length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i] = this.matrix[i][0].multiply(complexVector.getComponent(0));
                for (int j = 1; j < this.matrix[0].length; ++j) {
                    hDoubleComplexArray[i] = hDoubleComplexArray[i].add(this.matrix[i][j].multiply(complexVector.getComponent(j)));
                }
            }
            return new ComplexVector(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Add, new HString("Matrix and vector are incompatible."));
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public DoubleMatrix real() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                dArray[i][j] = this.matrix[i][j].real();
            }
        }
        return new DoubleMatrix(dArray);
    }

    public int rows() {
        return this.matrix.length;
    }

    public ComplexMatrix scalarMultiply(double d) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = this.matrix[i][0].multiply(d);
            for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                hDoubleComplexArray[i][j] = this.matrix[i][j].multiply(d);
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public ComplexMatrix scalarMultiply(HDoubleComplex hDoubleComplex) {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
        for (int i = 0; i < hDoubleComplexArray.length; ++i) {
            hDoubleComplexArray[i][0] = hDoubleComplex.multiply(this.matrix[i][0]);
            for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                hDoubleComplexArray[i][j] = hDoubleComplex.multiply(this.matrix[i][j]);
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }

    public void setElement(int n, int n2, HDoubleComplex hDoubleComplex) {
        if (n < 0 || n >= this.matrix.length || n2 < 0 || n2 >= this.matrix[0].length) {
            throw new HThrowException(C.OutOfRangeError, C.List, new HString("Invalid element."));
        }
        this.matrix[n][n2] = hDoubleComplex;
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix.length][this.matrix[0].length];
            for (int i = 0; i < hDoubleComplexArray.length; ++i) {
                hDoubleComplexArray[i][0] = this.matrix[i][0].subtract(complexMatrix.getElement(i, 0));
                for (int j = 1; j < hDoubleComplexArray[0].length; ++j) {
                    hDoubleComplexArray[i][j] = this.matrix[i][j].subtract(complexMatrix.getElement(i, j));
                }
            }
            return new ComplexMatrix(hDoubleComplexArray);
        }
        throw new HThrowException(C.OutOfRangeError, C.Subtract, new HString("Matrices have different sizes."));
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public HFunction toFunction() {
        HFunction hFunction = new HFunction(C.List);
        hFunction.setProperties(256);
        for (int i = 0; i < this.matrix.length; ++i) {
            hFunction.add(new HFunction(C.List, this.matrix[i]));
        }
        return hFunction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[0].length);
        for (int i = 0; i < this.matrix.length; ++i) {
            for (int j = 0; j < this.matrix[0].length; ++j) {
                stringBuffer.append(this.matrix[i][j].toString());
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public Matrix transpose() {
        HDoubleComplex[][] hDoubleComplexArray = new HDoubleComplex[this.matrix[0].length][this.matrix.length];
        for (int i = 0; i < hDoubleComplexArray[0].length; ++i) {
            hDoubleComplexArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < hDoubleComplexArray.length; ++j) {
                hDoubleComplexArray[j][i] = this.matrix[i][j];
            }
        }
        return new ComplexMatrix(hDoubleComplexArray);
    }
}

