/*
 * Decompiled with CFR 0.152.
 */
package com.hartmath.util;

import com.hartmath.mapping.HUnaryNumerical;
import com.hartmath.util.DimensionException;
import com.hartmath.util.DoubleDiagonalMatrix;
import com.hartmath.util.DoubleMatrix;
import com.hartmath.util.DoubleVector;
import com.hartmath.util.Matrix;
import com.hartmath.util.MatrixDimensionException;

public class DoubleSquareMatrix
extends DoubleMatrix {
    protected DoubleSquareMatrix() {
    }

    public DoubleSquareMatrix(double[][] dArray) {
        super(dArray);
        if (dArray.length != dArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public DoubleSquareMatrix(DoubleVector[] doubleVectorArray) {
        super(doubleVectorArray);
        if (doubleVectorArray.length != doubleVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public DoubleSquareMatrix(int n) {
        super(n, n);
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawAdd(doubleMatrix);
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] + doubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[i][j] + doubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix add(Matrix matrix) {
        if (matrix instanceof DoubleSquareMatrix) {
            return this.add((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawAdd((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double[][][] dArray = new double[2][this.matrix.length][this.matrix.length];
        double d = Math.sqrt(this.matrix[0][0]);
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        for (n = 1; n < this.matrix.length; ++n) {
            double d2 = this.matrix[n][0] / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
        }
        for (int i = 1; i < this.matrix.length; ++i) {
            double d3 = this.matrix[i][i];
            for (n = 0; n < i; ++n) {
                d3 -= dArray[0][i][n] * dArray[0][i][n];
            }
            double d4 = Math.sqrt(d3);
            dArray[1][i][i] = d4;
            dArray[0][i][i] = d4;
            for (n = i + 1; n < this.matrix.length; ++n) {
                d3 = this.matrix[n][i];
                for (int j = 0; j < n; ++j) {
                    d3 -= dArray[0][i][j] * dArray[1][j][n];
                }
                double d5 = d3 / dArray[1][i][i];
                dArray[1][i][n] = d5;
                dArray[0][n][i] = d5;
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public double det() {
        if (this.matrix.length == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose();
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        for (int i = 1; i < this.matrix.length; ++i) {
            d *= doubleSquareMatrixArray[1].matrix[i][i];
        }
        return d;
    }

    public DoubleSquareMatrix inverse() {
        int n;
        double[][][] dArray = new double[2][this.matrix.length][this.matrix.length];
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose();
        dArray[0][0][0] = 1.0 / doubleSquareMatrixArray[0].matrix[0][0];
        dArray[1][0][0] = 1.0 / doubleSquareMatrixArray[1].matrix[0][0];
        for (n = 1; n < this.matrix.length; ++n) {
            dArray[0][n][n] = 1.0 / doubleSquareMatrixArray[0].matrix[n][n];
            dArray[1][n][n] = 1.0 / doubleSquareMatrixArray[1].matrix[n][n];
        }
        for (n = 0; n < this.matrix.length - 1; ++n) {
            for (int i = n + 1; i < this.matrix.length; ++i) {
                double d = 0.0;
                double d2 = 0.0;
                for (int j = n; j < i; ++j) {
                    d2 -= doubleSquareMatrixArray[0].matrix[i][j] * dArray[0][j][n];
                    d -= dArray[1][n][j] * doubleSquareMatrixArray[1].matrix[j][i];
                }
                dArray[0][i][n] = d2 / doubleSquareMatrixArray[0].matrix[i][i];
                dArray[1][n][i] = d / doubleSquareMatrixArray[1].matrix[i][i];
            }
        }
        return new DoubleSquareMatrix(dArray[1]).multiply(new DoubleSquareMatrix(dArray[0]));
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(DoubleDiagonalMatrix.identity(this.matrix[0].length));
    }

    public DoubleSquareMatrix[] luDecompose() {
        int n;
        double[][][] dArray = new double[2][this.matrix.length][this.matrix.length];
        dArray[0][0][0] = 1.0;
        for (n = 1; n < this.matrix.length; ++n) {
            dArray[0][n][n] = 1.0;
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            int n2;
            double d;
            for (n = 0; n <= i; ++n) {
                d = this.matrix[n][i];
                for (n2 = 0; n2 < n; ++n2) {
                    d -= dArray[0][n][n2] * dArray[1][n2][i];
                }
                dArray[1][n][i] = d;
            }
            for (n = i + 1; n < this.matrix.length; ++n) {
                d = this.matrix[n][i];
                for (n2 = 0; n2 < i; ++n2) {
                    d -= dArray[0][n][n2] * dArray[1][n2][i];
                }
                dArray[0][n][i] = d / dArray[1][i][i];
            }
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(HUnaryNumerical hUnaryNumerical) {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = hUnaryNumerical.map(this.matrix[i][0]);
            for (int j = 1; j < dArray.length; ++j) {
                dArray[i][j] = hUnaryNumerical.map(this.matrix[i][j]);
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawMultiply(doubleMatrix);
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[i][0] * doubleSquareMatrix.getElement(0, j);
                    for (int k = 1; k < dArray.length; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.matrix[i][k] * doubleSquareMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix.length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.matrix[i][0] * doubleVector.getComponent(0);
                for (int j = 1; j < this.matrix.length; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.matrix[i][j] * doubleVector.getComponent(j);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof DoubleSquareMatrix) {
            return this.multiply((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawMultiply((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.rows() && this.matrix.length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] + doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[i][j] + doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][doubleMatrix.columns()];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray[0].length; ++j) {
                    dArray[i][j] = this.matrix[i][0] * doubleMatrix.getElement(0, j);
                    for (int k = 1; k < this.matrix[0].length; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.matrix[i][k] * doubleMatrix.getElement(k, j);
                    }
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.rows() && this.matrix.length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] - doubleMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[i][j] - doubleMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i][0] = d * this.matrix[i][0];
            for (int j = 1; j < dArray.length; ++j) {
                dArray[i][j] = d * this.matrix[i][j];
            }
        }
        return new DoubleSquareMatrix(dArray);
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        if (doubleMatrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)doubleMatrix);
        }
        return this.rawSubtract(doubleMatrix);
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix.length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][this.matrix.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i][0] = this.matrix[i][0] - doubleSquareMatrix.getElement(i, 0);
                for (int j = 1; j < dArray.length; ++j) {
                    dArray[i][j] = this.matrix[i][j] - doubleSquareMatrix.getElement(i, j);
                }
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof DoubleSquareMatrix) {
            return this.subtract((DoubleSquareMatrix)matrix);
        }
        if (matrix instanceof DoubleMatrix) {
            return this.rawSubtract((DoubleMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public double trace() {
        double d = this.matrix[0][0];
        for (int i = 1; i < this.matrix.length; ++i) {
            d += this.matrix[i][i];
        }
        return d;
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrix.length][this.matrix.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < dArray.length; ++j) {
                dArray[j][i] = this.matrix[i][j];
            }
        }
        return new DoubleSquareMatrix(dArray);
    }
}

