/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Element;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JContentColorChooser
extends JContentPanel
implements ActionListener,
ChangeListener,
ListSelectionListener,
ItemListener {
    public JButton backView;
    public Color actColor = Color.green;
    public static final int STROKE = 0;
    public static final int FILL = 1;
    public static final int LABEL = 2;
    public JTextField redField;
    public JTextField greenField;
    public int type;
    public Color[][] col = new Color[][]{{Color.black, Color.gray, Color.lightGray, Color.white}, {new Color(0, 128, 192), Color.blue, Color.cyan, Color.yellow}, {Color.pink, Color.magenta, Color.red, new Color(255, 150, 0)}, {new Color(128, 0, 0), new Color(0, 128, 64), new Color(185, 219, 125), new Color(0, 0, 0, 0)}};
    public JSlider slider;
    public JTextField blueField;
    public JButton[][] backColor;
    public Vector elements;
    public JBoardPane board;

    public JContentColorChooser() {
    }

    public JContentColorChooser(Color color, Color color2, int n, JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.type = n;
        this.actColor = color2;
        this.backView = new JButton((Icon)new ImageIcon(this.getClass().getResource("gni.gif"))){

            public void paint(Graphics graphics) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                super.paint(graphics);
                if (this.getForeground().getAlpha() != 0) {
                    graphics.setColor(this.getForeground());
                    graphics.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                } else {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                    graphics.setColor(Color.black);
                    graphics.drawLine(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                    graphics.drawLine(2, this.getHeight() - 4, this.getWidth() - 4, 2);
                }
            }
        };
        this.backView.setBackground(color);
        this.backView.setForeground(this.actColor);
        this.redField = new JTextField(3);
        this.redField.addActionListener(this);
        this.redField.setActionCommand("rgb");
        this.redField.setFont(new Font(this.redField.getFont().getName(), 0, this.redField.getFont().getSize() - 2));
        this.greenField = new JTextField(3);
        this.greenField.addActionListener(this);
        this.greenField.setActionCommand("rgb");
        this.greenField.setFont(new Font(this.redField.getFont().getName(), 0, this.greenField.getFont().getSize() - 2));
        this.blueField = new JTextField(3);
        this.blueField.addActionListener(this);
        this.blueField.setActionCommand("rgb");
        this.blueField.setFont(new Font(this.redField.getFont().getName(), 0, this.blueField.getFont().getSize() - 2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel.add(new JLabel(Geonext.language.getString("color_red")));
        jPanel.add(new JLabel(Geonext.language.getString("color_green")));
        jPanel.add(new JLabel(Geonext.language.getString("color_blue")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel2.add(this.redField);
        jPanel2.add(this.greenField);
        jPanel2.add(this.blueField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("Center", jPanel);
        jPanel3.add("East", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(4, 4, 2, 2));
        jPanel4.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.backColor = new JButton[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.backColor[i][j] = new JButton();
                this.backColor[i][j].setPreferredSize(new Dimension(15, 15));
                this.backColor[i][j].setActionCommand(i + "" + j + "background");
                this.backColor[i][j].addActionListener(this);
                this.backColor[i][j].setBackground(this.col[i][j]);
                jPanel4.add(this.backColor[i][j]);
            }
        }
        jPanel4.remove(this.backColor[3][3]);
        this.backColor[3][3] = new JButton(){

            public void paint(Graphics graphics) {
                super.paint(graphics);
                graphics.drawLine(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                graphics.drawLine(2, this.getHeight() - 4, this.getWidth() - 4, 2);
            }
        };
        this.backColor[3][3].setPreferredSize(new Dimension(15, 15));
        this.backColor[3][3].setActionCommand("33background");
        this.backColor[3][3].addActionListener(this);
        this.backColor[3][3].setBackground(Color.white);
        jPanel4.add(this.backColor[3][3]);
        this.slider = new JSlider(0, 0, 100, 0);
        this.slider.addChangeListener(this);
        this.slider.setMajorTickSpacing(25);
        this.slider.setMinorTickSpacing(5);
        this.slider.setSnapToTicks(true);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel5.add(new JLabel(Geonext.language.getString("color_transperency")));
        jPanel5.add(new JLabel(""));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.add("West", jPanel5);
        jPanel6.add("Center", this.slider);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(5, 5));
        jPanel7.add("Center", new JPanel());
        jPanel7.add("South", jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(5, 0));
        jPanel8.add("West", jPanel4);
        jPanel8.add("Center", this.backView);
        jPanel8.add("East", jPanel3);
        jPanel8.add("South", jPanel7);
        this.setLayout(new BorderLayout(0, 0));
        this.add("North", jPanel8);
        this.add("Center", new JPanel());
        this.setDisplay();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.endsWith("rgb")) {
            this.setActColor();
            this.setDisplay();
            this.setColor();
        } else if (string.endsWith("background")) {
            if (string.equals("33background")) {
                this.actColor = new Color(this.actColor.getRed(), this.actColor.getGreen(), this.actColor.getBlue(), 0);
            } else {
                this.setDefinedColor(Integer.parseInt(string.substring(0, 1)), Integer.parseInt(string.substring(1, 2)));
            }
            this.setDisplay();
            this.setColor();
        }
        this.board.repaint();
    }

    public void getColor() {
        try {
            switch (this.type) {
                case 0: {
                    this.actColor = ((Element)this.elements.get(0)).getStroke();
                    break;
                }
                case 1: {
                    this.actColor = ((Element)this.elements.get(0)).getFill();
                    break;
                }
                case 2: {
                    this.actColor = ((Element)this.elements.get(0)).getLabel();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDisplay();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void setActColor() {
        try {
            this.actColor = new Color(Integer.parseInt(this.redField.getText()), Integer.parseInt(this.greenField.getText()), Integer.parseInt(this.blueField.getText()), (int)Math.abs(Math.round(255.0 - 2.55 * (double)this.slider.getValue())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor() {
        try {
            switch (this.type) {
                case 0: {
                    for (int i = 0; i < this.elements.size(); ++i) {
                        ((Element)this.elements.get(i)).setStroke(this.actColor);
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < this.elements.size(); ++i) {
                        ((Element)this.elements.get(i)).setFill(this.actColor);
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.elements.size(); ++i) {
                        ((Element)this.elements.get(i)).setLabel(this.actColor);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDefinedColor(int n, int n2) {
        this.actColor = this.col[n][n2];
        if (this.type == 1 && n * n2 != 9) {
            this.actColor = new Color(this.actColor.getRed(), this.actColor.getGreen(), this.actColor.getBlue(), 63);
        }
    }

    public void setDisplay() {
        this.redField.setText("" + this.actColor.getRed());
        this.greenField.setText("" + this.actColor.getGreen());
        this.blueField.setText("" + this.actColor.getBlue());
        this.slider.removeChangeListener(this);
        this.slider.setValue(100 - (int)((double)this.actColor.getAlpha() / 255.0 * 100.0));
        this.slider.addChangeListener(this);
        this.backView.setForeground(this.actColor);
    }

    public void setElements(Vector vector) {
        this.elements = vector;
        if (this.elements != null || this.elements.size() > 0) {
            this.getColor();
        }
        this.setDisplay();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = (int)Math.abs(Math.round(255.0 - 2.55 * (double)this.slider.getValue()));
        this.backView.setForeground(new Color(Integer.parseInt(this.redField.getText()), Integer.parseInt(this.greenField.getText()), Integer.parseInt(this.blueField.getText()), (int)Math.abs(Math.round(255.0 - 2.55 * (double)this.slider.getValue()))));
        if (!jSlider.getValueIsAdjusting()) {
            this.setActColor();
            this.setColor();
        }
        this.board.repaint();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void setBackView(Color color) {
        this.backView.setBackground(color);
        this.backView.setForeground(this.actColor);
    }
}

