/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JContentCoord
extends JContentPanel
implements ActionListener,
ChangeListener {
    public JBoardPane board;
    public JTextField pixelXField;
    public JTextField termXField;
    public JTextField labelXField;
    public JTextField multiXField;
    public javax.swing.JCheckBox unitXBox;
    public javax.swing.JCheckBox contXBox;
    public javax.swing.JCheckBox multiXBox;
    public JTextField pixelYField;
    public JTextField termYField;
    public JTextField labelYField;
    public JTextField multiYField;
    public javax.swing.JCheckBox unitYBox;
    public javax.swing.JCheckBox contYBox;
    public javax.swing.JCheckBox multiYBox;
    public javax.swing.JCheckBox objectYBox;
    public javax.swing.JCheckBox objectXBox;

    public JContentCoord() {
    }

    public JContentCoord(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel.add(this.xPanel());
        jPanel.add(this.yPanel());
        this.reset();
        this.add("Center", jPanel);
        this.validateTree();
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.board.setSaved(false);
            this.setCoord();
        } else if (string.equals("apply")) {
            this.board.setSaved(false);
            this.setCoord();
            this.reset();
        } else if (string.equals("cancel")) {
            // empty if block
        }
        this.board.repaint();
    }

    public void displayMultiFields() {
        if (this.multiXBox.isSelected()) {
            this.multiXField.setEditable(true);
            this.multiXField.setEnabled(true);
            this.multiXField.setBorder(new JTextField().getBorder());
        } else {
            this.multiXField.setEditable(false);
            this.multiXField.setEnabled(false);
            this.multiXField.setBorder(new EtchedBorder(1));
        }
        if (this.multiYBox.isSelected()) {
            this.multiYField.setEditable(true);
            this.multiYField.setEnabled(true);
            this.multiYField.setBorder(new JTextField().getBorder());
        } else {
            this.multiYField.setEditable(false);
            this.multiYField.setEnabled(false);
            this.multiYField.setBorder(new EtchedBorder(1));
        }
    }

    public JTextField getPixelXField() {
        return this.pixelXField;
    }

    public void reset() {
        this.pixelXField.setText("" + this.board.round(this.board.unit.getWidth()));
        this.termXField.setText(this.board.coordXTerm);
        this.labelXField.setText(this.board.coordXLabel);
        this.multiXField.setText(this.board.coordXMulti);
        this.unitXBox.setSelected(this.board.isCoordXShowUnit());
        this.contXBox.setSelected(this.board.isCoordXContinuous());
        this.multiXBox.setSelected(this.board.isCoordXMultiple());
        this.objectXBox.setSelected(this.board.coordXObject);
        this.pixelYField.setText("" + this.board.round(this.board.unit.getHeight()));
        this.termYField.setText(this.board.coordYTerm);
        this.labelYField.setText(this.board.coordYLabel);
        this.multiYField.setText(this.board.coordYMulti);
        this.unitYBox.setSelected(this.board.isCoordYShowUnit());
        this.contYBox.setSelected(this.board.isCoordYContinuous());
        this.multiYBox.setSelected(this.board.isCoordYMultiple());
        this.objectYBox.setSelected(this.board.coordYObject);
        this.displayMultiFields();
    }

    public void setCoord() {
        try {
            this.board.unit.setSize(Double.parseDouble(this.pixelXField.getText()), Double.parseDouble(this.pixelYField.getText()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.coordXTerm = this.termXField.getText();
            this.board.coordYTerm = this.termYField.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.coordXLabel = this.labelXField.getText();
            this.board.coordYLabel = this.labelYField.getText();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.coordXMulti = this.multiXField.getText();
            this.board.setCoordXMultiple(this.multiXBox.isSelected());
            this.board.coordYMulti = this.multiYField.getText();
            this.board.setCoordYMultiple(this.multiYBox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.setCoordXContinuous(this.contXBox.isSelected());
            this.board.setCoordYContinuous(this.contYBox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.setCoordXShowUnit(this.unitXBox.isSelected());
            this.board.setCoordYShowUnit(this.unitYBox.isSelected());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.board.XLine.setVisible(false);
            this.board.YLine.setVisible(false);
            this.board.coordXObject = this.objectXBox.isSelected();
            this.board.coordYObject = this.objectYBox.isSelected();
            if (this.board.coordXObject) {
                this.board.XLine.setVisible(true);
            }
            if (this.board.coordYObject) {
                this.board.YLine.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.board.calculateElements(true);
        this.reset();
    }

    public void setPixelXField(JTextField jTextField) {
        this.pixelXField = jTextField;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.displayMultiFields();
    }

    public JPanel xPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 15, 15));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentcoord_pixel_unit")));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentcoord_axis_label")));
        jPanel.add(new JLabel());
        jPanel.add(new JLabel());
        this.pixelXField = new JTextField(5);
        this.termXField = new JTextField(5);
        this.termXField.addActionListener(this);
        this.termXField.setActionCommand("term");
        this.labelXField = new JTextField(5);
        this.multiXField = new JTextField(10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1, 15, 15));
        jPanel2.add(this.pixelXField);
        jPanel2.add(this.labelXField);
        jPanel2.add(new JPanel());
        jPanel2.add(new JLabel());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.multiXField);
        this.unitXBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_unit"));
        this.contXBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_label"));
        this.multiXBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_multi"));
        this.multiXBox.addChangeListener(this);
        this.objectXBox = new JCheckBox(Geonext.language.getString("jcontentcoord_axis_x_object"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("West", this.multiXBox);
        jPanel5.add("Center", jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(4, 1));
        jPanel6.add(this.unitXBox);
        jPanel6.add(this.contXBox);
        jPanel6.add(jPanel5);
        jPanel6.add("South", this.objectXBox);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2, 50, 50));
        jPanel7.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add("North", jPanel7);
        jPanel8.add("Center", new JPanel());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(1, 1, 5, 5));
        jPanel9.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jboardpane_axis_x") + " "));
        jPanel9.add(jPanel8);
        return jPanel9;
    }

    public JPanel yPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 15, 15));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentcoord_pixel_unit")));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentcoord_axis_label")));
        jPanel.add(new JLabel());
        jPanel.add(new JLabel());
        this.pixelYField = new JTextField(5);
        this.termYField = new JTextField(5);
        this.termYField.addActionListener(this);
        this.termYField.setActionCommand("term");
        this.labelYField = new JTextField(5);
        this.multiYField = new JTextField(10);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 1, 15, 15));
        jPanel2.add(this.pixelYField);
        jPanel2.add(this.labelYField);
        jPanel2.add(new JPanel());
        jPanel2.add(new JLabel());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.multiYField);
        this.unitYBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_unit"));
        this.contYBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_label"));
        this.multiYBox = new JCheckBox(Geonext.language.getString("jcontentcoord_show_multi"));
        this.multiYBox.addChangeListener(this);
        this.objectYBox = new JCheckBox(Geonext.language.getString("jcontentcoord_axis_y_object"));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.add("West", this.multiYBox);
        jPanel5.add("Center", jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(4, 1));
        jPanel6.add(this.unitYBox);
        jPanel6.add(this.contYBox);
        jPanel6.add(jPanel5);
        jPanel6.add("South", this.objectYBox);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2, 50, 50));
        jPanel7.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.add("North", jPanel7);
        jPanel8.add("Center", new JPanel());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(1, 1, 5, 5));
        jPanel9.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jboardpane_axis_y") + " "));
        jPanel9.add(jPanel8);
        return jPanel9;
    }
}

