/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.Coordinates;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentGrid
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public javax.swing.JCheckBox gridCross;
    public javax.swing.JCheckBox pointSnap;
    public javax.swing.JCheckBox gridDash;
    public JComboBox xGridCombo;
    public JComboBox yGridCombo;
    public JTextField redField;
    public JTextField greenField;
    public JTextField blueField;
    public JButton backView;
    public Color[][] col = new Color[][]{{Color.black, Color.gray, Color.lightGray, Color.white}, {new Color(0, 128, 192), Color.blue, Color.cyan, Color.yellow}, {Color.pink, Color.magenta, Color.red, new Color(255, 150, 0)}, {new Color(128, 0, 0), new Color(0, 128, 64), new Color(185, 219, 125), Color.green}};
    public JButton[][] backColor;

    public JContentGrid() {
    }

    public JContentGrid(JBoardPane jBoardPane) {
        int n;
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(10, 10));
        this.backView = new JButton();
        this.backView.setBackground(jBoardPane.getBackground());
        this.redField = new JTextField(3);
        this.redField.addActionListener(this);
        this.redField.setActionCommand("rgb");
        this.redField.setFont(new Font(this.redField.getFont().getName(), 0, this.redField.getFont().getSize() - 2));
        this.greenField = new JTextField(3);
        this.greenField.addActionListener(this);
        this.greenField.setActionCommand("rgb");
        this.greenField.setFont(new Font(this.redField.getFont().getName(), 0, this.greenField.getFont().getSize() - 2));
        this.blueField = new JTextField(3);
        this.blueField.addActionListener(this);
        this.blueField.setActionCommand("rgb");
        this.blueField.setFont(new Font(this.redField.getFont().getName(), 0, this.blueField.getFont().getSize() - 2));
        this.setRGB();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel.add(new JLabel(Geonext.language.getString("color_red")));
        jPanel.add(new JLabel(Geonext.language.getString("color_green")));
        jPanel.add(new JLabel(Geonext.language.getString("color_blue")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 2));
        jPanel2.add(this.redField);
        jPanel2.add(this.greenField);
        jPanel2.add(this.blueField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(5, 5));
        jPanel3.add("Center", jPanel);
        jPanel3.add("East", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(4, 4, 2, 2));
        jPanel4.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.backColor = new JButton[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.backColor[i][j] = new JButton();
                this.backColor[i][j].setPreferredSize(new Dimension(15, 15));
                this.backColor[i][j].setActionCommand(i + "" + j + "background");
                this.backColor[i][j].addActionListener(this);
                this.backColor[i][j].setBackground(this.col[i][j]);
                jPanel4.add(this.backColor[i][j]);
            }
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(5, 5));
        jPanel5.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel5.add("West", jPanel4);
        jPanel5.add("Center", this.backView);
        jPanel5.add("East", jPanel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgrid_color") + " "));
        jPanel6.add("North", jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(15, 15));
        jPanel7.add("Center", jPanel6);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel8.setBorder(new EmptyBorder(15, 15, 10, 5));
        jPanel8.add(new JLabel("x ="));
        jPanel8.add(new JLabel("y ="));
        this.xGridCombo = new JComboBox();
        this.xGridCombo.setFont(new Font(this.xGridCombo.getFont().getName(), 0, this.xGridCombo.getFont().getSize()));
        this.xGridCombo.setEditable(true);
        for (n = 0; n < 4; ++n) {
            this.xGridCombo.addItem("" + (int)Math.pow(2.0, n));
        }
        this.xGridCombo.setSelectedItem("" + (int)jBoardPane.getSubGrid().getWidth());
        this.yGridCombo = new JComboBox();
        this.yGridCombo.setFont(new Font(this.yGridCombo.getFont().getName(), 0, this.yGridCombo.getFont().getSize()));
        this.yGridCombo.setEditable(true);
        for (n = 0; n < 4; ++n) {
            this.yGridCombo.addItem("" + (int)Math.pow(2.0, n));
        }
        this.yGridCombo.setSelectedItem("" + (int)jBoardPane.getSubGrid().getHeight());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel9.setBorder(new EmptyBorder(15, 0, 5, 15));
        jPanel9.add(this.xGridCombo);
        jPanel9.add(this.yGridCombo);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add("West", jPanel8);
        jPanel10.add("Center", jPanel9);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add("North", jPanel10);
        jPanel11.add("Center", new JPanel());
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgrid_mult") + " "));
        jPanel12.add("Center", jPanel11);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new BorderLayout(15, 15));
        jPanel13.add("North", jPanel7);
        jPanel13.add("Center", jPanel12);
        this.gridCross = new JCheckBox(Geonext.language.getString("jcontentgrid_line_full"));
        this.gridCross.setSelected(!jBoardPane.isCross());
        this.gridCross.setActionCommand("cross");
        this.gridCross.addActionListener(this);
        this.gridDash = new JCheckBox(Geonext.language.getString("jcontentgrid_line_dashed"));
        this.gridDash.setSelected(!jBoardPane.isGridDash());
        this.pointSnap = new JCheckBox(Geonext.language.getString("jcontentgrid_only_points"));
        this.pointSnap.setSelected(!jBoardPane.isPointSnap());
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayout(2, 2, 10, 10));
        jPanel14.setBorder(new EmptyBorder(5, 15, 0, 0));
        jPanel14.add(this.gridCross);
        jPanel14.add(this.gridDash);
        jPanel14.add(this.pointSnap);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new BorderLayout());
        jPanel15.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel15.add("North", jPanel14);
        this.add("North", jPanel13);
        this.add("Center", jPanel15);
        this.validateTree();
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.board.setSaved(false);
            this.setGrid();
        } else if (string.equals("apply")) {
            this.board.setSaved(false);
            this.setGrid();
            this.xGridCombo.setSelectedItem("" + (int)this.board.getSubGrid().getWidth());
            this.yGridCombo.setSelectedItem("" + (int)this.board.getSubGrid().getHeight());
            this.gridCross.setSelected(!this.board.isCross());
        } else if (!string.equals("cancel")) {
            if (string.endsWith("background")) {
                int n = new Integer(string.substring(0, 1));
                int n2 = new Integer(string.substring(1, 2));
                this.backView.setBackground(this.col[n][n2]);
                this.setRGB();
            } else if (string.endsWith("rgb")) {
                this.setColor();
            } else if (string.endsWith("cross")) {
                if (this.gridCross.isSelected()) {
                    this.gridDash.setEnabled(true);
                    this.gridDash.setSelected(this.board.isGridDash());
                } else {
                    this.gridDash.setEnabled(false);
                    this.gridDash.setSelected(false);
                }
            }
        }
        this.board.repaint();
    }

    public javax.swing.JCheckBox getGridDash() {
        return this.gridDash;
    }

    public JComboBox getXGridCombo() {
        return this.xGridCombo;
    }

    public void reset() {
        this.xGridCombo.setSelectedItem("" + (int)this.board.getSubGrid().getWidth());
        this.yGridCombo.setSelectedItem("" + (int)this.board.getSubGrid().getHeight());
        this.backView.setBackground(this.board.getGridColor());
        this.gridCross.setSelected(!this.board.isCross());
        this.gridDash.setSelected(this.board.isGridDash());
        this.pointSnap.setSelected(this.board.isPointSnap());
    }

    public void setColor() {
        try {
            this.backView.setBackground(new Color(Integer.parseInt(this.redField.getText()), Integer.parseInt(this.greenField.getText()), Integer.parseInt(this.blueField.getText())));
        }
        catch (Exception exception) {
            this.setRGB();
        }
    }

    public void setGrid() {
        this.board.setGridColor(this.backView.getBackground());
        this.board.setCross(!this.gridCross.isSelected());
        this.board.setGridDash(this.gridDash.isSelected());
        this.board.setPointSnap(this.pointSnap.isSelected());
        try {
            this.board.setSubGrid(new Coordinates(Integer.parseInt((String)this.xGridCombo.getSelectedItem()), Integer.parseInt((String)this.yGridCombo.getSelectedItem())));
        }
        catch (Exception exception) {
            this.board.setSubGrid(new Coordinates((int)this.board.getSubGrid().getWidth(), (int)this.board.getSubGrid().getHeight()));
        }
    }

    public void setGridDash(javax.swing.JCheckBox jCheckBox) {
        this.gridDash = jCheckBox;
    }

    public void setRGB() {
        this.redField.setText("" + this.backView.getBackground().getRed());
        this.greenField.setText("" + this.backView.getBackground().getGreen());
        this.blueField.setText("" + this.backView.getBackground().getBlue());
    }

    public void setXGridCombo(JComboBox jComboBox) {
        this.xGridCombo = jComboBox;
    }
}

