/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import geonext.GeonetFileFilter;
import geonext.Geonext;
import geonext.JBoard;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import geonext.JFileChooser;
import geonext.JRadioButton;
import geonext.JSaveListRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import util.Compression;

class JContentSave
extends JContentPanel
implements ActionListener,
ListSelectionListener,
Printable {
    public JTextField heightField;
    public JTextField widthField;
    public javax.swing.JRadioButton unitRadio;
    public javax.swing.JRadioButton scalRadio;
    public javax.swing.JCheckBox smallBox;
    public javax.swing.JCheckBox smallGXTBox;
    public javax.swing.JCheckBox ns47Box;
    public javax.swing.JCheckBox dynGXTBox;
    public javax.swing.JCheckBox relativeBox;
    public javax.swing.JCheckBox dynBox;
    public javax.swing.JCheckBox menuBox;
    public javax.swing.JCheckBox menuGXTBox;
    public javax.swing.JCheckBox constBox;
    public javax.swing.JCheckBox jarBox;
    public javax.swing.JCheckBox paramFileBox;
    public JTextField nameField;
    public JTextField typeField;
    public JTextField pathField;
    public JList contentList;
    public JList imageList;
    public Geonext geonext;
    public int fileType;
    public JTextField unitText;
    public JButton upButton;
    public JButton deleteButton;
    public JButton downButton;
    public JButton pathButton;
    public CardLayout layout;
    public JPanel cardPanel;
    public JPanel pathPanel;
    public JPanel pathAllPanel;
    public JTextField secField;
    public String tmpJarPath = "";
    public JBoardPane actBoard;
    public JTabbedPane tp;

    public JContentSave() {
    }

    public JContentSave(Geonext geonext) {
        this.geonext = geonext;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentsave_file")));
        jPanel.add(new JLabel(Geonext.language.getString("jcontentsave_type")));
        this.nameField = Geonext.systemAccess ? new JTextField(this.geonext.filepath) : new JTextField(Geonext.language.getString("jcontentsave_access"));
        this.nameField.setEditable(false);
        this.nameField.setBorder(new EtchedBorder(1));
        this.nameField.setBackground(new JLabel().getBackground());
        this.typeField = new JTextField(this.geonext.extention);
        this.typeField.setEditable(false);
        this.typeField.setBorder(new EtchedBorder(1));
        this.typeField.setBackground(new JLabel().getBackground());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel2.add(this.nameField);
        jPanel2.add(this.typeField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        jPanel3.setBorder(new EmptyBorder(5, 15, 15, 15));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentsave_file") + " "));
        jPanel4.add("Center", jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(15, 15));
        jPanel5.add("North", new JPanel());
        this.contentList = new JList();
        this.generateList();
        this.contentList.setVisibleRowCount(3);
        this.contentList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.contentList, 20, 31);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel6.add(jScrollPane);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentsave_content") + " "));
        jPanel7.add("North", jPanel6);
        JPanel jPanel8 = this.initGSS();
        JPanel jPanel9 = this.initPNG();
        JPanel jPanel10 = this.initGXT();
        JPanel jPanel11 = this.initHTML();
        JPanel jPanel12 = this.initSVG();
        this.cardPanel = new JPanel();
        this.layout = new CardLayout();
        this.layout.addLayoutComponent(jPanel8, "gss");
        this.layout.addLayoutComponent(jPanel9, "png");
        this.layout.addLayoutComponent(jPanel10, "gxt");
        this.layout.addLayoutComponent(jPanel11, "html");
        this.layout.addLayoutComponent(jPanel12, "svg");
        this.cardPanel.setLayout(this.layout);
        this.cardPanel.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentsave_properties") + " "));
        this.cardPanel.add((Component)jPanel8, "gss");
        this.cardPanel.add((Component)jPanel9, "png");
        this.cardPanel.add((Component)jPanel10, "gxt");
        this.cardPanel.add((Component)jPanel11, "html");
        this.cardPanel.add((Component)jPanel12, "svg");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayout(1, 2, 15, 10));
        jPanel13.add(jPanel7);
        jPanel13.add(this.cardPanel);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new BorderLayout(10, 10));
        jPanel14.add("Center", jPanel13);
        this.add("North", jPanel4);
        this.add("South", jPanel14);
        this.contentList.requestFocus();
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            this.save();
            this.reset();
            this.geonext.getGeonextSaveDialog().dispose();
        } else if (string.equals("apply")) {
            this.save();
        } else if (string.equals("cancel")) {
            this.geonext.getGeonextSaveDialog().dispose();
        } else if (!string.equals("open")) {
            if (string.equals("dynbox")) {
                this.setDynBox();
            } else if (string.equals("dyngxtbox")) {
                this.setDynGXTBox();
            } else if (string.equals("buttonsize")) {
                this.setSmallBox();
            } else if (string.equals("buttongxtsize")) {
                this.setSmallGXTBox();
            } else if (string.equals("unit")) {
                this.setUnit();
            } else if (string.endsWith("button")) {
                this.moveScreenShot(string.substring(0, string.length() - 6));
            } else if (string.endsWith("path")) {
                this.getPath();
            } else if (string.endsWith("relative")) {
                this.setRelativePath();
            } else if (string.endsWith("jarbox")) {
                this.pathPanel.setVisible(!this.jarBox.isSelected());
            }
        }
    }

    public static void saveError() {
        JOptionPane.showMessageDialog(null, Geonext.language.getString("file_write_error"), Geonext.language.getString("text_error"), 0);
    }

    public String createHTML(int n, int n2, String string, String string2, String string3, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\\");
        string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken() + "/";
        }
        if (!(this.relativeBox.isSelected() || string2.startsWith("file:/") || string2.startsWith("http:"))) {
            string2 = "file:/" + string2;
        }
        if (string2.startsWith("file://")) {
            string2 = "file:" + string2.substring(6);
        }
        String string4 = "";
        if (!bl) {
            string4 = string4 + "<html>\r\n";
            string4 = string4 + this.geonext.getHTMLHead();
            string4 = string4 + "\t<body bgcolor=\"#ffffff\">\r\n";
            string4 = string4 + "\t\t<!--<a href=\"http://geonext.de\" style=\"font-family:sans-serif;font-weight:bold;font-size:12px;text-decoration:none;color:#000000;\">&copy; 2002 - http://geonext.de</a><br>-->\r\n";
            string4 = string4 + "\t\t<!-- GEONExT start-->\r\n";
        }
        if (!this.ns47Box.isSelected()) {
            string4 = string4 + "\t\t<applet id=\"xxx\" code=\"geonext.Geonext.class\" codebase=\"" + string2 + "\" archive=\"geonext.jar\" width=\"" + n + "\" height=\"" + n2 + "\" MAYSCRIPT>\r\n";
            string4 = string4 + "\t\t\t<param name=\"scriptable\" value=\"true\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"geonext\" value=\"" + string + "\">\r\n";
            string4 = string4 + "\t\t</applet>\r\n";
        } else {
            string4 = string4 + "\t\t<object classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" width=\"" + n + "\" height=\"" + n2 + "\" codebase=\"http://did.mat.uni-bayreuth.de/geonext/software/index.html\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"CODE\" value=\"geonext/Geonext.class\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"ARCHIVE\" value=\"geonext.jar\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"type\" value=\"application/x-java-applet;version=1.3\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"CODEBASE\" value=\"" + string2 + "\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"scriptable\" value=\"false\">\r\n";
            string4 = string4 + "\t\t\t<param name=\"geonext\" value=\"" + string + "\">\r\n";
            string4 = string4 + "\t\t\t<comment>\r\n";
            string4 = string4 + "\t\t<embed type=\"application/x-java-applet;version=1.3\" code=\"geonext/Geonext.class\" archive=\"geonext.jar\" codebase=\"" + string2 + "\" width=\"" + n + "\" height=\"" + n2 + "\" scriptable=\"false\" pluginspage=\"http://did.mat.uni-bayreuth.de/geonext/software/index.html\" geonext=\"" + string + "\">\r\n";
            string4 = string4 + "\t\t\t<noembed>\r\n";
            string4 = string4 + "\t\t\t</comment>\r\n";
            string4 = string4 + "\t\t\t\tJava 2 (JRE) Unterst\u00fctzung fehlt!\r\n";
            string4 = string4 + "\t\t\t</noembed>\r\n";
            string4 = string4 + "\t\t</embed>\r\n";
            string4 = string4 + "\t\t</object>\r\n";
        }
        if (!bl) {
            string4 = string4 + "\t\t<!-- GEONExT end-->\r\n";
            string4 = string4 + "\t\t<p>&nbsp;<p>\r\n";
            string4 = string4 + "\t\t" + string3 + "\r\n";
            string4 = string4 + "\t</body>\r\n";
            string4 = string4 + "</html>\r\n";
        }
        return string4;
    }

    public String createSlideShow(String string, int n, int n2) {
        string = string.substring(Math.max(string.lastIndexOf("\\"), string.lastIndexOf("/")) + 1, string.length());
        String string2 = "";
        string2 = string2 + "<html>\n";
        string2 = string2 + "\t<head>\n ";
        string2 = string2 + "\t\t<title> http : //geonext.de </title>\n";
        string2 = string2 + "\t\t<script type=\"text/javascript\">\n";
        string2 = string2 + "\t\t\t<!--\n";
        string2 = string2 + "\t\t\t\tgxIndex = 0;\n";
        string2 = string2 + "\t\t\t\tgxMax = " + n + ";\n";
        string2 = string2 + "\t\t\t\tgxImg = \"\";\n";
        string2 = string2 + "\t\t\t\tfunction gxStart(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tgxIndex = 0;\n";
        string2 = string2 + "\t\t\t\t\tgxOpen(img);\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxEnd(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tgxIndex = gxMax;\n";
        string2 = string2 + "\t\t\t\t\tgxOpen(img);\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxBack(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tif(gxIndex > 0) gxIndex--;\n";
        string2 = string2 + "\t\t\t\t\tgxOpen(img);\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxNext(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tif(gxIndex < gxMax) gxIndex++;\n";
        string2 = string2 + "\t\t\t\t\tgxOpen(img);\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxMotion(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tgxIndex = 0;\n";
        string2 = string2 + "\t\t\t\t\tgxImg = img;\n";
        string2 = string2 + "\t\t\t\t\tgxAuto();\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxAuto()\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tgxNext(gxImg);\n";
        string2 = string2 + "\t\t\t\t\tif (gxIndex < gxMax) window.setTimeout(\"gxAuto()\"," + n2 + ");\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\tfunction gxOpen(img)\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tdocument.images[img].src=img+gxIndex+\".png\";\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t//-->\n";
        string2 = string2 + "\t\t</script>\n";
        string2 = string2 + "\t\t<style type=\"text/css\">\n";
        string2 = string2 + "\t\t\t<!--\n";
        string2 = string2 + "\t\t\t\t#cell \n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tborder-color:#000000;\n";
        string2 = string2 + "\t\t\t\t\tborder-width:1px;\n";
        string2 = string2 + "\t\t\t\t\tborder-style:solid;\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\t#white\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tfont-family:sans-serif;\n";
        string2 = string2 + "\t\t\t\t\tfont-weight:bold;\n";
        string2 = string2 + "\t\t\t\t\tfont-size:12px;\n";
        string2 = string2 + "\t\t\t\t\ttext-decoration:none;\n";
        string2 = string2 + "\t\t\t\t\tcolor:#ffffff;\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t\t#black\n";
        string2 = string2 + "\t\t\t\t{\n";
        string2 = string2 + "\t\t\t\t\tfont-family:sans-serif;\n";
        string2 = string2 + "\t\t\t\t\tfont-weight:bold;\n";
        string2 = string2 + "\t\t\t\t\tfont-size:12px;\n";
        string2 = string2 + "\t\t\t\t\ttext-decoration:none;\n";
        string2 = string2 + "\t\t\t\t\tcolor:#000000;\n";
        string2 = string2 + "\t\t\t\t}\n";
        string2 = string2 + "\t\t\t-->\n";
        string2 = string2 + "\t\t</style>\n";
        string2 = string2 + "\t</head>\n";
        string2 = string2 + "\t<body>\n";
        string2 = string2 + "\t\t<b id=\"black\">&copy; 2000 - <a href=\"http://geonext.de\" id=\"black\">http://geonext.de</a>\n";
        string2 = string2 + "\t\t<table cellpadding=\"0\">\n";
        string2 = string2 + "\t\t\t<tr>\n";
        string2 = string2 + "\t\t\t\t<td align=\"center\" valign=\"middle\" id=\"cell\" id=\"cell\"><img src=\"" + string + "0.png\" border=0 alt=\"GEONExT\" name=\"" + string + "\"></td>\n";
        string2 = string2 + "\t\t\t</tr>\n";
        string2 = string2 + "\t\t\t<tr>\n";
        string2 = string2 + "\t\t\t\t<td>\n";
        string2 = string2 + "\t\t\t\t\t<table cellpadding=\"0\">\n";
        string2 = string2 + "\t\t\t\t\t<tr>\n";
        string2 = string2 + "\t\t\t\t\t\t<td width=\"20\" height=\"20\" align=\"center\" valign=\"middle\" id=\"cell\" bgcolor=\"#c0c0c0\"><a href=\"javascript:gxStart('" + string + "');\" id=\"white\">&lt;&lt;</a></td>\n";
        string2 = string2 + "\t\t\t\t\t\t<td width=\"20\" height=\"20\" align=\"center\" valign=\"middle\" id=\"cell\" bgcolor=\"#c0c0c0\"><a href=\"javascript:gxBack('" + string + "');\" id=\"white\">&lt;</a></td>\n";
        string2 = string2 + "\t\t\t\t\t\t<td width=\"20\" height=\"20\" align=\"center\" valign=\"middle\" id=\"cell\" bgcolor=\"#c0c0c0\"><a href=\"javascript:gxMotion('" + string + "');\" id=\"white\">&nbsp;AUTO&nbsp;</a></td>";
        string2 = string2 + "\t\t\t\t\t\t<td width=\"20\" height=\"20\" align=\"center\" valign=\"middle\" id=\"cell\" bgcolor=\"#c0c0c0\"><a href=\"javascript:gxNext('" + string + "');\" id=\"white\">&gt;</a></td>\n";
        string2 = string2 + "\t\t\t\t\t\t<td width=\"20\" height=\"20\" align=\"center\" valign=\"middle\" id=\"cell\" bgcolor=\"#c0c0c0\"><a href=\"javascript:gxEnd('" + string + "');\" id=\"white\">&gt;&gt;</a></td>\n";
        string2 = string2 + "\t\t\t\t\t</tr>\n";
        string2 = string2 + "\t\t\t\t\t</table>\n";
        string2 = string2 + "\t\t\t\t</td>\n";
        string2 = string2 + "\t\t\t</tr>\n";
        string2 = string2 + "\t\t</table>\n";
        string2 = string2 + "\t</body>\n";
        string2 = string2 + "</html>\n";
        return string2;
    }

    public void generateGSSList() {
        JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndex())).board;
        if (jBoardPane.slideImage.size() > 0) {
            Object[] objectArray = new Object[jBoardPane.slideImage.size()];
            this.imageList.setCellRenderer(new JSaveListRenderer());
            for (int i = 0; i < jBoardPane.slideImage.size(); ++i) {
                Vector<Object> vector = new Vector<Object>();
                Image image = (Image)((Vector)jBoardPane.slideImage.get(i)).get(0);
                int n = (Integer)((Vector)jBoardPane.slideImage.get(i)).get(2);
                int n2 = (Integer)((Vector)jBoardPane.slideImage.get(i)).get(3);
                double d = Math.max(n, n2);
                d = 75.0 / d;
                image = image.getScaledInstance(jBoardPane.round((double)n * d), jBoardPane.round((double)n2 * d), 16);
                vector.addElement(new ImageIcon(image));
                vector.addElement(jBoardPane.getTitle());
                vector.addElement(new Dimension(jBoardPane.round((double)n * d), jBoardPane.round((double)n2 * d)));
                vector.addElement(jBoardPane.getInfo());
                vector.addElement(jBoardPane.getAuthor());
                vector.addElement(new Dimension(jBoardPane.round(n), jBoardPane.round(n2)));
                vector.addElement("");
                objectArray[i] = vector;
            }
            this.imageList.setListData(objectArray);
        } else {
            this.imageList.setCellRenderer(new DefaultListCellRenderer());
            Vector<String> vector = new Vector<String>();
            vector.addElement(" " + Geonext.language.getString("jcontentsave_no_image") + "         ");
            this.imageList.setListData(vector);
        }
        this.imageList.setSelectionMode(0);
        this.validateTree();
    }

    public void generateList() {
        Object object;
        Vector vector;
        int n;
        Object[] objectArray = new Object[this.geonext.board.size()];
        for (n = 0; n < this.geonext.board.size(); ++n) {
            vector = new Vector();
            object = ((JBoard)this.geonext.board.get((int)n)).board;
            Image image = new BufferedImage(((JBoardPane)object).jep.getWidth(), ((JBoardPane)object).jep.getHeight(), 1);
            ((JBoardPane)object).jep.paint(((Image)image).getGraphics());
            double d = Math.max(((JBoardPane)object).jep.getWidth(), ((JBoardPane)object).jep.getHeight());
            d = 75.0 / d;
            image = image.getScaledInstance(((JBoardPane)object).round((double)((JBoardPane)object).jep.getWidth() * d), ((JBoardPane)object).round((double)((JBoardPane)object).jep.getHeight() * d), 16);
            vector.addElement(new ImageIcon(image));
            vector.addElement(((JBoardPane)object).getTitle());
            vector.addElement(new Dimension(((JBoardPane)object).round((double)((JBoardPane)object).jep.getWidth() * d), ((JBoardPane)object).round((double)((JBoardPane)object).jep.getHeight() * d)));
            vector.addElement(((JBoardPane)object).getInfo());
            vector.addElement(((JBoardPane)object).getAuthor());
            vector.addElement(new Dimension(((JBoardPane)object).round(((JBoardPane)object).jep.getWidth()), ((JBoardPane)object).round(((JBoardPane)object).jep.getHeight())));
            vector.addElement("show");
            objectArray[n] = vector;
        }
        this.contentList.setListData(objectArray);
        this.contentList.setCellRenderer(new JSaveListRenderer());
        if (this.geonext.extention.equals("html") || this.geonext.extention.equals("geo") || this.geonext.extention.equals("gxt")) {
            this.contentList.setSelectionMode(2);
            n = this.geonext.findSetById(this.geonext.activeBoard.id);
            if (n != -1) {
                vector = (Vector)this.geonext.boardSets.get(n);
                object = new int[vector.size() - 5];
                for (int i = 5; i < vector.size(); ++i) {
                    for (int j = 0; j < this.geonext.board.size(); ++j) {
                        if ((Integer)vector.get(i) != ((JBoard)this.geonext.board.get((int)j)).id) continue;
                        object[i - 5] = j;
                    }
                }
                this.contentList.setSelectedIndices((int[])object);
            } else {
                for (int i = 0; i < this.geonext.board.size(); ++i) {
                    if (!this.geonext.activeBoard.equals(this.geonext.board.get(i))) continue;
                    this.contentList.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.contentList.setSelectionMode(0);
            for (n = 0; n < this.geonext.board.size(); ++n) {
                if (!this.geonext.activeBoard.equals(this.geonext.board.get(n))) continue;
                this.contentList.setSelectedIndex(n);
                break;
            }
        }
    }

    public Vector generateListVector() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.geonext.board.size(); ++i) {
            vector.addElement(((JBoard)this.geonext.board.get((int)i)).board.getTitle());
        }
        return vector;
    }

    public void getPath() {
        try {
            String string;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.addChoosableFileFilter(new GeonetFileFilter("jar", Geonext.language.getString("jcontentsave_archive")));
            jFileChooser.setCurrentDirectory(new File(this.geonext.lastPath));
            int n = jFileChooser.showDialog(this, Geonext.language.getString("jcontentsave_choose"));
            this.tmpJarPath = string = jFileChooser.getSelectedFile().getPath().substring(0, jFileChooser.getSelectedFile().getPath().lastIndexOf(File.separatorChar));
            String string2 = this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(File.separatorChar));
            if (n == 0) {
                string = this.relativeBox.isSelected() ? this.getRelativePath(string2, string) : string + File.separatorChar;
            }
            this.pathField.setText(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRelativePath(String string, String string2) {
        String string3 = "";
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + File.separatorChar);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "" + File.separatorChar);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
            ++n;
        }
        Vector<String> vector2 = new Vector<String>();
        int n2 = 0;
        while (stringTokenizer2.hasMoreTokens()) {
            vector2.addElement(stringTokenizer2.nextToken());
            ++n2;
        }
        if (vector.get(0).equals(vector2.get(0))) {
            int n3;
            for (n2 = 0; n2 < vector.size() && n2 < vector2.size() && vector.get(n2).equals(vector2.get(n2)); ++n2) {
            }
            for (n3 = n2; n3 < vector.size(); ++n3) {
                string3 = string3 + ".." + File.separatorChar;
            }
            for (n3 = n2; n3 < vector2.size(); ++n3) {
                string4 = string4 + vector2.get(n3) + File.separatorChar;
            }
            if (string3.equals(string4)) {
                return ".";
            }
            string3 = string3 + string4;
            return string3;
        }
        return ".";
    }

    public JTextField getUnitText() {
        return this.unitText;
    }

    public JPanel initGSS() {
        this.secField = new JTextField("1000");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("Center", this.secField);
        jPanel.add("East", new JLabel("ms"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel2.add(new JLabel(Geonext.language.getString("jcontentsave_timer")));
        jPanel2.add(jPanel);
        this.upButton = new JButton(new ImageIcon(this.getClass().getResource("24/function_up.gif")));
        this.upButton.addActionListener(this);
        this.upButton.setActionCommand("upbutton");
        this.deleteButton = new JButton(new ImageIcon(this.getClass().getResource("24/mode_delete.gif")));
        this.deleteButton.addActionListener(this);
        this.deleteButton.setActionCommand("deletebutton");
        this.downButton = new JButton(new ImageIcon(this.getClass().getResource("24/function_down.gif")));
        this.downButton.addActionListener(this);
        this.downButton.setActionCommand("downbutton");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 1, 5, 5));
        jPanel3.add(this.upButton);
        jPanel3.add(this.deleteButton);
        jPanel3.add(this.downButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add("North", jPanel3);
        jPanel4.add("Center", new JPanel());
        jPanel4.add("South", jPanel2);
        this.imageList = new JList();
        this.generateGSSList();
        this.imageList.setVisibleRowCount(3);
        JScrollPane jScrollPane = new JScrollPane(this.imageList, 20, 31);
        jScrollPane.setSize(75, 100);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(15, 15));
        jPanel5.setBorder(new EmptyBorder(10, 15, 15, 15));
        jPanel5.add("East", jScrollPane);
        jPanel5.add("Center", jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(1, 1));
        jPanel6.add(jPanel5);
        return jPanel6;
    }

    public JPanel initGXT() {
        this.dynGXTBox = new JCheckBox(Geonext.language.getString("jcontentsave_board_only"));
        this.dynGXTBox.addActionListener(this);
        this.dynGXTBox.setActionCommand("dyngxtbox");
        this.menuGXTBox = new JCheckBox(Geonext.language.getString("jcontentsave_menu_off"));
        this.menuGXTBox.addActionListener(this);
        this.menuGXTBox.setActionCommand("menubox");
        this.smallGXTBox = new JCheckBox(Geonext.language.getString("jcontentsave_small"));
        this.smallGXTBox.addActionListener(this);
        this.smallGXTBox.setActionCommand("buttongxtsize");
        if (Geonext.buttonSize == 16) {
            this.smallGXTBox.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 1, 10, 10));
        jPanel.add(this.dynGXTBox);
        jPanel.add(this.menuGXTBox);
        jPanel.add(this.smallGXTBox);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel2.add("North", jPanel);
        return jPanel2;
    }

    public JPanel initHTML() {
        this.pathButton = new JButton(" " + Geonext.language.getString("jcontentsave_path") + " ", new ImageIcon(this.getClass().getResource("gni.gif")));
        this.pathButton.setActionCommand("path");
        this.pathButton.addActionListener(this);
        this.relativeBox = new JCheckBox(Geonext.language.getString("jcontentsave_relative"));
        this.relativeBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.relativeBox.setSelected(true);
        this.relativeBox.setActionCommand("relative");
        this.relativeBox.addActionListener(this);
        this.dynBox = new JCheckBox(Geonext.language.getString("jcontentsave_board_only"));
        this.dynBox.addActionListener(this);
        this.dynBox.setActionCommand("dynbox");
        this.constBox = new JCheckBox(Geonext.language.getString("jcontentsave_description"));
        this.smallBox = new JCheckBox(Geonext.language.getString("jcontentsave_small"));
        this.smallBox.addActionListener(this);
        this.smallBox.setActionCommand("buttonsize");
        this.ns47Box = new JCheckBox(Geonext.language.getString("jcontentsave_netscape_4_7"));
        this.ns47Box.addActionListener(this);
        this.ns47Box.setActionCommand("ns47box");
        this.menuBox = new JCheckBox(Geonext.language.getString("jcontentsave_menu_off"));
        this.menuBox.addActionListener(this);
        this.menuBox.setActionCommand("menubox");
        this.jarBox = new JCheckBox(Geonext.language.getString("jcontentsave_save_archive"));
        this.jarBox.addActionListener(this);
        this.jarBox.setActionCommand("jarbox");
        this.paramFileBox = new JCheckBox(Geonext.language.getString("jcontentsave_gxt_extern"));
        this.paramFileBox.addActionListener(this);
        this.paramFileBox.setActionCommand("jarbox");
        this.pathField = new JTextField(".");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        jPanel.add("West", this.pathButton);
        jPanel.add("Center", this.relativeBox);
        this.pathPanel = new JPanel();
        this.pathPanel.setLayout(new BorderLayout(10, 10));
        this.pathPanel.add("Center", jPanel);
        this.pathPanel.add("South", this.pathField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 5, 5));
        jPanel2.add(this.jarBox);
        jPanel2.add(this.paramFileBox);
        this.pathAllPanel = new JPanel();
        this.pathAllPanel.setLayout(new BorderLayout());
        this.pathAllPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.pathAllPanel.add("North", jPanel2);
        this.pathAllPanel.add("South", this.pathPanel);
        if (Geonext.buttonSize == 16) {
            this.smallBox.setSelected(true);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(5, 1, 5, 5));
        jPanel3.add(this.dynBox);
        jPanel3.add(this.menuBox);
        jPanel3.add(this.smallBox);
        jPanel3.add(this.constBox);
        jPanel3.add(new JPanel());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel4.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel4.add("North", jPanel3);
        jPanel4.add("Center", new JPanel());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 2, 15, 5));
        this.widthField = new JTextField(new Integer(this.geonext.getWidth()).toString(), 5);
        this.heightField = new JTextField(new Integer(this.geonext.getHeight()).toString(), 5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(5, 5));
        jPanel6.add("West", new JLabel(Geonext.language.getString("common_width")));
        jPanel6.add("Center", this.widthField);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(5, 5));
        jPanel7.add("West", new JLabel(Geonext.language.getString("common_height")));
        jPanel7.add("Center", this.heightField);
        jPanel5.add(jPanel6);
        jPanel5.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 0));
        jPanel8.add("West", jPanel5);
        jPanel8.add("Center", new JPanel());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.setBorder(new EmptyBorder(10, 15, 15, 15));
        this.tp = new JTabbedPane();
        this.tp.addTab(Geonext.language.getString("jcontentsave_view"), jPanel4);
        this.tp.addTab(Geonext.language.getString("jcontentsave_options"), this.pathAllPanel);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout(5, 5));
        jPanel10.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel10.add("North", jPanel8);
        jPanel10.add("South", this.tp);
        return jPanel10;
    }

    public JPanel initPNG() {
        return new JPanel();
    }

    public JPanel initSVG() {
        this.unitRadio = new JRadioButton(Geonext.language.getString("jcontentsave_unit"));
        this.unitRadio.addActionListener(this);
        this.unitRadio.setActionCommand("unit");
        this.unitRadio.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel jLabel = new JLabel(Geonext.language.getString("jcontentsave_cm"));
        jLabel.setForeground(Color.black);
        JPanel jPanel = new JPanel();
        this.unitText = new JTextField("1");
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add("West", this.unitRadio);
        jPanel.add("Center", this.unitText);
        jPanel.add("East", jLabel);
        this.setUnit();
        this.scalRadio = new JRadioButton(Geonext.language.getString("jcontentsave_board"));
        this.scalRadio.setSelected(true);
        this.scalRadio.addActionListener(this);
        this.scalRadio.setActionCommand("unit");
        this.scalRadio.setBorder(new EmptyBorder(0, 0, 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.unitRadio);
        buttonGroup.add(this.scalRadio);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add("Center", this.scalRadio);
        jPanel2.add("South", jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel3.add("North", jPanel2);
        return jPanel3;
    }

    public void moveScreenShot(String string) {
        JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndex())).board;
        int n = this.imageList.getSelectedIndex();
        if (n > -1 && jBoardPane.slideImage.size() > 0) {
            Object e = jBoardPane.slideImage.get(n);
            if (string.equals("up") && n > 0) {
                jBoardPane.slideImage.add(n - 1, e);
                jBoardPane.slideImage.remove(n-- + 1);
            } else if (string.equals("delete")) {
                jBoardPane.slideImage.remove(e);
            } else if (string.equals("down") && n < jBoardPane.slideImage.size()) {
                jBoardPane.slideImage.remove(n++);
                jBoardPane.slideImage.add(n, e);
            }
            this.generateGSSList();
            if (n > -1 && n < jBoardPane.slideImage.size()) {
                this.imageList.setSelectedIndex(n);
            } else {
                this.imageList.setSelectedIndex(jBoardPane.slideImage.size() - 1);
            }
        } else {
            this.generateGSSList();
        }
    }

    public void reset() {
        this.contentList.setSelectionMode(2);
        if (this.geonext.extention.equals("png")) {
            this.layout.show(this.cardPanel, "png");
            this.contentList.setSelectionMode(0);
        } else if (this.geonext.extention.equals("svg")) {
            this.layout.show(this.cardPanel, "svg");
            this.contentList.setSelectionMode(0);
        } else if (this.geonext.extention.equals("html")) {
            this.layout.show(this.cardPanel, "html");
        } else if (this.geonext.extention.equals("geo") || this.geonext.extention.equals("gxt")) {
            this.layout.show(this.cardPanel, "gxt");
        } else if (this.geonext.extention.equals("gss")) {
            this.layout.show(this.cardPanel, "gss");
            this.contentList.setSelectionMode(0);
        }
        this.constBox.setSelected(false);
        this.dynBox.setSelected(false);
        this.dynGXTBox.setSelected(false);
        this.smallGXTBox.setEnabled(true);
        this.smallBox.setEnabled(true);
        this.widthField.setEnabled(true);
        this.heightField.setEnabled(true);
        if (Geonext.buttonSize == 16) {
            this.smallGXTBox.setSelected(true);
            this.smallBox.setSelected(true);
        } else {
            this.smallGXTBox.setSelected(false);
            this.smallBox.setSelected(false);
        }
        this.widthField.setText(new Integer(this.geonext.getWidth()).toString());
        this.heightField.setText(new Integer(this.geonext.getHeight()).toString());
        if (Geonext.systemAccess) {
            if (this.geonext.extention.equals("gss")) {
                this.nameField.setText(this.geonext.filepath);
                this.typeField.setText(Geonext.language.getString("jcontentsave_slide_show"));
            } else {
                this.nameField.setText(this.geonext.filepath);
                this.typeField.setText(this.geonext.extention);
            }
        } else {
            this.nameField.setText(Geonext.language.getString("jcontentsave_access"));
            this.typeField.setText(Geonext.language.getString("jcontentsave_access"));
        }
        this.scalRadio.setSelected(true);
        this.unitRadio.setSelected(false);
        this.unitText.setText("1");
        this.relativeBox.setSelected(true);
        this.pathField.setText(".");
    }

    public void save() {
        String string = "";
        if (this.geonext.extention.equals("gxt") || this.geonext.extention.equals("geo")) {
            if (Geonext.parentApplication == null) {
                if (Geonext.systemAccess && this.geonext.geonextIODialog == null) {
                    this.saveGXT(true, this.dynGXTBox.isSelected(), this.menuGXTBox.isSelected());
                } else {
                    this.saveGXT(false, this.dynGXTBox.isSelected(), this.menuGXTBox.isSelected());
                }
            } else {
                this.saveGXT(false, this.dynGXTBox.isSelected(), this.menuGXTBox.isSelected());
            }
        }
        if (this.geonext.extention.equals("html")) {
            if (Geonext.systemAccess && this.geonext.geonextIODialog == null) {
                this.saveHTML(true);
            } else {
                this.saveHTML(false);
            }
        }
        if (this.geonext.extention.equals("svg")) {
            this.saveSVG();
        }
        if (this.geonext.extention.equals("png")) {
            this.savePNG();
        }
        if (this.geonext.extention.equals("gss")) {
            this.saveGSS();
        }
        if (this.geonext.filepath != null) {
            this.geonext.lastPath = this.geonext.filepath;
        }
    }

    public void saveGSS() {
        int n;
        String string = this.geonext.filepath.substring(0, this.geonext.filepath.length() - 5);
        JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board;
        for (n = 0; n < jBoardPane.slideImage.size(); ++n) {
            String string2 = string + n + ".png";
            boolean bl = true;
            Object var6_7 = null;
            this.writePNG2disk((Image)((Vector)jBoardPane.slideImage.get(n)).get(0), string2);
        }
        this.geonext.filepath = string + ".html";
        n = 1000;
        try {
            n = new Integer(this.secField.getText());
        }
        catch (Exception exception) {
            n = 1000;
        }
        this.write2disk(this.createSlideShow(string, jBoardPane.slideImage.size() - 1, n));
    }

    public void saveGXT(boolean bl, boolean bl2, boolean bl3) {
        JComponent jComponent;
        int n;
        String string = "";
        string = string + "<GEONEXT>\n<VERSION>" + "1.70" + "</VERSION>\n";
        int[] nArray = new int[this.contentList.getSelectedIndices().length];
        int[] nArray2 = new int[this.contentList.getSelectedIndices().length];
        for (n = 0; n < this.contentList.getSelectedIndices().length; ++n) {
            JBoard jBoard = (JBoard)this.geonext.board.get(this.contentList.getSelectedIndices()[n]);
            jComponent = jBoard.board;
            string = string + jComponent.write();
            int n2 = this.geonext.findSetById(jBoard.id);
            if (n2 != -1) {
                ((Vector)this.geonext.boardSets.get(n2)).removeElement(new Integer(jBoard.id));
                if (((Vector)this.geonext.boardSets.get(n2)).get(0) != null && ((String)((Vector)this.geonext.boardSets.get(n2)).get(0)).equals(this.geonext.filepath)) {
                    this.geonext.setBoardSetSaved(n2, false);
                }
                ((Vector)this.geonext.boardSets.get(n2)).set(0, null);
            }
            jComponent.setSaved(true);
            jBoard.filename = this.geonext.filepath;
            nArray[n] = this.geonext.desktopPane.getIndexOf((JBoard)this.geonext.board.get(this.contentList.getSelectedIndices()[n]));
            nArray2[n] = jBoard.id;
        }
        string = string + this.geonext.writeControl(bl2, bl3, nArray) + "</GEONEXT>";
        string = Geonext.convertToUnicode(string);
        if (bl && this.geonext.geonextIODialog == null) {
            n = this.geonext.findSetByFilename(this.geonext.filepath);
            while (n != -1) {
                ((Vector)this.geonext.boardSets.get(n)).set(0, null);
                this.geonext.setBoardSetSaved(n, false);
                n = this.geonext.findSetByFilename(this.geonext.filepath);
            }
            this.geonext.addBoardSet(this.geonext.filepath, string, nArray2);
            if (!this.geonext.filepath.endsWith(".nc.gxt")) {
                string = new Compression().encode(string);
            }
            if (!this.write2disk(string)) {
                for (int i = 0; i < this.contentList.getSelectedIndices().length; ++i) {
                    jComponent = (JBoard)this.geonext.board.get(this.contentList.getSelectedIndices()[i]);
                    JBoardPane jBoardPane = ((JBoard)jComponent).board;
                    jBoardPane.setSaved(false);
                }
            }
        } else {
            string = new Compression().encode(string);
            if (Geonext.parentApplication == null) {
                this.geonext.noAccessSrcText = string;
                this.geonext.geonextIODialog.reset();
            } else {
                this.geonext.returnToParentApplication(string);
            }
        }
    }

    public void saveHTML(boolean bl) {
        int n;
        Object object;
        int n2;
        String string = "";
        string = string + "<GEONEXT>\n<VERSION>" + "1.70" + "</VERSION>\n";
        int[] nArray = new int[this.contentList.getSelectedIndices().length];
        int[] nArray2 = new int[this.contentList.getSelectedIndices().length];
        for (n2 = 0; n2 < this.contentList.getSelectedIndices().length; ++n2) {
            JBoard jBoard = (JBoard)this.geonext.board.get(this.contentList.getSelectedIndices()[n2]);
            object = jBoard.board;
            if (bl && ((JBoardPane)object).jep.backImage != null) {
                if (((JBoardPane)object).backgroundFileExtention.toLowerCase(new Locale("en")).endsWith("gif")) {
                    this.writeFile2disk(((JBoardPane)object).backgroundFile, this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(".")) + ".gxt" + ((JBoardPane)object).backgroundFileExtention);
                    String string2 = this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(".")) + ".gxt" + ((JBoardPane)object).backgroundFileExtention;
                    string2 = string2.substring(string2.lastIndexOf(File.separatorChar) + 1, string2.length());
                    ((JBoardPane)object).setBackImageFileName(string2);
                } else {
                    String string3 = this.geonext.filepath;
                    string3 = string3.substring(string3.lastIndexOf(File.separatorChar) + 1, string3.lastIndexOf("."));
                    ((JBoardPane)object).setBackImageFileName(string3 + ".gxt.png");
                    this.writePNG2disk(((JBoardPane)object).jep.backImage, this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(".")) + ".gxt.png");
                }
            }
            string = string + ((JBoardPane)object).write();
            n = this.geonext.findSetById(jBoard.id);
            if (n != -1) {
                ((Vector)this.geonext.boardSets.get(n)).removeElement(new Integer(jBoard.id));
                ((Vector)this.geonext.boardSets.get(n)).set(0, null);
            }
            ((JBoardPane)object).setSaved(true);
            jBoard.filename = this.geonext.filepath;
            nArray[n2] = this.geonext.desktopPane.getIndexOf((JBoard)this.geonext.board.get(this.contentList.getSelectedIndices()[n2]));
            nArray2[n2] = jBoard.id;
        }
        string = string + this.geonext.writeControl(this.dynBox.isSelected(), this.menuBox.isSelected(), nArray) + "</GEONEXT>";
        string = Geonext.convertToUnicode(string);
        this.geonext.addBoardSet(null, string, nArray2);
        string = new Compression().encode(string);
        n2 = 600;
        int n3 = 500;
        if (this.geonext.extention.equals("html")) {
            try {
                n2 = new Integer(this.widthField.getText());
            }
            catch (Exception exception) {
                n2 = this.geonext.getWidth();
                this.widthField.setText(new Integer(n2).toString());
            }
            try {
                n3 = new Integer(this.heightField.getText());
            }
            catch (Exception exception) {
                n3 = this.geonext.getHeight();
                this.widthField.setText(new Integer(n3).toString());
            }
            object = "";
            if (this.constBox.isSelected()) {
                for (n = 0; n < this.contentList.getSelectedIndices().length; ++n) {
                    object = (String)object + "<h2>" + ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[n])).board.getTitle() + "</h2>\r\n";
                    object = (String)object + ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[n])).board.description(false, false) + "<p>&nbsp;<p>";
                }
            }
            if (bl && this.paramFileBox.isSelected()) {
                String string4 = this.geonext.filepath;
                this.geonext.filepath = string4.substring(0, string4.length() - 5) + ".gxt";
                this.saveGXT(bl, this.dynBox.isSelected(), this.menuBox.isSelected());
                string = this.geonext.filepath.lastIndexOf(File.separatorChar) > -1 ? "file:" + this.geonext.filepath.substring(this.geonext.filepath.lastIndexOf(File.separatorChar) + 1) : "file:" + this.geonext.filepath;
                this.geonext.filepath = string4;
            }
            if (bl && this.jarBox.isSelected()) {
                this.pathField.setText(".");
            }
            string = this.geonext.filepath.toLowerCase(new Locale("en")).endsWith(".applet.html") ? this.createHTML(n2, n3, string, this.pathField.getText(), (String)object, true) : this.createHTML(n2, n3, string, this.pathField.getText(), (String)object, false);
        }
        if (bl) {
            this.write2disk(string);
            if (this.jarBox.isSelected()) {
                this.copyJAR();
            }
        } else {
            this.geonext.noAccessSrcText = string;
            this.geonext.geonextIODialog.reset();
        }
    }

    public void savePNG() {
        JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board;
        Image image = jBoardPane.jep.createImage(jBoardPane.jep.getWidth(), jBoardPane.jep.getHeight());
        jBoardPane.jep.setScreenShot(true);
        jBoardPane.jep.paint(image.getGraphics());
        jBoardPane.jep.setScreenShot(false);
        this.writePNG2disk(image, this.geonext.filepath);
    }

    public void savePS() {
        JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board;
        this.writePS2disk(jBoardPane, this.geonext.filepath);
    }

    public void saveSVG() {
        String string = "";
        double d = 0.0;
        if (this.unitRadio.isSelected()) {
            try {
                d = new Double(this.unitText.getText());
            }
            catch (Exception exception) {
                d = 1.0;
            }
        }
        ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board.jep.paintSVG(this.geonext.filepath, d, this.unitRadio.isSelected());
    }

    public void setDynBox() {
        if (this.dynBox.isSelected()) {
            this.contentList.setSelectionMode(0);
            this.contentList.setSelectedIndex(this.contentList.getSelectedIndices()[0]);
            JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board;
            this.widthField.setText("" + jBoardPane.getWidth());
            if (jBoardPane.isStatusBar()) {
                this.heightField.setText("" + (jBoardPane.getHeight() - jBoardPane.jep.getGraphics().getFontMetrics().getHeight() - 3));
            } else {
                this.heightField.setText("" + jBoardPane.getHeight());
            }
            this.smallBox.setEnabled(false);
            this.menuBox.setEnabled(false);
        } else {
            this.widthField.setText("" + this.geonext.getWidth());
            this.heightField.setText("" + this.geonext.getHeight());
            this.contentList.setSelectionMode(2);
            this.smallBox.setEnabled(true);
            this.menuBox.setEnabled(true);
            this.widthField.setEnabled(true);
            this.heightField.setEnabled(true);
        }
    }

    public void setDynGXTBox() {
        if (this.dynGXTBox.isSelected()) {
            this.contentList.setSelectionMode(0);
            this.contentList.setSelectedIndex(this.contentList.getSelectedIndices()[0]);
            this.smallGXTBox.setEnabled(false);
            this.menuGXTBox.setEnabled(false);
            this.widthField.setEnabled(false);
            this.heightField.setEnabled(false);
        } else {
            this.contentList.setSelectionMode(2);
            this.smallGXTBox.setEnabled(true);
            this.menuGXTBox.setEnabled(true);
            this.widthField.setEnabled(true);
            this.heightField.setEnabled(true);
        }
    }

    public void setRelativePath() {
        String string = this.pathField.getText();
        if (this.relativeBox.isSelected()) {
            this.pathField.setText(this.getRelativePath(this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(File.separatorChar)), string));
        } else if (!this.tmpJarPath.equals("")) {
            this.pathField.setText(this.tmpJarPath + File.separatorChar);
        } else {
            this.pathField.setText(this.geonext.filepath.substring(0, this.geonext.filepath.lastIndexOf(File.separatorChar)) + File.separatorChar);
        }
    }

    public void setSmallBox() {
        Geonext.buttonSize = this.smallBox.isSelected() ? 16 : 24;
    }

    public void setSmallGXTBox() {
        Geonext.buttonSize = this.smallGXTBox.isSelected() ? 16 : 24;
    }

    public void setTmpJarPath(String string) {
        this.tmpJarPath = string;
    }

    public void setUnit() {
        if (this.unitRadio.isSelected()) {
            this.unitText.setEnabled(true);
            this.unitText.setEditable(true);
        } else {
            this.unitText.setEnabled(false);
            this.unitText.setEditable(false);
        }
    }

    public void setUnitText(JTextField jTextField) {
        this.unitText = jTextField;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.generateGSSList();
        if (this.dynBox.isSelected()) {
            this.setDynBox(true);
        }
    }

    public boolean write2disk(String string) {
        try {
            FileWriter fileWriter = new FileWriter(this.geonext.filepath);
            fileWriter.write(string, 0, string.length());
            fileWriter.close();
        }
        catch (Exception exception) {
            JContentSave.saveError();
            return false;
        }
        return true;
    }

    public void writeFile2disk(File file, String string) {
        File file2 = new File(string);
        byte[] byArray = null;
        int n = 0;
        try {
            n = (int)file.length();
            byArray = new byte[n];
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    fileInputStream.read(byArray, 0, n);
                    fileOutputStream.write(byArray, 0, n);
                    fileInputStream.close();
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void copyJAR() {
        String string = ("" + this.geonext.filepath).substring(0, ("" + this.geonext.filepath).lastIndexOf(File.separator) + 1) + "geonext.jar";
        String string2 = "";
        if (Geonext.applicationMode) {
            string2 = "" + this.geonext.getCodeBase();
            if ((string2 = string2.substring(9, string2.length() - 2)).indexOf(File.separator) < 0) {
                try {
                    string2 = string2.replace('/', File.separatorChar);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string2.startsWith("\\")) {
                    string2 = string2.substring(1, string2.length());
                }
            }
            string2 = string2.replaceAll("%20", " ");
            this.writeFile2disk(new File(string2), string);
        } else {
            string2 = "" + this.getClass().getResource("../geonext.jar");
            int n = 0;
            try {
                int n2;
                URL uRL = new URL(string2);
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                InputStream inputStream = uRL.openStream();
                byte[] byArray = new byte[100];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    ++n;
                }
                ((OutputStream)fileOutputStream).close();
                inputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
            }
        }
    }

    public void writePNG2disk(Image image, String string) {
        try {
            File file = new File(string);
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(this), image.getHeight(this), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, image.getWidth(this), image.getHeight(this), Color.WHITE, this);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            JContentSave.saveError();
        }
    }

    public void writePS2disk(JBoardPane jBoardPane, String string) {
        this.setActBoard(jBoardPane);
        DocFlavor.SERVICE_FORMATTED sERVICE_FORMATTED = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        String string2 = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
        StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(sERVICE_FORMATTED, string2);
        if (streamPrintServiceFactoryArray.length != 0) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string + ".ps");
                StreamPrintService streamPrintService = streamPrintServiceFactoryArray[0].getPrintService(fileOutputStream);
                DocPrintJob docPrintJob = streamPrintService.createPrintJob();
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                SimpleDoc simpleDoc = new SimpleDoc(this, sERVICE_FORMATTED, null);
                docPrintJob.print(simpleDoc, hashPrintRequestAttributeSet);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        JBoardPane jBoardPane = this.getActBoard();
        if (jBoardPane != null && n == 0) {
            graphics.drawRect(0, 0, jBoardPane.getWidth(), jBoardPane.getHeight());
            graphics.drawString("\u00a9 2002      http://geonext.de      " + jBoardPane.getTitle(), 0, jBoardPane.getHeight() + graphics.getFontMetrics().getHeight());
            jBoardPane.getJep().setScreenShot(false);
            return 0;
        }
        return 1;
    }

    public JBoardPane getActBoard() {
        return this.actBoard;
    }

    public void setActBoard(JBoardPane jBoardPane) {
        this.actBoard = jBoardPane;
    }

    public void setDynBox(boolean bl) {
        if (bl) {
            this.contentList.setSelectionMode(0);
            this.contentList.setSelectedIndex(this.contentList.getSelectedIndices()[0]);
            JBoardPane jBoardPane = ((JBoard)this.geonext.board.get((int)this.contentList.getSelectedIndices()[0])).board;
            this.widthField.setText("" + jBoardPane.getWidth());
            if (jBoardPane.isStatusBar()) {
                this.heightField.setText("" + (jBoardPane.getHeight() - jBoardPane.jep.getGraphics().getFontMetrics().getHeight() - 3));
            } else {
                this.heightField.setText("" + jBoardPane.getHeight());
            }
            this.smallBox.setEnabled(false);
            this.menuBox.setEnabled(false);
        } else {
            this.widthField.setText("" + this.geonext.getWidth());
            this.heightField.setText("" + this.geonext.getHeight());
            this.contentList.setSelectionMode(2);
            this.smallBox.setEnabled(true);
            this.menuBox.setEnabled(true);
            this.widthField.setEnabled(true);
            this.heightField.setEnabled(true);
        }
    }
}

