/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JContentPanel;
import geonext.JListRenderer;
import geonext.Point;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentValue
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public JComboBox vInput;
    public Vector valueHistory = new Vector();
    public int valueType;
    public Vector element;

    public JContentValue() {
    }

    public JContentValue(JBoardPane jBoardPane, Vector vector) {
        this.board = jBoardPane;
        this.element = vector;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 5));
        jPanel.add(new JLabel("y ="));
        this.vInput = new JComboBox(jBoardPane.valueHistoryString);
        this.vInput.setEditable(true);
        this.vInput.setMaximumRowCount(5);
        this.vInput.setRenderer(new JListRenderer());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1, 15, 15));
        jPanel2.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel2.add(this.vInput);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentvalue_term") + " "));
        jPanel3.add("Center", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(15, 15));
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel4.add("North", new JPanel());
        this.add("North", jPanel3);
        this.validateTree();
        this.vInput.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (!string.equals("close")) {
            if (string.equals("apply")) {
                if (this.testInput()) {
                    switch (this.getValueType()) {
                        case 210030: {
                            String string2 = (String)this.vInput.getSelectedItem();
                            try {
                                double d = new Double(string2);
                                d = d * Math.PI / 180.0;
                                string2 = "" + d;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            String string3 = ((Point)this.element.get(0)).getName();
                            String string4 = ((Point)this.element.get(1)).getName();
                            this.board.createCASPoint("X(" + string3 + ")+Cos(" + string2 + ")*(X(" + string4 + ")-X(" + string3 + "))-Sin(" + string2 + ")*(Y(" + string4 + ")-Y(" + string3 + "))", "Y(" + string3 + ")+Sin(" + string2 + ")*(X(" + string4 + ")-X(" + string3 + "))+Cos(" + string2 + ")*(Y(" + string4 + ")-Y(" + string3 + "))", "", false);
                            break;
                        }
                        case 210060: {
                            this.board.createCircle((Point)this.element.get(0), (String)this.vInput.getSelectedItem(), "", false);
                            break;
                        }
                    }
                    if (!this.board.valueHistoryString.contains((String)this.vInput.getSelectedItem())) {
                        this.board.valueHistoryString.addElement((String)this.vInput.getSelectedItem());
                    }
                }
                this.reset();
                this.board.getGeonextValueDialog().dispose();
            } else if (string.equals("cancel")) {
                this.board.getGeonextValueDialog().dispose();
            }
        }
        this.board.repaint();
    }

    public Vector getElement() {
        return this.element;
    }

    public int getValueType() {
        return this.valueType;
    }

    public void reset() {
        this.vInput.setSelectedItem("");
    }

    public void setElement(Vector vector) {
        this.element = vector;
    }

    public void setValueType(int n) {
        this.valueType = n;
    }

    public boolean testInput() {
        String string = (String)this.vInput.getSelectedItem();
        C.boardName = this.board.internalName;
        boolean bl = true;
        try {
            C.GEV(new Scanner(string, false).start());
        }
        catch (Throwable throwable) {
            this.vInput.setForeground(Color.red);
            bl = false;
        }
        return bl;
    }
}

