/*
 * Decompiled with CFR 0.152.
 */
package geonext;

import com.hartmath.lib.C;
import com.hartmath.lib.Scanner;
import geonext.Geonext;
import geonext.JBoardPane;
import geonext.JCheckBox;
import geonext.JContentPanel;
import geonext.JListRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class JContentXY
extends JContentPanel
implements ActionListener {
    public JBoardPane board;
    public JComboBox xInput;
    public JComboBox yInput;
    JCheckBox spurCheck;
    JCheckBox startCheck;

    public JContentXY() {
    }

    public JContentXY(JBoardPane jBoardPane) {
        this.board = jBoardPane;
        this.setLayout(new BorderLayout(15, 15));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel.setBorder(new EmptyBorder(15, 15, 15, 5));
        jPanel.add(new JLabel("x ="));
        jPanel.add(new JLabel("y ="));
        this.xInput = new JComboBox(jBoardPane.casXHistoryString);
        this.xInput.setEditable(true);
        this.xInput.setMaximumRowCount(5);
        this.xInput.setRenderer(new JListRenderer());
        this.xInput.requestFocus();
        this.yInput = new JComboBox(jBoardPane.casYHistoryString);
        this.yInput.setEditable(true);
        this.yInput.setMaximumRowCount(5);
        this.yInput.setRenderer(new JListRenderer());
        this.yInput.requestFocus();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel2.setBorder(new EmptyBorder(15, 0, 15, 15));
        jPanel2.add(this.xInput);
        jPanel2.add(this.yInput);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentxy_term") + " "));
        jPanel3.add("West", jPanel);
        jPanel3.add("Center", jPanel2);
        this.spurCheck = new JCheckBox(Geonext.language.getString("jcontentxy_trace"));
        this.startCheck = new JCheckBox(Geonext.language.getString("jcontentxy_start"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1, 15, 15));
        jPanel4.setBorder(new EmptyBorder(15, 15, 15, 15));
        jPanel4.add(this.spurCheck);
        jPanel4.add(this.startCheck);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(15, 15));
        jPanel5.setBorder(new TitledBorder(new EtchedBorder(1), " " + Geonext.language.getString("jcontentgraph_options") + " "));
        jPanel5.add("North", jPanel4);
        this.add("North", jPanel3);
        this.add("Center", jPanel5);
        this.validateTree();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.reset();
        } else if (string.equals("close")) {
            if (this.testInput()) {
                if (!this.startCheck.isSelected()) {
                    this.board.createCASPoint((String)this.xInput.getSelectedItem(), (String)this.yInput.getSelectedItem(), null, this.spurCheck.isSelected());
                    if (!this.board.casXHistoryString.contains((String)this.xInput.getSelectedItem())) {
                        this.board.casXHistoryString.addElement((String)this.xInput.getSelectedItem());
                    }
                    if (!this.board.casYHistoryString.contains((String)this.yInput.getSelectedItem())) {
                        this.board.casYHistoryString.addElement((String)this.yInput.getSelectedItem());
                    }
                } else {
                    this.createStartPoint();
                }
            }
            this.reset();
            this.board.getGeonextCASPointDialog().dispose();
        } else if (string.equals("apply")) {
            if (this.testInput()) {
                if (!this.startCheck.isSelected()) {
                    this.board.createCASPoint((String)this.xInput.getSelectedItem(), (String)this.yInput.getSelectedItem(), null, this.spurCheck.isSelected());
                    if (!this.board.casXHistoryString.contains((String)this.xInput.getSelectedItem())) {
                        this.board.casXHistoryString.addElement((String)this.xInput.getSelectedItem());
                    }
                    if (!this.board.casYHistoryString.contains((String)this.yInput.getSelectedItem())) {
                        this.board.casYHistoryString.addElement((String)this.yInput.getSelectedItem());
                    }
                } else {
                    this.createStartPoint();
                }
                this.reset();
            }
            this.xInput.requestFocus();
        } else if (string.equals("cancel")) {
            this.board.getGeonextCASPointDialog().dispose();
        }
        this.board.repaint();
    }

    public void createStartPoint() {
        String string = (String)this.xInput.getSelectedItem();
        String string2 = (String)this.yInput.getSelectedItem();
        C.boardName = this.board.internalName;
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        try {
            d = new Double(C.NEV(new Scanner(string, false).start()).toString());
        }
        catch (Throwable throwable) {
            bl = false;
        }
        try {
            d2 = new Double(C.NEV(new Scanner(string2, false).start()).toString());
        }
        catch (Throwable throwable) {
            bl = false;
        }
        if (bl) {
            this.board.createPoint(this.board.user2screenX(d), this.board.user2screenY(d2), null, this.spurCheck.isSelected());
        }
    }

    public void reset() {
        this.xInput.setSelectedItem("");
        this.yInput.setSelectedItem("");
        this.spurCheck.setSelected(false);
        this.startCheck.setSelected(false);
    }

    public boolean testInput() {
        String string = (String)this.xInput.getSelectedItem();
        String string2 = (String)this.yInput.getSelectedItem();
        C.boardName = this.board.internalName;
        String string3 = "";
        String string4 = "";
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        try {
            string3 = C.NEV(new Scanner(string, false).start()).toString();
            if (!string3.trim().equals("")) {
                d = new Double(string3);
            }
        }
        catch (Throwable throwable) {
            this.xInput.setForeground(Color.red);
            bl = false;
        }
        try {
            string4 = C.NEV(new Scanner(string2, false).start()).toString();
            if (!string4.trim().equals("")) {
                d2 = new Double(string4);
            }
        }
        catch (Throwable throwable) {
            this.yInput.setForeground(Color.red);
            bl = false;
        }
        return bl;
    }
}

