/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import org.kaffe.java.lang.UnsupportedOperationException;
import org.kaffe.java.util.AbstractCollection;
import org.kaffe.java.util.AbstractListIterator;
import org.kaffe.java.util.Collection;
import org.kaffe.java.util.ConcurrentModificationException;
import org.kaffe.java.util.Iterator;
import org.kaffe.java.util.List;
import org.kaffe.java.util.ListIterator;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected int modCount;

    protected AbstractList() {
    }

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
        }
        return collection.size() != 0;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            Object object3 = listIterator2.next();
            if (object2 != null ? object2.equals(object3) : object3 == null) continue;
            return false;
        }
        return true;
    }

    public abstract Object get(int var1);

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = 0;
        while (listIterator.hasNext()) {
            Object object2 = listIterator.next();
            if (object == null ? object2 == null : object.equals(object2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public int lastIndexOf(Object object) {
        ListIterator listIterator = this.listIterator(this.size());
        int n = this.size() - 1;
        while (listIterator.hasPrevious()) {
            Object object2 = listIterator.previous();
            if (object == null ? object2 == null : object.equals(object2)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        return new AbstractListIterator(this, n);
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        while (n < n2 && listIterator.hasNext()) {
            listIterator.remove();
            ++n;
        }
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List subList(final int n, final int n2) {
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        return new AbstractList(){
            private final AbstractList list;
            private int modCount;
            private final int off;
            private int len;
            {
                this.list = AbstractList.this;
                this.modCount = this.list.modCount;
                this.off = n;
                this.len = n2 - n;
            }

            public int size() {
                return this.len;
            }

            public Object get(int n3) {
                if (n3 < 0 || n3 >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                return this.list.get(this.off + n3);
            }

            public Object set(int n3, Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n3 < 0 || n3 >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                return this.list.set(this.off + n3, object);
            }

            public void add(int n3, Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n3 < 0 || n3 > this.len) {
                    throw new IndexOutOfBoundsException();
                }
                this.list.add(this.off + n3, object);
                this.modCount = AbstractList.this.modCount;
                ++this.len;
            }

            public Object remove(int n3) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n3 < 0 || n3 >= this.len) {
                    throw new IndexOutOfBoundsException();
                }
                Object object = this.list.remove(this.off + n3);
                this.modCount = AbstractList.this.modCount;
                --this.len;
                return object;
            }

            public int indexOf(Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                ListIterator listIterator = this.list.listIterator(this.off);
                for (int i = 0; i < this.len && listIterator.hasNext(); ++i) {
                    Object object2 = listIterator.next();
                    if (!(object == null ? object2 == null : object.equals(object2))) continue;
                    return i;
                }
                return -1;
            }

            public int lastIndexOf(Object object) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                ListIterator listIterator = this.listIterator(this.off + this.len);
                int n3 = this.len - 1;
                while (listIterator.hasPrevious()) {
                    Object object2 = listIterator.previous();
                    if (object == null ? object2 == null : object.equals(object2)) {
                        return n3;
                    }
                    --n3;
                }
                return -1;
            }

            protected void removeRange(int n3, int n22) {
                if (this.list.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (n3 < 0 || n22 > this.len) {
                    throw new IndexOutOfBoundsException();
                }
                this.list.removeRange(this.off + n3, this.off + n22);
                this.modCount = AbstractList.this.modCount;
                this.len -= n22 - n3;
            }
        };
    }
}

