/*
 * Decompiled with CFR 0.152.
 */
package org.kaffe.java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.kaffe.java.util.AbstractList;
import org.kaffe.java.util.Collection;
import org.kaffe.java.util.Iterator;
import org.kaffe.java.util.List;

public class ArrayList
extends AbstractList
implements List,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 32;
    private Object[] a;
    private int off;
    private int len;

    public ArrayList() {
        this(32);
    }

    ArrayList(Object[] objectArray) {
        this.off = 0;
        this.len = objectArray.length;
    }

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity < 0");
        }
        this.a = new Object[n];
        this.off = 0;
        this.len = 0;
    }

    public ArrayList(Collection collection) {
        Iterator iterator = collection.iterator();
        this.a = new Object[collection.size() * 11 / 10];
        this.off = 0;
        int n = 0;
        while (iterator.hasNext()) {
            this.a[n] = iterator.next();
            ++n;
        }
        this.len = n;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.len) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.modCount;
        if (this.off > 0 && n < this.len / 2) {
            System.arraycopy(this.a, this.off, this.a, this.off - 1, n);
            --this.off;
        } else {
            this.ensureCapacity(this.len + 1);
            System.arraycopy(this.a, this.off + n, this.a, this.off + n + 1, this.len - n);
        }
        this.modCount = n2 + 1;
        this.a[this.off + n] = object;
        ++this.len;
    }

    public boolean add(Object object) {
        this.add(this.len, object);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.len) {
            throw new IndexOutOfBoundsException();
        }
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        int n3 = this.modCount++;
        if (this.off >= n2 && n < this.len / 2) {
            System.arraycopy(this.a, this.off, this.a, this.off - n2, n);
            this.off -= n2;
        } else {
            this.ensureCapacity(this.len + n2);
            this.modCount = n3 + 1;
            System.arraycopy(this.a, this.off + n, this.a, this.off + n + n2, this.len - n);
        }
        int n4 = this.off + n;
        while (iterator.hasNext()) {
            this.a[n4] = iterator.next();
            ++n4;
        }
        this.len += n2;
        return true;
    }

    public boolean addAll(Collection collection) {
        this.addAll(this.len, collection);
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.len = 0;
        this.off = 0;
    }

    public Object clone() {
        ArrayList arrayList;
        try {
            arrayList = (ArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        arrayList.a = new Object[this.len];
        System.arraycopy(this.a, this.off, arrayList.a, 0, this.len);
        arrayList.off = 0;
        return arrayList;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public void ensureCapacity(int n) {
        int n2;
        if (this.a.length - this.off >= n) {
            return;
        }
        for (n2 = 16; n2 != Integer.MIN_VALUE && n2 - 12 < n; n2 <<= 1) {
        }
        if (n2 == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("too big");
        }
        int n3 = n2 - 12;
        Object[] objectArray = new Object[n3];
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        ++this.modCount;
        this.a = objectArray;
        this.off = 0;
    }

    public Object get(int n) {
        if (n < 0 || n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.a[this.off + n];
    }

    public int indexOf(Object object) {
        for (int i = this.off; i < this.off + this.len; ++i) {
            if (!(object == null ? this.a[i] == null : object.equals(this.a[i]))) continue;
            return i - this.off;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.off + this.len - 1; i >= this.off; --i) {
            if (!(object == null ? this.a[i] == null : object.equals(this.a[i]))) continue;
            return i - this.off;
        }
        return -1;
    }

    public Object remove(int n) {
        Object object = this.a[this.off + n];
        this.removeRange(n, n + 1);
        return object;
    }

    protected void removeRange(int n, int n2) {
        if (n < 0 || n2 > this.len) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        ++this.modCount;
        if (n == 0) {
            this.off += n2;
        } else {
            System.arraycopy(this.a, this.off + n2, this.a, this.off + n, this.len - n2);
        }
        this.len -= n3;
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = this.a[this.off + n];
        this.a[this.off + n] = object;
        return object2;
    }

    public int size() {
        return this.len;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.len];
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.len) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.len);
        }
        System.arraycopy(this.a, this.off, objectArray, 0, this.len);
        if (objectArray.length > this.len) {
            objectArray[this.len] = null;
        }
        return objectArray;
    }

    public void trimToSize() {
        if (this.off != 0 || this.len != this.a.length) {
            Object[] objectArray = new Object[this.len];
            System.arraycopy(this.a, this.off, objectArray, 0, this.len);
            ++this.modCount;
            this.off = 0;
            this.a = objectArray;
        }
    }
}

