
/*
 * id3.c -- written for Juice
 *  Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>								 /* fopen(), fclose(), fread(), fseek(), FILE */
#include <string.h>								 /* strncpy(), strcpy(), strncasecmp() */

#include "typedefs.h"							 /* bool */
#include "utils.h"								 /* fperm(), trim() */
#include "id3.h"								 /* id3_t */
#include "genre.h"								 /* genre_table, GENRE_COUNT */

/* ID3 tag structure */
struct id3
{
   char tag[3];
   char title[30];
   char artist[30];
   char album[30];
   char year[4];
   /* With ID3 v1.0, the comment is 30 chars long */
   /* With ID3 v1.1, if comment[28] == 0 then comment[29] == tracknum */
   char comment[30];
   unsigned char genre;
};

/*
 * Extract tag information from a MP3 file If getid3() returns TRUE,
 * the tag info was available and was extracted succesfully, FALSE
 * if not successful.
 */
bool getid3 (id3_t *tag,const char *filename)
{
   struct id3 buf;
   FILE *handle;
   if (strncasecmp (filename + strlen (filename) - 4,".mp3",3) != 0) return FALSE;
   if (!fperm (filename,"r","r")) return FALSE;
   if ((handle = fopen (filename,"r")) == NULL) return FALSE;
   if (fseek (handle,-128,SEEK_END) != 0)
	 {
		fclose (handle);
		return FALSE;
	 }
   if (fread (&buf,sizeof (buf),1,handle) != 1)
	 {
		fclose (handle);
		return FALSE;
	 }
   fclose (handle);
   if (strncmp (buf.tag,"TAG",3) != 0) return FALSE;
   tag->title[30] = tag->artist[30] = tag->album[30] = tag->year[4] = tag->comment[30] = tag->genre[32] = '\0';
   strncpy (tag->title,buf.title,30);
   trim (tag->title);
   strncpy (tag->artist,buf.artist,30);
   trim (tag->artist);
   strncpy (tag->album,buf.album,30);
   trim (tag->album);
   strncpy (tag->year,buf.year,4);
   trim (tag->year);
   if (buf.comment[28] == 0)	/* v1.1 tag */
	 {
		strcpy (tag->comment,buf.comment);
		tag->has_tracknum = TRUE;
		tag->tracknum = buf.comment[29];
	 }
   else							/* v1.0 tag */
	 {
		strncpy (tag->comment,buf.comment,30);
		tag->has_tracknum = FALSE;
	 }
   trim (tag->comment);
   if (buf.genre < GENRE_COUNT)
	 {
		strncpy (tag->genre,genre_table[buf.genre],31);
		trim (tag->genre);
	 }
   else strcpy (tag->genre,"Unknown");
   return TRUE;
}

