
/*
 * windows.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_WINDOWS_H
#define DIALOGS_WINDOWS_H

#include <panel.h>

typedef struct WinRec
{
   struct WinRec *next;
   PANEL *pan;
   char *title;
   bool manual;
} WinType;

class Windows
{
 public:
   /* Initialize ncurses */
   void Init ();
   /* Close ncurses */
   void Close ();
   /* Create a child Windows class */
   void operator = (const Windows &child);
   /* Add a new window */
   void Add (int cols,int rows,int tlx,int tly,const char *title,int attr,int fg,int bg);
   /* Remove topmost window */
   void Remove ();
   /* Get pointer to topmost window */
   WINDOW *GetWindow ();
   /* Get pointer to topmost panel */
   PANEL *GetPanel ();
   /* Update terminal */
   void Update ();
   /* Force a update of the entire terminal - useful if Ctrl-L is pressed */
   void Refresh ();
   /* Window linked list */
   WinType *window;
 protected:
   /* Create a new panel */
   PANEL *mkpanel (int cols, int rows, int tlx, int tly);
   /* Remove the created panel */
   void rmpanel (PANEL *pan);
   /* Fill panel with specified colors */
   void fillpanel (PANEL *pan,int attr,int fg,int bg);
   /* Draw "double line" frame */
   void doubleframe (PANEL *pan);
   /* Draw "single line" frame */
   void singleframe (PANEL *pan);
   /* Print title */
   void showtitle (PANEL *pan,const char *title);
   /* Draw horizontal lines */
   void horzline (PANEL *pan,int x1,int x2,int y,bool single,bool visible,int left,int right);
   /* Draw vertical lines */
   void vertline (PANEL *pan,int x,int y1,int y2,bool single,bool visible,int top,int bottom);
   /* Set colors and attributes */
   void setcolor (WINDOW *win,int fg,int bg,int attr);
   void setcolor (WINDOW *win,int fg,int bg);
   void setcolor (int fg,int bg,int attr);
   void setcolor (int fg,int bg);
   /* Disable automatic frame drawing for current panel */
   void disableframes ();
   /* Special characters */
   int lcd_vert;								 /* Line char double vertical */
   int lcd_rtee;								 /* Line char double right tee */
   int lcd_tr;									 /* Line char double top right */
   int lcd_bl;									 /* Line char double bottom left */
   int lcd_btee;								 /* Line char double bottom tee */
   int lcd_ttee;								 /* Line char double top tee */
   int lcd_ltee;								 /* Line char double left tee */
   int lcd_horz;								 /* Line char double horizontal */
   int lcd_cross;								 /* Line char double cross */
   int lcd_br;									 /* Line char double bottom right */
   int lcd_tl;									 /* Line char double top left */
   int lcs_vert;								 /* Line char single vertical */
   int lcs_rtee;								 /* Line char single right tee */
   int lcs_tr;									 /* Line char single top right */
   int lcs_bl;									 /* Line char single bottom left */
   int lcs_btee;								 /* Line char single bottom tee */
   int lcs_ttee;								 /* Line char single top tee */
   int lcs_ltee;								 /* Line char single left tee */
   int lcs_horz;								 /* Line char single horizontal */
   int lcs_cross;								 /* Line char single cross */
   int lcs_br;									 /* Line char single bottom right */
   int lcs_tl;									 /* Line char single top left */
   int sc_brick;								 /* Special char brick */
   int sc_dot;									 /* Special char dot */
   int sc_button;								 /* Special char button */
   int sc_scrlbut;								 /* Special char scrollbutton */
};

#endif
