# Examples

Sometimes the best way to learn how to use a new package is to look for
examples of what others have already built with it.

The following packages use Documenter to build their documentation and so
should give a good overview of what this package is currently able to do.

!!! note

    Packages are listed alphabetically. If you have a package that uses Documenter then
    please open a PR that adds it to the appropriate list below; a simple way to do so
    is to navigate to
    https://github.com/JuliaDocs/Documenter.jl/edit/master/docs/src/man/examples.md.

    The `make.jl` file for all listed packages will be tested to check for potential
    regressions prior to tagging new Documenter releases whenever possible.

## Registered

Packages that have tagged versions available in `METADATA.jl`.

- [Augmentor.jl](https://evizero.github.io/Augmentor.jl/)
- [BanditOpt.jl](https://v-i-s-h.github.io/BanditOpt.jl/latest/)
- [BeaData.jl](https://stephenbnicar.github.io/BeaData.jl/latest/)
- [Bio.jl](https://biojulia.net/Bio.jl/latest/)
- [ControlSystems.jl](http://juliacontrol.github.io/ControlSystems.jl/latest/)
- [Currencies.jl](https://juliafinance.github.io/Currencies.jl/latest/)
- [DifferentialEquations.jl](http://docs.juliadiffeq.org/latest/)
- [DiscretePredictors.jl](https://github.com/v-i-s-h/DiscretePredictors.jl)
- [Documenter.jl](https://juliadocs.github.io/Documenter.jl/latest/)
- [EvolvingGraphs.jl](https://etymoio.github.io/EvolvingGraphs.jl/latest/)
- [ExtractMacro.jl](https://carlobaldassi.github.io/ExtractMacro.jl/latest/)
- [EzXML.jl](https://bicycle1885.github.io/EzXML.jl/latest/)
- [FourierFlows.jl](https://FourierFlows.github.io/FourierFlows.jl/latest/)
- [Gadfly.jl](http://gadflyjl.org/stable/)
- [GeoStats.jl](http://juliohm.github.io/GeoStats.jl/latest/)
- [Highlights.jl](https://juliadocs.github.io/Highlights.jl/latest/)
- [IntervalConstraintProgramming.jl](https://juliaintervals.github.io/IntervalConstraintProgramming.jl/latest/)
- [Luxor.jl](https://juliagraphics.github.io/Luxor.jl/stable/)
- [MergedMethods.jl](https://michaelhatherly.github.io/MergedMethods.jl/latest/)
- [Mimi.jl](http://anthofflab.berkeley.edu/Mimi.jl/stable/)
- [NumericSuffixes.jl](https://michaelhatherly.github.io/NumericSuffixes.jl/latest/)
- [OnlineStats.jl](http://joshday.github.io/OnlineStats.jl/latest/)
- [POMDPs.jl](http://juliapomdp.github.io/POMDPs.jl/latest/)
- [PhyloNetworks.jl](http://crsl4.github.io/PhyloNetworks.jl/latest/)
- [PrivateModules.jl](https://michaelhatherly.github.io/PrivateModules.jl/latest/)
- [Query.jl](http://www.queryverse.org/Query.jl/stable/)
- [TaylorSeries.jl](http://www.juliadiff.org/TaylorSeries.jl/latest/)
- [Weave.jl](http://weavejl.mpastell.com/stable/)

## Unregistered

Packages that are not available in `METADATA.jl` and may be works-in-progress.
Please do take that into consideration when browsing this list.

- [AnonymousTypes.jl](https://michaelhatherly.github.io/AnonymousTypes.jl/latest/)
- [OhMyREPL.jl](https://github.com/KristofferC/OhMyREPL.jl)
