<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:exsl="http://exslt.org/common"
                version="1.0"
                exclude-result-prefixes="exsl">

<xsl:import href="../xsl-1.61.2/xhtml/autoidx.xsl"/>
<xsl:import href="../xsl-1.61.2/xhtml/docbook.xsl"/>
<xsl:import href="../xsl-1.61.2/xhtml/chunk-common.xsl"/>
<xsl:include href="../xsl-1.61.2/xhtml/manifest.xsl"/>
<xsl:include href="../xsl-1.61.2/xhtml/chunk-code.xsl"/>

<xsl:output method="xml" 
            encoding="UTF-8" 
            indent="no" 
            doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" 
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"/>

<!-- ==================================================================== -->

<xsl:variable name="K3D_STYLE_VERSION">1.5</xsl:variable>

<xsl:param name="use.id.as.filename">1</xsl:param>
<xsl:param name="chunk.section.depth">1</xsl:param>
<xsl:param name="generate.section.toc">0</xsl:param>
<xsl:param name="toc.section.depth">1</xsl:param>
<xsl:param name="generate.component.toc">0</xsl:param>
<xsl:param name="use.extensions">0</xsl:param>
<xsl:param name="admon.graphics">0</xsl:param>
<xsl:param name="k3d.figures">./figures/</xsl:param>
<xsl:param name="admon.graphics.path"><xsl:value-of select="k3d.figures"/></xsl:param>
<xsl:param name="callout.graphics.path"><xsl:value-of select="k3d.figures"/></xsl:param>

<xsl:param name="generate.toc">
<!--book      toc,title,figure,table,example,equation-->
<!--appendix  toc,title-->
<!--chapter   toc,title-->
<!--preface   toc,title-->
book      toc,title
part      toc,title
qandadiv  toc
qandaset  toc
reference toc,title
sect1     toc
sect2     toc
sect3     toc
sect4     toc
sect5     toc
section   toc
set       toc,title
</xsl:param>

<!-- ==================================================================== -->

<xsl:template name="chunk-element-content">
  <xsl:param name="prev"/>
  <xsl:param name="next"/>
  <xsl:param name="nav.context"/>
  <xsl:param name="content">
    <xsl:apply-imports/>
  </xsl:param>

  <html>
    <xsl:call-template name="html.head">
      <xsl:with-param name="prev" select="$prev"/>
      <xsl:with-param name="next" select="$next"/>
    </xsl:call-template>
    <body>
      <xsl:call-template name="body.attributes"/>
      <div id="header">
      <xsl:call-template name="header.content"/>
      <xsl:call-template name="header.navigation">
        <xsl:with-param name="prev" select="$prev"/>
        <xsl:with-param name="next" select="$next"/>
      </xsl:call-template>
      </div>
      <div id="content">
      <xsl:copy-of select="$content"/>
      </div>
      <div id="footer">
      <xsl:call-template name="footer.navigation">
        <xsl:with-param name="prev" select="$prev"/>
        <xsl:with-param name="next" select="$next"/>
      </xsl:call-template>
      <xsl:call-template name="footer.content"/>
      </div>
    </body>
  </html>
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="user.head.content">
  <link rel="stylesheet" type="text/css"  media="screen" href="k3dDocbookScreen.css" title="Standard" />
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="header.content">
  <!-- We suppres the header content -->
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="header.navigation">
  <!-- We suppres the header navigation -->
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="footer.content">
  <!-- We suppres the footer content -->
</xsl:template>

<!-- ==================================================================== -->

<xsl:template name="footer.navigation">
  <xsl:param name="prev" select="/foo"/>
  <xsl:param name="next" select="/foo"/>
  <xsl:variable name="home" select="/*[1]"/>
  <xsl:variable name="up" select="parent::*"/>
  <xsl:if test="$suppress.navigation = '0'">
  <div id="navPrev">
  <xsl:if test="count($prev)>0">
    &lt;&lt; <a><xsl:attribute name="href">
        <xsl:call-template name="href.target">
           <xsl:with-param name="object" select="$prev"/>
        </xsl:call-template>
      </xsl:attribute>Previous</a>
  </xsl:if>&#160;
  </div>
  <div id="navHome">
  <xsl:choose>
    <xsl:when test="$home != .">
       <a><xsl:attribute name="href">
           <xsl:call-template name="href.target">
              <xsl:with-param name="object" select="$home"/>
           </xsl:call-template>
         </xsl:attribute>Table of Content</a>
    </xsl:when>
    <xsl:otherwise>&#160;</xsl:otherwise>
  </xsl:choose>
  </div>
  <div id="navNext">&#160;
  <xsl:if test="count($next)>0">
    <a><xsl:attribute name="href">
        <xsl:call-template name="href.target">
          <xsl:with-param name="object" select="$next"/>
        </xsl:call-template>
      </xsl:attribute>Next</a> &gt;&gt;
  </xsl:if>
  </div>
  </xsl:if>
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
