#ifndef K3DEMBED_OPTIONS_H
#define K3DEMBED_OPTIONS_H

#include <k3dsdk/ioptions.h>
#include <sdpxml/sdpxml.h>
#include <boost/filesystem/path.hpp>

namespace k3d
{

/// Provides an implementation of k3d::ioptions that serializes user options to disk as an XML document
class user_options :
	public ioptions
{
public:
	user_options(const boost::filesystem::path& OptionsFile);

	void set_defaults();

	const std::string preferred_language();
	void set_preferred_language(const std::string& Language);
	const bool blackbox_recorder_at_startup();
	void set_blackbox_recorder_at_startup(const bool State);
	const bool tutorial_menu_at_startup();
	void set_tutorial_menu_at_startup(const bool State);
	const double tutorial_speed();
	void set_tutorial_speed(const double Speed);
	const bool restore_window_geometry();
	void set_restore_window_geometry(const bool State);
	const std::string html_viewer();
	void set_html_viewer(const std::string& CommandLine);
	const std::string bitmap_viewer();
	void set_bitmap_viewer(const std::string& CommandLine);
	const std::string sl_preprocessor();
	void set_sl_preprocessor(const std::string& CommandLine);
	void default_render_engine(std::string& Type, std::string& Engine, std::string& Name);
	void set_default_render_engine(const std::string& Type, const std::string& Engine);
	const boost::filesystem::path render_farm_path();
	void set_render_farm_path(const boost::filesystem::path& Path);
	const render_engines_t render_engines();
	const boost::filesystem::path most_recent_path(const std::string& Type);
	void set_most_recent_path(const std::string& Type, const boost::filesystem::path& Path);
	const k3d::vector4 window_geometry(const std::string& WindowName);
	void set_window_geometry(const std::string& WindowName, const k3d::vector4& Geometry);

	void commit_options();

private:
	/// Stores the path for persistent storage of user options
	const boost::filesystem::path m_path;
	/// Contains the current set of user options
	sdpxml::Document m_storage;
};

} // namespace k3d

#endif // !K3DEMBED_OPTIONS_H


