#ifndef K3DOBJECTDIALOG_H
#define K3DOBJECTDIALOG_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3dObjectDialog class, which provides a standard dialog implementation for K-3D objects
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3ddialog.h"

// Forward declarations ...
namespace k3d { class iobject; }

/////////////////////////////////////////////////////////////////////////////
// k3dObjectDialog

class k3dObjectDialog :
	public k3dDialog
{
	typedef k3dDialog base;
	
public:
	k3dObjectDialog(k3d::iobject& Object, const bool GrabMouseFocus, const bool AutoDestroy, const bool ShowObjectName, const std::string& CommandNodeName, k3d::window_geometry_store* const GeometryStore);
	virtual ~k3dObjectDialog();

	/// Standard UI shutdown
	void CloseDialog();

	// k3d::icommand_node overrides
	bool execute_command(const std::string& Command, const std::string& Arguments);

	// Events that most dialog-owners need to call ...
	virtual void ObjectDeleted();

protected:
	/// Called to load a GTKML template file (calculates the path to the file and connects to some standard events)
	virtual bool LoadGTKMLTemplate(const boost::filesystem::path& Template);

	// Built-in events that we need to handle ...
	virtual void OnOK();
	virtual void OnClose();

private:
	/// Called by the signal system if the owning object is deleted
	void on_object_deleted();
	/// Called by the signal system if the owning object is renamed
	void on_object_renamed();

	/// Stores the object that owns us
	k3d::iobject& m_object;
	/// Stores whether the owning object will be destroyed when this dialog is closed (typical for tools)
	bool m_AutoDestroy;
	/// Stores whether this dialog should display the owning object's name in its titlebar
	const bool m_ShowObjectName;
};

#endif // !K3DOBJECTDIALOG_H


