#ifndef K3DUSERINTERFACEELEMENT_H
#define K3DUSERINTERFACEELEMENT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3dUserInterfaceElement class, which provides a standard functionality for controls, dialogs, and windows, including automated command-handling
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/command_node.h>
#include <k3dsdk/signal_system.h>
#include <sdpgtk/sdpgtkobjectcontainer.h>

#include <map>

// Forward declarations ...
namespace k3d { namespace bitmap_preview { class control; } }
namespace k3d { namespace button { class control; } }
namespace k3d { namespace check_button { class control; } }
namespace k3d { namespace check_button { class idata_proxy; } }
namespace k3d { namespace chooser { class control; } }
namespace k3d { namespace color_chooser { class control; } }
namespace k3d { namespace color_chooser { class idata_proxy; } }
namespace k3d { namespace combo_box { class control; } }
namespace k3d { class istate_recorder; }
namespace k3d { namespace menu_item { class control; } }
namespace k3d { namespace object_chooser { class control; } }
namespace k3d { namespace orientation { class control; } }
namespace k3d { namespace path_chooser { class control; } }
namespace k3d { namespace position { class control; } }
namespace k3d { namespace property_button { class control; } }
namespace k3d { namespace property_button { class idata_proxy; } }
namespace k3d { namespace scale { class control; } }
namespace k3d { namespace spin_button { class control; } }
namespace k3d { namespace spin_button { class idata_proxy; } }
namespace k3d { namespace toggle_button { class control; } }
namespace k3d { namespace toggle_button { class idata_proxy; } }

/////////////////////////////////////////////////////////////////////////////
// k3dUserInterfaceElement

class k3dUserInterfaceElement :
	public sdpGtkObjectContainer,
	public k3d::command_node,
	public SigC::Object
{
	typedef sdpGtkObjectContainer base;

public:
	k3dUserInterfaceElement(k3d::iunknown* ParentCommandNode, const std::string& CommandNodeName);
	virtual ~k3dUserInterfaceElement();

	// icommand_node implementation
	bool execute_command(const std::string& Command, const std::string& Arguments);

protected:
        /// Allows us to instantiate UI elements using custom tags in the GTKML source document
	sdpGtkObject* CreateCustomObject(sdpxml::Element& Element);

	// Custom control access ...
	k3d::bitmap_preview::control* get_bitmap_preview(const std::string& Name);
	k3d::button::control* get_button(const std::string& Name);
	k3d::check_button::control* get_check_button(const std::string& Name);
	k3d::chooser::control* get_chooser(const std::string& Name);
	k3d::color_chooser::control* get_color_chooser(const std::string& Name);
	k3d::combo_box::control* get_combo_box(const std::string& Name);
	k3d::menu_item::control* get_menu_item(const std::string& Name);
	k3d::object_chooser::control* get_object_chooser(const std::string& Name);
	k3d::path_chooser::control* get_path_chooser(const std::string& Name);
	k3d::property_button::control* get_property_button(const std::string& Name);
	k3d::spin_button::control* get_spin_button(const std::string& Name);
	k3d::position::control* get_position_control(const std::string& Name);
	k3d::scale::control* get_scale_control(const std::string& Name);
	k3d::orientation::control* get_orientation_control(const std::string& Name);
	k3d::toggle_button::control* get_toggle_button(const std::string& Name);
	
	/// Connects a k3d::check_button::control to a data source
	bool connect_check_button(const std::string& Name, std::auto_ptr<k3d::check_button::idata_proxy> Data, k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName);
	/// Connects a k3d::color_chooser::control to a data source
	bool connect_color_chooser(const std::string& Name, std::auto_ptr<k3d::color_chooser::idata_proxy> Data, k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName);
	/// Connects a k3d::property_button::control to a data source
	bool connect_property_button(const std::string& Name, std::auto_ptr<k3d::property_button::idata_proxy> Data, k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName);
	/// Connects a k3d::spin_button::control to a data source
	bool connect_spin_button(const std::string& Name, std::auto_ptr<k3d::spin_button::idata_proxy> Data, k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName);
};

#endif // K3DUSERINTERFACEELEMENT_H

