// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements procedures required to export K-3D objects from the libk3dbitmap module
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the imagemagick plugin module, to protect public symbols from name clashes with other modules
namespace libk3dimagemagick
{

extern k3d::iplugin_factory& imagemagick_reader_factory();
extern k3d::iplugin_factory& imagemagick_writer_factory();

} // namespace libk3dimagemagick

K3D_MODULE_START(k3d::uuid(0xb265e1c4, 0xa1e1482c, 0xa9f23d87, 0x4080d6fc), Registry)
	Registry.register_factory(libk3dimagemagick::imagemagick_reader_factory());
	Registry.register_factory(libk3dimagemagick::imagemagick_writer_factory());
K3D_MODULE_END


