// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the register_k3d_plugins entry-point required of all K-3D modules
		\author Tim Shead (tshead@k-3d.com)
		\author Brett W. McCoy (bmccoy@chapelperilous.net)
*/

#include <k3dsdk/module.h>

/// Namespace reserved for the ode plugin module, to protect public symbols from name clashes with other modules
namespace libk3dode
{

extern k3d::iplugin_factory& body_factory();
extern k3d::iplugin_factory& collidable_factory();
extern k3d::iplugin_factory& world_factory();
extern k3d::iplugin_factory& hingejoint_factory();

} // namespace libk3dode

K3D_MODULE_START(k3d::uuid(0x85b2e0ca, 0x75fb4126, 0x9fc65f20, 0xba7edc56), Registry)
	Registry.register_factory(libk3dode::body_factory());
	Registry.register_factory(libk3dode::collidable_factory());
	Registry.register_factory(libk3dode::world_factory());
        Registry.register_factory(libk3dode::hingejoint_factory());
K3D_MODULE_END

