//javascript

function Innovate(Document)
{
	// Give folks a chance to bail ...
	if(2 == Application.ui.QueryMessage("Are you sure?  Don't run this script on a real working document!", "innovation:", "OK", "Cancel", ""))
		return;

	// Start recording changes for undo-purposes ...
	Document.StartChangeSet();

	// Deliver "value" ...
	var objects = Document.objects;
	for(object in objects)
		objects[object].name = "Microsoft " + objects[object].name + " (TM)";

	// Finish recording undos ...
	Document.FinishChangeSet("Innovate!");

	// Communicate the good news to our "customer"!
	Application.ui.Message("You have been Innovated ... check your document hierarchy (it's undo-able)", "innovation:");
}

/// Boilerplate to determine which document to modify ...
function FindDocument(ScriptName)
{
	if(Document)
			return Document;
	else
			{
					if(Application.documents.length == 1)
							return Application.documents[0];
					else if(Application.documents.length == 0)
							Application.ui.ErrorMessage("You must have an open document to run this script!", ScriptName + ":");
					else
							Application.ui.ErrorMessage("Not sure which document to use ... try using the desired document's Document Window > Tools > Play Script.", ScriptName + ":");
			}
			
	return null;
}


document = FindDocument("innovation");
if(document)
	Innovate(document);

