//javascript

/// Boilerplate to determine which document to modify ...
function FindDocument(ScriptName)
{
	if(Document)
			return Document;
	else
			{
					if(Application.documents.length == 1)
							return Application.documents[0];
					else if(Application.documents.length == 0)
							Application.ui.ErrorMessage("You must have an open document to run this script!", ScriptName + ":");
					else
							Application.ui.ErrorMessage("Not sure which document to use ... try using the desired document's Document Window > Tools > Play Script.", ScriptName + ":");
			}
			
	return null;
}

function CreateShadowMap(Document, Name)
{
	var shadow_map = Document.CreateObject("ShadowMap");
	shadow_map.name = Name;

	return shadow_map;
}

var gtkml =
	'<gtkml>' +
		'<window type="toplevel" title="point_shadowmaps">' +
			'<vbox homogeneous="false">' +
				'<hbox homogeneous="false" expand="true">' +
					'<label labelpadding="4">Enter root name for Shadow Maps:</label>' + 
					'<entry name="name">Shadow Map</entry>' +
				'</hbox>' + 
				'<hbuttonbox layout="end">' +
					'<button>OK' + 
						'<event signal="clicked" name="ok"/>' + 
					'</button>' +
					'<button>Cancel' +
						'<event signal="clicked" name="cancel"/>' +
					'</button>' +
				'</hbuttonbox>' +
			'</vbox>' +
		'</window>' +
	'</gtkml>';

document = FindDocument("point_shadowmaps");
if(document)
	{
		dialog = new GTKMLContainer(gtkml);
		if(dialog.DoModal())
			{
				// Record undo/redo data ...
				document.StartChangeSet();

				var root_name = dialog.Field("name");
				var front = CreateShadowMap(document, root_name + " Front");
				var back = CreateShadowMap(document, root_name + " Back");
				var left = CreateShadowMap(document, root_name + " Left");
				var right = CreateShadowMap(document, root_name + " Right");
				var top = CreateShadowMap(document, root_name + " Top");
				var bottom = CreateShadowMap(document, root_name + " Bottom");

				// Finish recording undo/redo data (no need to record the rest of our changes) ...
				document.FinishChangeSet("Create point shadowmaps");

				back.orientation = [0, 180, 0];
				left.orientation = [0, 90, 0];
				right.orientation = [0, -90, 0];
				top.orientation = [90, 0, 0];
				bottom.orientation = [-90, 0, 0];
			}
	}

