#ifndef SDPGTKFONTSELECTION_H
#define SDPGTKFONTSELECTION_H

// SDPGTK Library
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the sdpGtkFontSelection class, which encapsulates a GtkFontSelection widget
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include "sdpgtknotebook.h"

////////////////////////////////////////////////////////////////////////////////////////////////
// sdpGtkFontSelection

/// Encapsulates a GtkFontSelection widget
class sdpGtkFontSelection : public sdpGtkNotebook
{
public:
	/// Standard constructor
	sdpGtkFontSelection();
	/// Attaches this instance to an existing GtkFontSelection widget
	sdpGtkFontSelection(GtkFontSelection* FontSelection);

	/// Creates a new GtkFontSelection widget
	bool Create();
	/// Creates a new GtkFontSelection widget from a GTKML (XML) document
	bool Create(sdpGtkIObjectContainer* const ObjectContainer, sdpxml::Document& Document, sdpxml::Element& Element);

	/// Returns the font name selected by the user
	sdpString GetFontName();
	/// Returns the font selected by the user
	GdkFont* GetFont();
	/// Sets the initial font name
	bool SetFontName(SDPCSTRING FontName);

	/// Returns the text used to preview fonts
	sdpString GetPreviewText();
	/// Sets the text for previewing fonts
	void SetPreviewText(SDPCSTRING Text);

	/// Casts this instance into a GtkFontSelection pointer
	operator GtkFontSelection*() { return GTK_FONT_SELECTION(m_Object); }
};

#endif // SDPGTKFONTSELECTION_H

