%define version 0.2.5.4
%define release 4mdk
%define prefix /usr
%define qtdir /usr/lib/qt3

Name: k3d
Summary: K-3D open-source 3D modeling, animation, and rendering system.
Version: %{version}
Release: %{release}
License: GPL
Group: Sciences/other
Source: %{name}-%{version}-src.tar.bz2
BuildRoot: %{_tmppath}/build-root-%{name}
Provides: k3d
Requires: freetype2
Requires: libk3d >= %{version}
requires: XFree86-libs >= 4.2.0, gtk+ >= 1.2.10, glib >= 1.2.10, glibc >= 2.2.5, libstdc++ >= 2.96, libGLU.so.1, libGL.so.1
BuildREquires: plib-devel,docbook-dtd31-sgml,graphviz
Packager: Torbjrn Turpeinen <tobbe@nyvalls.se>
Distribution: Mandrake 9.0
Prefix: %{prefix}
Url: http://k3d.sourceforge.net/new/

%description
K-3D is a 3D modeling, animation, and rendering system
for GNU/Linux & Win32. Features include creation and
editing of geometry in multiple realtime OpenGL solid,
shaded, and texture-mapped views; unlimited undos and
redos; complete extensibility at runtime through
third-party plugins; animated procedural geometric
effects; all parameters animatable through a
consistent control-spline based interface; rendering
pipeline to Renderman Interface compliant rendering
engines; optimization for use with the BMRT rendering
engine, which features raytracing, radiosity
rendering, true displacement, and user programmable
shaders; and support for background and batch
rendering.

%package -n libk3d
Summary: k3d libs
Copyright: GPL
Group: System/Libraries
Requires: k3d >= %{version}

%description -n libk3d
libs that is used for k3d.

%package -n libk3d-devel
Summary: k3d libs
Copyright: GPL
Group: System/Libraries
Requires: libk3d >= %{version}

%description -n libk3d-devel
libs that is used for k3d.

%prep
rm -rf $RPM_BUILD_ROOT
mkdir $RPM_BUILD_ROOT

%setup -q

%build
# Workaround for legacy auto* tools
[ -x /usr/bin/autoconf-2.5? ] && ln -s /usr/bin/autoconf-2.5? autoconf
[ -x /usr/bin/autoheader-2.5? ] && ln -s /usr/bin/autoheader-2.5? autoheader
[ -x /usr/bin/autom4te-2.5? ] && ln -s /usr/bin/autom4te-2.5? autom4te
export PATH="`pwd`:$PATH"
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS -Wall" \
./configure --prefix=%{_datadir}/k3d --bindir=%{_bindir} --mandir=%{_mandir} \
--includedir=%{_includedir} --with-qt-dir=%{_libdir}/qt3 --enable-kde-menu=%_datadir/applnk/ \
--enable-static=no --enable-shared=yes  \
--with-python --with-graphviz #--with-ruby=/usr/lib/ruby/1.6/i586-linux-gnu
make

%install
make DESTDIR=$RPM_BUILD_ROOT install-strip

# fix a k3d wrapper
echo 'export LD_LIBRARY_PATH=/usr/share/k3d/lib:$LD_LIBRARY_PATH' > $RPM_BUILD_ROOT/usr/bin/k3d-start
echo '/usr/bin/k3d --basepath /usr/share/k3d $*' >> $RPM_BUILD_ROOT/usr/bin/k3d-start
chmod 755 $RPM_BUILD_ROOT/usr/bin/k3d-start

#menu
mkdir -p $RPM_BUILD_ROOT%{_menudir}

#fix k3d.desktop
perl -pi -e "s|/usr/share/k3d/bin/k3d|/usr/bin/k3d||g;" %buildroot%_datadir/applnk/Multimedia/Graphics/k3d.desktop
perl -pi -e "s|\[sv_SE.ISO8859-15\]|||g;" %buildroot%_datadir/applnk/Multimedia/Graphics/k3d.desktop
kdedesktop2mdkmenu.pl k3d "Multimedia/Graphics" %buildroot%_datadir/applnk/Multimedia/Graphics/k3d.desktop %buildroot/%_menudir/k3d

#fix sdplib dox
cp $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/README $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/README.sdptypes
cp $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/COPYING $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/COPYING.sdptypes
cp $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/ChangeLog $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/ChangeLog.sdptypes
cp $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/TODO $RPM_BUILD_DIR/%{name}-%{version}/sdptypes/TODO.sdptypes
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/README $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/README.sdpgl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/COPYING $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/COPYING.sdpgl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/ChangeLog $RPM_BUILD_DIR/%{name}-%{version}/sdpgl/ChangeLog.sdpgl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/README $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/README.sdpxml
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/COPYING $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/COPYING.sdpxml
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/ChangeLog $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/ChangeLog.sdpxml
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/TODO $RPM_BUILD_DIR/%{name}-%{version}/sdpxml/TODO.sdpxml
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/README $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/README.sdpgtk
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/COPYING $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/COPYING.sdpgtk
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/ChangeLog $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/ChangeLog.sdpgtk
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/TODO $RPM_BUILD_DIR/%{name}-%{version}/sdpgtk/TODO.sdpgtk
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/README $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/README.sdpsl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/COPYING $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/COPYING.sdpsl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/ChangeLog $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/ChangeLog.sdpsl
cp $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/TODO $RPM_BUILD_DIR/%{name}-%{version}/sdpsl/TODO.sdpsl

%clean
rm -rf $RPM_BUILD_ROOT

%post
%{update_menus}

%postun
%{clean_menus}

%post -n libk3d
ldconfig

%postun -n libk3d
ldconfig

%files
%defattr(-,root,root,0755)
%doc AUTHORS COPYING ChangeLog NEWS README INSTALL TODO
%{_datadir}/k3d/share/doc/k3d/user_reference/*
%{_bindir}/*
%{_datadir}/applnk/*
%{_datadir}/k3d/share/icons/*
%{_datadir}/k3d/share/projects/*
%{_datadir}/k3d/share/*.conf
%{_menudir}/*
%{_datadir}/k3d/tutorials/*
%{_datadir}/k3d/scripts/*
%{_mandir}/man1/*

%files -n libk3d
%defattr(-,root,root)
%doc sdptypes/*.sdptypes sdpgl/*.sdpgl  sdpxml/*.sdpxml sdpgtk/*.sdpgtk sdpsl/*.sdpsl
%{_datadir}/k3d/lib/*sdp*.so*
%{_datadir}/k3d/lib/*k3d*.so*

%files -n libk3d-devel
%defattr(-,root,root)
%{_datadir}/k3d/share/doc/k3d/developer_guide/*
%{_includedir}/k3d/k3dsdk/*
%{_datadir}/k3d/lib/*k3d*.la
%{_includedir}/k3d/*sdp*
%{_datadir}/k3d/lib/*sdp*.la


%changelog
* Sat Feb 15 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 0.2.5.4-4mdk
- Include sdplibs in k3dlibs

* Sat Feb 15 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 0.2.5.4-3mdk
- Rebuilt for Mandrake 9.0

* Sat Feb 15 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 0.2.5.4-2mdk
- Rebuilt for Mandrake 9.0

* Fri Feb 14 2003 Torbjorn Turpeinen <tobbe@nyvalls.se> 0.2.5.4-1mdk
- Rebuilt for Mandrake 9.0
