#ifndef K3DSDK_TRANSFORM_H
#define K3DSDK_TRANSFORM_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "algebra.h"

namespace k3d
{

// Forward declarations
class euler_angles;
class iunknown;
class vector3;

/// Returns an object's position in world coordinates (returns the origin for non-transformable objects)
const vector3 world_position(iunknown& Object);

/// Sets an object's position (if possible)
bool set_position(iunknown& Object, const vector3& Position);
/// Sets an object's orientation (if possible)
bool set_orientation(iunknown& Object, const angle_axis& Orientation);
/// Sets an object's scale (if possible)
bool set_scale(iunknown& Object, const vector3& Scale);

/// Returns a complete, concatenated, object-to-world transformation matrix for the given transformable object.  Returns the identity matrix for non-transformable objects.
const matrix4 object_to_world_matrix(iunknown& Object);
/// Returns a complete, concatenated, world-to-object transformation matrix for the given transformable object.  Returns the identify matrix for non-transformable objects.
const matrix4 world_to_object_matrix(iunknown& Object);
/// Returns a complete, concatenated transformation matrix to transform from one object space to another.  Uses identity matrices for non-transformable objects.
const matrix4 object_to_object_matrix(iunknown& From, iunknown& To);

} // namespace k3d

#endif // K3DSDK_TRANSFORM_H


