#ifndef K3DUI_OBJECT_CONTEXT_MENU_H
#define K3DUI_OBJECT_CONTEXT_MENU_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace k3d
{

// Forward declarations
class icommand_node;
class idocument;
class iobject;

namespace context_menu
{

/// Provides a dynamically-generated context menu that adapts itself to display operations applicable to a specific document object
class object
{
public:
	object(idocument& Document);
	~object();

	/// Displays the context menu, customized to the capabilities of the given object
	void show(icommand_node* const ParentCommandNode, iobject& Object);

private:
	class implementation;
	implementation* const m_implementation;
};

} // namespace context_menu

} // namespace k3d

#endif // !K3DUI_OBJECT_CONTEXT_MENU_H

