// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements the dag_window class, which displays a hierarchical view of an open K-3D document, using CHierarchyControl
		\author Tim Shead (tshead@k-3d.com)
*/

#include "dag_control.h"
#include "dag_window.h"
#include "k3ddialog.h"
#include "menu_item.h"

#include <k3dsdk/iapplication.h>
#include <k3dsdk/idocument.h>
#include <k3dsdk/result.h>

#include <sdpgtk/sdpgtkevents.h>

// We have an unfortunate clash with X
#ifdef RootWindow
#undef RootWindow
#endif // RootWindow

namespace
{

const std::string control_fileclose = "fileclose";

} // namespace

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// dag_window::implementation

class dag_window::implementation :
	public k3dDialog
{
	typedef k3dDialog base;

public:
	implementation(idocument& Document) :
		base(&Document, "dag_window", new options_window_geometry_store()),
		m_document(Document),
		m_dag_control(Document, this, "dag_control")
	{
		return_if_fail(LoadGTKMLTemplate("dag_window.gtkml"));

		if(get_menu_item("file_close"))
			get_menu_item("file_close")->signal_activate().connect(m_close_signal.slot());

		Container("dag").Attach(m_dag_control.root_widget());

		update_titlebar();
		Show();
	}


	~implementation()
	{
	}

	typedef SigC::Signal0<void> close_signal_t;

	close_signal_t& close_signal()
	{
		return m_close_signal;
	}

private:
	void OnDelete(sdpGtkEvent* Event)
	{
		// Don't let it happen ...
		((sdpGtkEventWidgetDeleteEvent*)Event)->SetResult(true);
		m_close_signal.emit();
	}

	void update_titlebar()
	{
		RootWindow().SetTitle(m_document.title());
	}

	idocument& m_document;
	dag_control::control m_dag_control;
	close_signal_t m_close_signal;
};

//////////////////////////////////////////////////////////////////
// dag_window

dag_window::dag_window(idocument& Document) :
	m_implementation(new implementation(Document))
{
	Document.close_signal().connect(SigC::slot(*this, &dag_window::on_close));
	m_implementation->close_signal().connect(SigC::slot(*this, &dag_window::on_close));
}

dag_window::~dag_window()
{
	delete m_implementation;
}

void dag_window::on_close()
{
	delete this;
}

} // namespace k3d
