#ifndef K3DUI_FILTER_SELECTOR_PRIVATE_H
#define K3DUI_FILTER_SELECTOR_PRIVATE_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <sdpgtk/sdpgtkobjectcontainer.h>
#include <boost/filesystem/path.hpp>

namespace k3d
{

namespace implementation_private
{

/////////////////////////////////////////////////////////////////////////////
// filter_selector

class filter_selector :
	public sdpGtkObjectContainer
{
public:
	filter_selector(const std::string Title, const boost::filesystem::path& FilePath);
	~filter_selector();

protected:
	/// Stores a mapping of human-readable-text to format-filter names
	typedef std::map<std::string, std::string> filter_choices;
	filter_choices m_choices;

	/// Stores the filepath to be read-from / written-to
	const boost::filesystem::path m_file;

	/// Returns the user's combo-box selection (could be empty-string)
	const std::string choice();
	/// Returns true iff the user OK'ed the dialog, false otherwise
	bool do_modal(GtkWindow* TransientOwner);

private:
	typedef sdpGtkObjectContainer base;

	void OnEvent(sdpGtkEvent* Event);
	void OnOK();
	void OnCancel();
	void OnDelete(sdpGtkEvent* const Event);

	/// Set to true iff the user OKs the dialog
	bool m_ok;
};

} // namespace implementation_private

} // namespace k3d

#endif // !K3DUI_FILTER_SELECTOR_PRIVATE_H


