#include "keyboard.h"

namespace k3d
{

const key_modifiers convert(const GdkModifierType Modifiers)
{
	key_modifiers result;

	result.set_shift(Modifiers & GDK_SHIFT_MASK);
	result.set_lock(Modifiers & GDK_LOCK_MASK);
	result.set_control(Modifiers & GDK_CONTROL_MASK);
	result.set_mod1(Modifiers & GDK_MOD1_MASK);
	result.set_mod2(Modifiers & GDK_MOD2_MASK);
	result.set_mod3(Modifiers & GDK_MOD3_MASK);
	result.set_mod4(Modifiers & GDK_MOD4_MASK);
	result.set_mod5(Modifiers & GDK_MOD5_MASK);
	result.set_button1(Modifiers & GDK_BUTTON1_MASK);
	result.set_button2(Modifiers & GDK_BUTTON2_MASK);
	result.set_button3(Modifiers & GDK_BUTTON3_MASK);
	result.set_button4(Modifiers & GDK_BUTTON4_MASK);
	result.set_button5(Modifiers & GDK_BUTTON5_MASK);
	result.set_release(Modifiers & GDK_RELEASE_MASK);

	return result;
}

const GdkModifierType convert(const key_modifiers Modifiers)
{
	int result = 0;
	
	if(Modifiers.shift()) result |= GDK_SHIFT_MASK;
	if(Modifiers.lock()) result |= GDK_LOCK_MASK;
	if(Modifiers.control()) result |= GDK_CONTROL_MASK;
	if(Modifiers.mod1()) result |= GDK_MOD1_MASK;
	if(Modifiers.mod2()) result |= GDK_MOD2_MASK;
	if(Modifiers.mod3()) result |= GDK_MOD3_MASK;
	if(Modifiers.mod4()) result |= GDK_MOD4_MASK;
	if(Modifiers.mod5()) result |= GDK_MOD5_MASK;
	if(Modifiers.button1()) result |= GDK_BUTTON1_MASK;
	if(Modifiers.button2()) result |= GDK_BUTTON2_MASK;
	if(Modifiers.button3()) result |= GDK_BUTTON3_MASK;
	if(Modifiers.button4()) result |= GDK_BUTTON4_MASK;
	if(Modifiers.button5()) result |= GDK_BUTTON5_MASK;
	if(Modifiers.release()) result |= GDK_RELEASE_MASK;
	
	return static_cast<GdkModifierType>(result);
}

} // namespace k3d

