#ifndef K3DUI_TUTORIAL_RECORDER_H
#define K3DUI_TUTORIAL_RECORDER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::tutorial_recorder class, which provides a UI for recording tutorials interactively
		\author Tim Shead (tshead@k-3d.com)
*/

#include "text_editors.h"

namespace k3d
{

// Forward declarations ...
class iscript_engine;

/////////////////////////////////////////////////////////////////////////////
// tutorial_recorder

/// Implements the application user interface
class tutorial_recorder :
	public k3dScriptEditor
{
	typedef k3dScriptEditor base;

public:
	tutorial_recorder(k3d::icommand_node& Parent);
	~tutorial_recorder();

private:
	/// Called by the signal system when the application is closed
	void on_application_closed();
	/// Called by the signal system whenever a command is emitted
	void on_command(k3d::icommand_node* CommandNode, k3d::icommand_node::command_t::type_t Type, std::string Command, std::string Arguments);

	// Template design pattern methods
	const std::string get_title();
	const std::string get_titlebar_text();
	void on_create_new_document();

	/// Overrides sdpGtkObjectContainer to handle custom events
	void OnEvent(sdpGtkEvent* Event);
	/// Called to begin interactive recording
	void on_record();
	/// Called to end interactive recording
	void on_stop();
	/// Called to record a tutorial message
	void on_record_message();
	/// Called to play the current script, starting with the current cursor position
	void on_play_from_cursor();

	/// Script engine for the script being recorded
	k3d::iscript_engine* const m_script_engine;
	/// Set to "true" during script recording
	bool m_recording;
};

} // namespace k3d

#endif // K3DUI_TUTORIAL_RECORDER_H


