#include <k3dsdk/log.h>
#include <k3dsdk/module.h>
#include <k3dsdk/object.h>

#include <iostream>

namespace libk3dmymodule
{

class myplugin :
	public k3d::object
{
public:
	myplugin(k3d::idocument& Document) :
		k3d::object(Document)
	{
		std::cerr << debug << "Howdy, World!" << std::endl;
	}

	~myplugin()
	{
		std::cerr << debug << "Goodbye, Cruel World!" << std::endl;
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<k3d::document_plugin<myplugin> > factory(
			k3d::uuid(0x35b34163, 0xa1ee432a, 0x8f8503d2, 0xf09e7ac7),
			"MyPlugin",
			"My first K-3D plugin",
			"Objects",
			k3d::iplugin_factory::EXPERIMENTAL);

		return factory;
	}
};

} // namespace libk3dmymodule

K3D_MODULE_START(k3d::uuid(0x3edefa05, 0xd5ed4f35, 0x89c1f0f6, 0x2b1e0648), Registry)
	Registry.register_factory(libk3dmymodule::myplugin::get_factory());
K3D_MODULE_END
