########################################################
# K3D_CHECK_X86 - tests to see if we're building for an x86 platform

AC_DEFUN([K3D_CHECK_X86], [
AC_MSG_CHECKING([for an x86 CPU])

if echo $target_cpu | grep "i.86" >/dev/null 2>/dev/null; then
	AC_MSG_RESULT([found $x86])
	AC_DEFINE([K3D_HAVE_X86], [1], [Define to 1 if you are building for an architecture that uses an Intel x86 CPU])
else
	AC_MSG_RESULT([not found])
fi

])

########################################################
# K3D_CHECK_VARARGS - handles per-platform behavior for varargs macros

AC_DEFUN([K3D_CHECK_VARARGS], [
	AC_MSG_CHECKING([for va_copy() or __va_copy])
	
	AC_LINK_IFELSE([
		#include <stdarg.h>
		int main(int argc, char* argv[])
		{
			va_list ap1,ap2;
			va_copy(ap1,ap2);
			return 0;
		}
		],
		[k3d_have_va_copy=yes], [k3d_have_va_copy=no])

	AC_LINK_IFELSE([
		#include <stdarg.h>
		int main(int argc, char* argv[])
		{
			va_list ap1,ap2;
			__va_copy(ap1,ap2);
			return 0;
		}
		],
		[k3d_have___va_copy=yes], [k3d___have_va_copy=no])

	if test x"$k3d_have_va_copy" = x"yes"; then
		AC_DEFINE(HAVE_VA_COPY, 1, [Define to 1 if either va_copy or __va_copy is available])
		AC_DEFINE(VA_COPY, va_copy, [Define to the specific version of va_copy or __va_copy that is available])
		AC_MSG_RESULT([found va_copy])
	elif test x"$k3d_have___va_copy" = x"yes"; then
		AC_DEFINE(HAVE_VA_COPY, 1, [Define to 1 if either va_copy or __va_copy is available])
		AC_DEFINE(VA_COPY, __va_copy, [Define to the specific version of va_copy or __va_copy that is available])
		AC_MSG_RESULT([found __va_copy])
	else
		AC_MSG_RESULT([found neither])
	fi
])

########################################################
# K3D_CHECK_PLATFORM - tests to see what platform we're building on - posix, darwin, etc.

AC_DEFUN([K3D_CHECK_PLATFORM], [
AC_SUBST(host)
AC_MSG_CHECKING([for platform])

case $host in
  *-*-darwin*)
  	AC_MSG_RESULT([found Darwin (including Mac OS-X)])
	AC_DEFINE([K3D_PLATFORM_DARWIN], [1], [Define to 1 if you are building K-3D on Darwin (including Mac OS-X)])
	k3d_platform_darwin=true
	;;
  *)
	AC_MSG_RESULT([defaulting to posix])
	AC_DEFINE([K3D_PLATFORM_POSIX], [1], [Define to 1 if you are building K-3D on most Posix platforms, including GNU/Linux])
	k3d_platform_posix=true
	;;

esac
])

########################################################
# K3D_CHECK_OPENGL - tests for an installed OpenGL library

AC_DEFUN([K3D_CHECK_OPENGL], [
AC_SUBST(K3D_OPENGL_CFLAGS)
AC_SUBST(K3D_OPENGL_LIBS)
AC_MSG_CHECKING([for OpenGL])

k3d_check_opengl_lib_dir=""
k3d_check_opengl_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
	if test -f $k3d_check_opengl_directory/libGL.so || test -f $k3d_check_opengl_directory/libGL.a || test -f $k3d_check_opengl_directory/libGL.dll.a; then
		k3d_check_opengl_lib_dir=$k3d_check_opengl_directory
	fi
done

k3d_check_opengl_header_dir=""
k3d_check_opengl_directories="/usr/include /usr/local/include /usr/X11R6/include"
for k3d_check_opengl_directory in $k3d_check_opengl_directories; do
	if test -f $k3d_check_opengl_directory/GL/gl.h; then
		k3d_check_opengl_header_dir=$k3d_check_opengl_directory
	fi
done

if test -n $k3d_check_opengl_lib_dir && test -n $k3d_check_opengl_header_dir; then
	K3D_OPENGL_CFLAGS="-I$k3d_check_opengl_header_dir"
	K3D_OPENGL_LIBS="-L$k3d_check_opengl_lib_dir -lGL -lpthread"
	AC_MSG_RESULT([found in $k3d_check_opengl_lib_dir and $k3d_check_opengl_header_dir])
else
	AC_MSG_ERROR([OpenGL required but not found])
fi

])

########################################################
# K3D_CHECK_OPENGLU - tests for an installed OpenGLU library

AC_DEFUN([K3D_CHECK_OPENGLU], [
AC_SUBST(K3D_OPENGLU_CFLAGS)
AC_SUBST(K3D_OPENGLU_LIBS)
AC_MSG_CHECKING([for OpenGLU])

k3d_check_openglu_lib_dir=""
k3d_check_openglu_directories="/usr/lib /usr/local/lib /usr/X11R6/lib"
for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
	if test -f $k3d_check_openglu_directory/libGLU.so || test -f $k3d_check_openglu_directory/libGLU.a || test -f $k3d_check_openglu_directory/libGLU.dll.a; then
		k3d_check_openglu_lib_dir=$k3d_check_openglu_directory
	fi
done

k3d_check_openglu_header_dir=""
k3d_check_openglu_directories="/usr/include /usr/local/include /usr/X11R6/include"
for k3d_check_openglu_directory in $k3d_check_openglu_directories; do
	if test -f $k3d_check_openglu_directory/GL/gl.h; then
		k3d_check_openglu_header_dir=$k3d_check_openglu_directory
	fi
done

if test -n $k3d_check_openglu_lib_dir && test -n $k3d_check_openglu_header_dir; then
	K3D_OPENGLU_CFLAGS="-I$k3d_check_openglu_header_dir"
	K3D_OPENGLU_LIBS="-L$k3d_check_openglu_lib_dir -lGLU"
	AC_MSG_RESULT([found in $k3d_check_openglu_lib_dir and $k3d_check_openglu_header_dir])
else
	AC_MSG_ERROR([OpenGLU required but not found])
fi

])

########################################################
# K3D_CHECK_COMPILERS

AC_DEFUN([K3D_CHECK_COMPILERS], [

AC_ARG_WITH(gcc-2-96, [  --with-gcc-2-96         build using gcc 2.96, which may generate unusable executables [[no]]],[],[withval=no])
if test x"$withval" = xyes; then
	k3d_use_gcc_2_96="yes"
fi

AC_MSG_CHECKING([for problematic compiler versions])

if $CXX --version | grep "2\.96" >/dev/null 2>/dev/null; then

	AC_MSG_RESULT([found gcc 2.96])

	if test "$k3d_use_gcc_2_96" = yes; then
		AC_MSG_WARN([

Building K-3D with gcc 2.96.  This is an unofficial release of gcc that has been known to
produce unusable K-3D executables.  If you have problems, our recommendation is that you
switch to gcc 2.95 or gcc 3.0 or above.
])
	else
		AC_MSG_ERROR([

It appears that you're using gcc 2.96.  This is an unofficial release of gcc that has been known to produce
unusable K-3D executables.  It's possible that an incremental upgrade to gcc 2.96 may have fixed whatever
problems existed in the past, so you may re-run configure with the --with-gcc-2-96 option to override this test.
If you do so and continue to have problems, our recommendation is that you switch to gcc 2.95 or gcc 3.0 or above.
])
	fi

else

	AC_MSG_RESULT([none found])

fi

])

########################################################
# K3D_COMPILER_FLAGS

AC_DEFUN([K3D_COMPILER_FLAGS], [
AC_SUBST(K3D_CFLAGS)
AC_SUBST(K3D_CPPFLAGS)
AC_SUBST(K3D_CXXFLAGS)

K3D_CFLAGS="-Wall"
K3D_CPPFLAGS="-I\$(top_srcdir) -I\$(top_builddir)"
K3D_CXXFLAGS="-Wall -Wno-ctor-dtor-privacy"

])

########################################################
# K3D_HAPY_CONFIG

AC_DEFUN([HAPY_CHECK_SPN_STRING_COMPARE], [
AC_CACHE_CHECK(for non-standard std::string::compare profile,
	ac_cv_have_spn_string_compare, [
        AC_TRY_COMPILE([
                #include <string>
        ],[
                const string s1 = "abcd";
                const string s2 = "bc";
		return (s1.compare(s2, 1, s2.size()) == 0) ? 0 : 255;
        ],[
                ac_cv_have_spn_string_compare="yes";
        ],[
                ac_cv_have_spn_string_compare="no";
        ])
])
if test "x$ac_cv_have_spn_string_compare" = xyes; then
        AC_DEFINE(HAPY_HAVE_SPN_STRING_COMPARE, 1, [Define to 1 if you have non-standard std::string::compare profile])
fi
])

AC_DEFUN([HAPY_CHECK_NUMERIC_LIMITS], [
AC_CACHE_CHECK(for std::numeric_limits,
	ac_cv_have_numeric_limits, [
        AC_TRY_COMPILE([
                #include <limits>
		// try #including non-standard ones too?
        ],[
		return std::numeric_limits<unsigned long>::max() == 0;
        ],[
                ac_cv_have_numeric_limits="yes";
        ],[
                ac_cv_have_numeric_limits="no";
        ])
])
if test "x$ac_cv_have_numeric_limits" = xyes; then
        AC_DEFINE(HAPY_HAVE_NUMERIC_LIMITS, 1, [Define to 1 if you have std::numeric_limits template])
fi
])

AC_DEFUN([HAPY_CHECK_STD_ITERATOR_TYPE], [
AC_CACHE_CHECK(for std::iterator, ac_cv_have_std_iterator_type, [
	AC_TRY_COMPILE([
		#include <iterator>
		template <typename V, typename D>
		struct std_bidirectional_iterator:
			public std::iterator<std::bidirectional_iterator_tag, V, D> {
		};
	],[
		typedef std_bidirectional_iterator<int*,int> MyIterator;
		return 0;
	],[
		ac_cv_have_std_iterator_type="yes";
	],[
		ac_cv_have_std_iterator_type="no";
	])
])
if test "x$ac_cv_have_std_iterator_type" = xyes; then
        AC_DEFINE(HAPY_HAVE_STD_ITERATOR_TYPE, 1, [Define to 1 if you have std::iterator template])
fi
])

