// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/i18n.h>
#include <k3dsdk/node.h>
#include <k3dsdk/persistent.h>
#include <k3dsdk/module.h>

namespace libk3dcore
{

class scalar_rand :
	public k3d::persistent<k3d::node>
{
	typedef k3d::persistent<k3d::node> base;
public:
	scalar_rand(k3d::idocument& Document) :
		base(Document),
		m_seed(init_owner(*this) + init_name("seed") + init_label(_("Seed")) + init_description(_("seed")) + init_value(0)),
		m_output(init_owner(*this) + init_name("output") + init_label(_("Output value")) + init_description(_("Pseudo-random output")) + init_slot(sigc::mem_fun(*this, &scalar_rand::get_value)))
	{
		m_seed.changed_signal().connect(sigc::mem_fun(*this, &scalar_rand::reset_rand));
		m_seed.changed_signal().connect(m_output.changed_signal().make_slot());
	}

	void reset_rand()
	{
		srand(m_seed.value());
	}

	double get_value()
	{
		return std::rand();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<k3d::document_plugin<scalar_rand> > factory(
			k3d::uuid(0x14d8ab55, 0x1a014938, 0x9e1ad629, 0x86181375),
			"ScalarPseudoRand",
			_("Produce pseudo-random output"),
			"Scalar",
			k3d::iplugin_factory::EXPERIMENTAL);

		return factory;
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

private:
	k3d_data(unsigned long, immutable_name, change_signal, with_undo, local_storage, no_constraint, writable_property, with_serialization) m_seed;
	k3d_data(double, immutable_name, change_signal, no_undo, computed_storage, no_constraint, read_only_property, no_serialization) m_output;

};

k3d::iplugin_factory& scalar_rand_factory()
{
	return scalar_rand::get_factory();
}

} //namespace libk3dcore


