#ifndef NGUI_SCALE_TOOL_H
#define NGUI_SCALE_TOOL_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
		\author Romain Behar (romainbehar@yahoo.com)
*/

#include "tool.h"

namespace libk3dngui
{

/////////////////////////////////////////////////////////////////////////////
// scale_tool

/// Tool implementation that provides standard node/mesh scaling
class scale_tool :
	public tool
{
	typedef tool base;

public:
	scale_tool(document_state& DocumentState, const std::string& Name);
	~scale_tool();

	bool execute_command(const std::string& Command, const std::string& Arguments);

private:
	virtual void on_activate();
	virtual void on_deactivate();
	virtual void on_document_selection_changed();
	virtual void on_redraw(viewport::control& Viewport);
	virtual void on_select(viewport::control& Viewport);
	k3d::iproperty_collection* get_property_collection();
	iuser_input_model& get_input_model();

	struct implementation;
	implementation* const m_implementation;
};

} // namespace libk3dngui

#endif // NGUI_SCALE_TOOL_H

