#ifndef NGUI_SCRIPTING_H
#define NGUI_SCRIPTING_H

// K-3D
// Copyright (c) 1995-2005, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares convenience functions for working with scripts
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/fstream.h>
#include <k3dsdk/ideletable.h>
#include <k3dsdk/iscript_engine.h>

#include <fstream>

namespace k3d { class uuid; }
namespace boost { namespace filesystem { class path; } }

namespace libk3dngui
{

/// Executes the contents of a file as a script, autodetecting the script language and providing user feedback for errors
bool execute_script(const boost::filesystem::path& Script, k3d::iscript_engine::context_t& Context);
/// Executes the contents of a string as a script, autodetecting the script language and providing user feedback for errors
bool execute_script(const std::string& Script, const std::string& ScriptName, k3d::iscript_engine::context_t& Context);
/// Executes the contents of a stream as a script, autodetecting the script language and providing user feedback for errors
bool execute_script(std::istream& Script, const std::string& ScriptName, k3d::iscript_engine::context_t& Context);
/// Executes the contents of a stream as a script, providing user feedback for errors, using the specific language
bool execute_script(std::istream& Script, const std::string& ScriptName, k3d::iscript_engine::context_t& Context, const k3d::uuid& Engine);

} // namespace libk3dngui

#endif // NGUI_SCRIPTING_H


