// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
	\author Tim Shead (tshead@k-3d.com)
*/

#include <gtkmm/widget.h>

#include "document_state.h"
#include "target.h"
#include "viewport.h"

#include <k3dsdk/algebra.h>
#include <k3dsdk/icamera.h>
#include <k3dsdk/log.h>
#include <k3dsdk/mesh.h>
#include <k3dsdk/property.h>
#include <k3dsdk/result.h>
#include <k3dsdk/transform.h>

#include <iostream>

namespace libk3dngui
{

void aim_selection(document_state& DocumentState, viewport::control& Viewport)
{
	// Get the new target position in world coordinates ...
	k3d::vector3 target = k3d::vector3(0, 0, 0);

	unsigned long count = 0;
	const k3d::nodes_t current_selection = DocumentState.selected_nodes();
	for(k3d::nodes_t::const_iterator selection = current_selection.begin(); selection != current_selection.end(); ++selection)
	{
		target += k3d::world_position(**selection);
		++count;
	}

	if(count)
		target /= count;
	
	const k3d::matrix4 view_matrix = Viewport.get_view_matrix();
	const k3d::normal3 look_vector = k3d::look_vector(view_matrix);
	const k3d::normal3 up_vector = k3d::up_vector(view_matrix);
	const k3d::normal3 right_vector = k3d::right_vector(view_matrix);
	const k3d::vector3 position = k3d::position(view_matrix);
	
	const k3d::normal3 new_look_vector = k3d::to_normal(target - position);
	const k3d::normal3 new_right_vector = new_look_vector ^ Viewport.get_up_axis();
	const k3d::normal3 new_up_vector = new_right_vector ^ new_look_vector;
	
	Viewport.set_view_matrix(k3d::view_matrix(new_look_vector, new_up_vector, new_right_vector, position));
	Viewport.set_target(target);
}

void frame_selection(document_state& DocumentState, viewport::control& Viewport)
{
	// Get the new target position in world coordinates ...
	k3d::vector3 target = k3d::vector3(0, 0, 0);

	unsigned long count = 0;
	const k3d::nodes_t current_selection = DocumentState.selected_nodes();
	for(k3d::nodes_t::const_iterator selection = current_selection.begin(); selection != current_selection.end(); ++selection)
	{
		target += k3d::world_position(**selection);
		++count;
	}
	
	if(count)
		target /= count;

	const k3d::matrix4 view_matrix = Viewport.get_view_matrix();
	const k3d::normal3 look_vector = k3d::look_vector(view_matrix);
	const k3d::normal3 up_vector = k3d::up_vector(view_matrix);
	const k3d::normal3 right_vector = k3d::right_vector(view_matrix);
	const k3d::vector3 position = k3d::position(view_matrix);

	const k3d::normal3 delta = k3d::to_normal(target - Viewport.get_target());
	
	Viewport.set_view_matrix(k3d::view_matrix(look_vector, up_vector, right_vector, position + delta));
	Viewport.set_target(target);
}

} // namespace libk3dngui

